/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.type.RedstoneRail;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftPoweredRail
extends CraftBlockData
implements RedstoneRail {
    private static final BlockStateBoolean POWERED = BlockPoweredRail.d;
    private static final BlockStateEnum<BlockPropertyTrackPosition> SHAPE = BlockPoweredRail.c;
    private static final BlockStateBoolean WATERLOGGED = BlockMinecartTrackAbstract.a;

    public CraftPoweredRail(IBlockData state) {
        super(state);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }

    public Rail.Shape getShape() {
        return this.get(SHAPE, Rail.Shape.class);
    }

    public void setShape(Rail.Shape shape) {
        Preconditions.checkArgument((shape != null ? 1 : 0) != 0, (Object)"shape cannot be null!");
        Preconditions.checkArgument((shape != Rail.Shape.NORTH_EAST && shape != Rail.Shape.NORTH_WEST && shape != Rail.Shape.SOUTH_EAST && shape != Rail.Shape.SOUTH_WEST ? 1 : 0) != 0, (Object)"Invalid rail shape, only straight rail are allowed for this property!");
        this.set(SHAPE, shape);
    }

    public Set<Rail.Shape> getShapes() {
        return this.getValues(SHAPE, Rail.Shape.class);
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

