/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.SideChainPart;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.SideChaining;
import org.bukkit.block.data.type.Shelf;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftShelf
extends CraftBlockData
implements Shelf {
    private static final BlockStateEnum<EnumDirection> FACING = ShelfBlock.c;
    private static final BlockStateBoolean POWERED = ShelfBlock.b;
    private static final BlockStateEnum<SideChainPart> SIDE_CHAIN_PART = ShelfBlock.d;
    private static final BlockStateBoolean WATERLOGGED = ShelfBlock.e;

    public CraftShelf(IBlockData state) {
        super(state);
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }

    public SideChaining.ChainPart getSideChain() {
        return this.get(SIDE_CHAIN_PART, SideChaining.ChainPart.class);
    }

    public void setSideChain(SideChaining.ChainPart chainPart) {
        Preconditions.checkArgument((chainPart != null ? 1 : 0) != 0, (Object)"chainPart cannot be null!");
        this.set(SIDE_CHAIN_PART, chainPart);
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

