/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.Optionull;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventorySaddledHorse;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.AbstractHorseInventory;

public abstract class CraftAbstractHorse
extends CraftAnimals
implements AbstractHorse {
    public CraftAbstractHorse(CraftServer server, EntityHorseAbstract entity) {
        super(server, entity);
    }

    @Override
    public EntityHorseAbstract getHandle() {
        return (EntityHorseAbstract)this.entity;
    }

    public void setVariant(Horse.Variant variant) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getDomestication() {
        return this.getHandle().ht();
    }

    public void setDomestication(int value) {
        Preconditions.checkArgument((value >= 0 && value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication level (%s) need to be between %s and %s (max domestication)", (Object)value, (Object)0, (Object)this.getMaxDomestication());
        this.getHandle().t(value);
    }

    public int getMaxDomestication() {
        return this.getHandle().hy();
    }

    public void setMaxDomestication(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Max domestication (%s) cannot be zero or less", (int)value);
        this.getHandle().maxDomestication = value;
    }

    public double getJumpStrength() {
        return this.getHandle().i(GenericAttributes.q);
    }

    public void setJumpStrength(double strength) {
        Preconditions.checkArgument((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength (%s) cannot be less than zero", (Object)strength);
        this.getHandle().h(GenericAttributes.q).a(strength);
    }

    public boolean isTamed() {
        return this.getHandle().hn();
    }

    public void setTamed(boolean tamed) {
        this.getHandle().y(tamed);
    }

    public AnimalTamer getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUUID());
    }

    public void setOwner(AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.getHandle().setTarget(null, null);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public UUID getOwnerUniqueId() {
        return this.getOwnerUUID();
    }

    public UUID getOwnerUUID() {
        return Optionull.a(this.getHandle().ae_(), EntityReference::c);
    }

    public void setOwnerUUID(UUID uuid) {
        this.getHandle().dn = uuid == null ? null : EntityReference.a(uuid);
    }

    public boolean isEatingHaystack() {
        return this.getHandle().hq();
    }

    public void setEatingHaystack(boolean eatingHaystack) {
        this.getHandle().A(eatingHaystack);
    }

    public AbstractHorseInventory getInventory() {
        return new CraftInventorySaddledHorse(this.getHandle().cM, this.getHandle().h(EnumItemSlot.g), this.getHandle().h(EnumItemSlot.h));
    }

    public boolean isEatingGrass() {
        return this.getHandle().hq();
    }

    public void setEatingGrass(boolean eating) {
        this.getHandle().A(eating);
    }

    public boolean isRearing() {
        return this.getHandle().hr();
    }

    public void setRearing(boolean rearing) {
        if (rearing) {
            this.getHandle().v(Integer.MAX_VALUE);
        } else {
            this.getHandle().hA();
        }
    }

    public boolean isEating() {
        return this.getHandle().isMouthOpen();
    }

    public void setEating(boolean eating) {
        this.getHandle().setMouthOpen(eating);
    }
}

