/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.util.OldEnumHolderable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.feline.CatVariant;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTameableAnimal;
import org.bukkit.entity.Cat;

public class CraftCat
extends CraftTameableAnimal
implements Cat {
    public CraftCat(CraftServer server, EntityCat entity) {
        super(server, entity);
    }

    @Override
    public EntityCat getHandle() {
        return (EntityCat)this.entity;
    }

    public Cat.Type getCatType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().hd());
    }

    public void setCatType(Cat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        this.getHandle().b(CraftType.bukkitToMinecraftHolder(type));
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().hf().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public void setLyingDown(boolean lyingDown) {
        this.getHandle().A(lyingDown);
    }

    public boolean isLyingDown() {
        return this.getHandle().he();
    }

    public void setHeadUp(boolean headUp) {
        this.getHandle().B(headUp);
    }

    public boolean isHeadUp() {
        return this.getHandle().hk();
    }

    public static class CraftType
    extends OldEnumHolderable<Cat.Type, CatVariant>
    implements Cat.Type {
        private static int count = 0;

        public static Cat.Type minecraftHolderToBukkit(Holder<CatVariant> minecraft) {
            return (Cat.Type)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.aT);
        }

        public static Holder<CatVariant> bukkitToMinecraftHolder(Cat.Type bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftType(Holder<CatVariant> holder) {
            super(holder, count++);
        }
    }
}

