/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import org.bukkit.Location;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnemy;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMob;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.EnderDragon;

public class CraftEnderDragon
extends CraftMob
implements EnderDragon,
CraftEnemy {
    public CraftEnderDragon(CraftServer server, EntityEnderDragon entity) {
        super(server, entity);
    }

    @Override
    public EntityEnderDragon getHandle() {
        return (EntityEnderDragon)this.entity;
    }

    public Set<ComplexEntityPart> getParts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EntityComplexPart part : this.getHandle().gM()) {
            builder.add((Object)((ComplexEntityPart)part.getBukkitEntity()));
        }
        return builder.build();
    }

    public EnderDragon.Phase getPhase() {
        return EnderDragon.Phase.values()[this.getHandle().aD().a(EntityEnderDragon.a)];
    }

    public void setPhase(EnderDragon.Phase phase) {
        this.getHandle().gN().a(CraftEnderDragon.getMinecraftPhase(phase));
    }

    public static EnderDragon.Phase getBukkitPhase(DragonControllerPhase phase) {
        return EnderDragon.Phase.values()[phase.b()];
    }

    public static DragonControllerPhase getMinecraftPhase(EnderDragon.Phase phase) {
        return DragonControllerPhase.a(phase.ordinal());
    }

    public BossBar getBossBar() {
        DragonBattle battle = this.getDragonBattle();
        return battle != null ? battle.getBossBar() : null;
    }

    public DragonBattle getDragonBattle() {
        return this.getHandle().gO() != null ? new CraftDragonBattle(this.getHandle().gO()) : null;
    }

    public int getDeathAnimationTicks() {
        return this.getHandle().cu;
    }

    public Location getPodium() {
        return CraftLocation.toBukkit((BaseBlockPosition)this.getHandle().getPodium(), this.getWorld());
    }

    public void setPodium(Location location) {
        if (location == null) {
            this.getHandle().setPodium(null);
        } else {
            Preconditions.checkArgument((location.getWorld() == null || location.getWorld().equals((Object)this.getWorld()) ? 1 : 0) != 0, (Object)"You cannot set a podium in a different world to where the dragon is");
            this.getHandle().setPodium(CraftLocation.toBlockPosition(location));
        }
    }
}

