/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.material.MaterialData;

public class CraftEnderman
extends CraftMonster
implements Enderman {
    public CraftEnderman(CraftServer server, EntityEnderman entity) {
        super(server, entity);
    }

    @Override
    public EntityEnderman getHandle() {
        return (EntityEnderman)this.entity;
    }

    public boolean teleportRandomly() {
        return this.getHandle().gP();
    }

    public MaterialData getCarriedMaterial() {
        IBlockData blockData = this.getHandle().gQ();
        return blockData == null ? Material.AIR.getNewData((byte)0) : CraftMagicNumbers.getMaterial(blockData);
    }

    public BlockData getCarriedBlock() {
        IBlockData blockData = this.getHandle().gQ();
        return blockData == null ? null : CraftBlockData.fromData(blockData);
    }

    public void setCarriedMaterial(MaterialData data) {
        this.getHandle().c(CraftMagicNumbers.getBlock(data));
    }

    public void setCarriedBlock(BlockData blockData) {
        this.getHandle().c(blockData == null ? null : ((CraftBlockData)blockData).getState());
    }

    public boolean isScreaming() {
        return this.getHandle().gR();
    }

    public void setScreaming(boolean screaming) {
        this.getHandle().setCreepy(screaming);
    }

    public boolean hasBeenStaredAt() {
        return this.getHandle().gS();
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.getHandle().setHasBeenStaredAt(hasBeenStaredAt);
    }

    public boolean teleport() {
        return this.getHandle().gP();
    }

    public boolean teleportTowards(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity cannot be null");
        return this.getHandle().H(((CraftEntity)entity).getHandle());
    }
}

