/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.TagValueInput;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.entity.EntityFactory;
import org.bukkit.entity.EntitySnapshot;
import org.slf4j.Logger;

public class CraftEntityFactory
implements EntityFactory {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CraftEntityFactory instance = new CraftEntityFactory();

    private CraftEntityFactory() {
    }

    public EntitySnapshot createEntitySnapshot(String input) {
        EntityTypes type;
        NBTTagCompound tag;
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"Input string cannot be null");
        try {
            tag = MojangsonParser.a(input);
        }
        catch (CommandSyntaxException e2) {
            throw new IllegalArgumentException("Could not parse Entity: " + input, e2);
        }
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "createEntitySnapshot", LOGGER);){
            type = EntityTypes.a(TagValueInput.createGlobal(problemReporter, tag)).orElse(null);
        }
        if (type == null) {
            throw new IllegalArgumentException("Could not parse Entity: " + input);
        }
        return CraftEntitySnapshot.create(tag, CraftEntityType.minecraftToBukkit(type));
    }

    public static CraftEntityFactory instance() {
        return instance;
    }
}

