/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityProcessor;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.slf4j.Logger;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final NBTTagCompound data;
    private final EntityType type;

    private CraftEntitySnapshot(NBTTagCompound data, EntityType type) {
        this.data = data;
        this.type = type;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public Entity createEntity(World world) {
        net.minecraft.world.entity.Entity internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity internal = this.createInternal(location.getWorld());
        internal.a_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)internal.getBukkitEntity());
    }

    public String getAsString() {
        return this.data.toString();
    }

    private net.minecraft.world.entity.Entity createInternal(World world) {
        WorldServer level = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity internal = EntityTypes.a(this.data, (net.minecraft.world.level.World)level, EntitySpawnReason.r, EntityProcessor.a);
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).a(level, EntitySpawnReason.r);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "EntitySnapshot#createEntity", LOGGER);){
            internal.d(TagValueInput.createGlobal(problemReporter, this.data));
        }
        return internal;
    }

    public NBTTagCompound getData() {
        return this.data;
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "create@" + String.valueOf(entity.getUniqueId()), LOGGER);){
            TagValueOutput output = TagValueOutput.a(problemReporter, CraftRegistry.getMinecraftRegistry());
            if (!entity.getHandle().saveAsPassenger(output, false, false, false)) {
                CraftEntitySnapshot craftEntitySnapshot = null;
                return craftEntitySnapshot;
            }
            CraftEntitySnapshot craftEntitySnapshot = new CraftEntitySnapshot(output.b(), entity.getType());
            return craftEntitySnapshot;
        }
    }

    public static CraftEntitySnapshot create(NBTTagCompound tag, EntityType type) {
        if (tag == null || tag.j() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(NBTTagCompound tag) {
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "create", LOGGER);){
            EntityType type = EntityTypes.a(TagValueInput.createGlobal(problemReporter, tag)).map(CraftEntityType::minecraftToBukkit).orElse(null);
            CraftEntitySnapshot craftEntitySnapshot = CraftEntitySnapshot.create(tag, type);
            return craftEntitySnapshot;
        }
    }
}

