/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.EntityFireworks;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CraftFirework
extends CraftProjectile
implements Firework {
    private final Random random = new Random();

    public CraftFirework(CraftServer server, EntityFireworks entity) {
        super(server, entity);
    }

    @Override
    public EntityFireworks getHandle() {
        return (EntityFireworks)this.entity;
    }

    public FireworkMeta getFireworkMeta() {
        return (FireworkMeta)CraftItemStack.getItemMeta(this.getHandle().aD().a(EntityFireworks.b), (ItemType)ItemType.FIREWORK_ROCKET);
    }

    public void setFireworkMeta(FireworkMeta meta) {
        this.applyFireworkEffect(meta);
        this.getHandle().i = 10 * (1 + meta.getPower()) + this.random.nextInt(6) + this.random.nextInt(7);
        this.getHandle().aD().markDirty(EntityFireworks.b);
    }

    public boolean setAttachedTo(LivingEntity entity) {
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().j = entity != null ? ((CraftLivingEntity)entity).getHandle() : null;
        this.getHandle().aD().a(EntityFireworks.c, entity != null ? OptionalInt.of(entity.getEntityId()) : OptionalInt.empty());
        return true;
    }

    public LivingEntity getAttachedTo() {
        EntityLiving entity = this.getHandle().j;
        return entity != null ? (LivingEntity)entity.getBukkitEntity() : null;
    }

    public boolean setLife(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be greater than or equal to 0");
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().h = ticks;
        return true;
    }

    public int getLife() {
        return this.getHandle().h;
    }

    public boolean setMaxLife(int ticks) {
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be greater than 0");
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().i = ticks;
        return true;
    }

    public int getMaxLife() {
        return this.getHandle().i;
    }

    public void detonate() {
        this.setLife(this.getMaxLife() + 1);
    }

    public boolean isDetonated() {
        return this.getHandle().h > this.getHandle().i;
    }

    public boolean isShotAtAngle() {
        return this.getHandle().f();
    }

    public void setShotAtAngle(boolean shotAtAngle) {
        this.getHandle().aD().a(EntityFireworks.d, shotAtAngle);
    }

    public UUID getSpawningEntity() {
        return this.getHandle().spawningEntity;
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().e());
    }

    public void setItem(ItemStack itemStack) {
        FireworkMeta meta = this.getFireworkMeta();
        net.minecraft.world.item.ItemStack nmsItem = itemStack == null ? EntityFireworks.s() : CraftItemStack.asNMSCopy(itemStack);
        this.getHandle().aD().a(EntityFireworks.b, nmsItem);
        this.applyFireworkEffect(meta);
    }

    public int getTicksFlown() {
        return this.getHandle().h;
    }

    public void setTicksFlown(int ticks) {
        this.getHandle().h = ticks;
    }

    public int getTicksToDetonate() {
        return this.getHandle().i;
    }

    public void setTicksToDetonate(int ticks) {
        this.getHandle().i = ticks;
    }

    void applyFireworkEffect(FireworkMeta meta) {
        net.minecraft.world.item.ItemStack item = this.getHandle().e();
        CraftItemStack.applyMetaToItem(item, (ItemMeta)meta);
        this.getHandle().aD().a(EntityFireworks.b, item);
    }
}

