/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import net.minecraft.Optionull;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.item.EntityItem;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftItem
extends CraftEntity
implements Item {
    private static final int NO_AGE_TIME = Short.MIN_VALUE;
    private static final int NO_PICKUP_TIME = Short.MAX_VALUE;

    public CraftItem(CraftServer server, EntityItem entity) {
        super(server, entity);
    }

    @Override
    public EntityItem getHandle() {
        return (EntityItem)this.entity;
    }

    public ItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().e());
    }

    public void setItemStack(ItemStack stack) {
        this.getHandle().a(CraftItemStack.asNMSCopy(stack));
    }

    public int getPickupDelay() {
        return this.getHandle().l;
    }

    public void setPickupDelay(int delay) {
        this.getHandle().l = Math.min(delay, Short.MAX_VALUE);
    }

    public void setUnlimitedLifetime(boolean unlimited) {
        this.getHandle().k = unlimited ? Short.MIN_VALUE : this.getTicksLived();
    }

    public boolean isUnlimitedLifetime() {
        return this.getHandle().k == Short.MIN_VALUE;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        if (!this.isUnlimitedLifetime()) {
            this.getHandle().k = value;
        }
    }

    public boolean canMobPickup() {
        return this.getHandle().canMobPickup;
    }

    public void setCanMobPickup(boolean canMobPickup) {
        this.getHandle().canMobPickup = canMobPickup;
    }

    public boolean canPlayerPickup() {
        return this.getHandle().l != Short.MAX_VALUE;
    }

    public void setCanPlayerPickup(boolean canPlayerPickup) {
        this.getHandle().l = canPlayerPickup ? 0 : Short.MAX_VALUE;
    }

    public boolean willAge() {
        return this.getHandle().k != Short.MIN_VALUE;
    }

    public void setWillAge(boolean willAge) {
        this.getHandle().k = willAge ? 0 : Short.MIN_VALUE;
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state may not be null");
        this.getHandle().frictionState = state;
    }

    public int getHealth() {
        return this.getHandle().m;
    }

    public void setHealth(int health) {
        if (health <= 0) {
            this.getHandle().e().a(this.getHandle());
            this.getHandle().discard(EntityRemoveEvent.Cause.PLUGIN);
        } else {
            this.getHandle().m = health;
        }
    }

    public void setOwner(UUID uuid) {
        this.getHandle().b(uuid);
    }

    public UUID getOwner() {
        return this.getHandle().o;
    }

    public void setThrower(UUID uuid) {
        this.getHandle().n = uuid == null ? null : EntityReference.a(uuid);
    }

    public UUID getThrower() {
        return Optionull.a(this.getHandle().n, EntityReference::c);
    }
}

