/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.panda.EntityPanda;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.entity.Panda;

public class CraftPanda
extends CraftAnimals
implements Panda {
    public CraftPanda(CraftServer server, EntityPanda entity) {
        super(server, entity);
    }

    @Override
    public EntityPanda getHandle() {
        return (EntityPanda)this.entity;
    }

    public Panda.Gene getMainGene() {
        return CraftPanda.fromNms(this.getHandle().gU());
    }

    public void setMainGene(Panda.Gene gene) {
        this.getHandle().a(CraftPanda.toNms(gene));
    }

    public Panda.Gene getHiddenGene() {
        return CraftPanda.fromNms(this.getHandle().gV());
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.getHandle().b(CraftPanda.toNms(gene));
    }

    public void setSneezeTicks(int ticks) {
        this.getHandle().t(ticks);
    }

    public int getSneezeTicks() {
        return this.getHandle().gT();
    }

    public void setEatingTicks(int ticks) {
        this.getHandle().u(ticks);
    }

    public int getEatingTicks() {
        return this.getHandle().ho();
    }

    public void setUnhappyTicks(int ticks) {
        this.getHandle().s(ticks);
    }

    public Panda.Gene getCombinedGene() {
        return CraftPanda.fromNms(this.getHandle().hf());
    }

    public boolean isRolling() {
        return this.getHandle().hd();
    }

    public void setRolling(boolean flag) {
        this.getHandle().B(flag);
    }

    public boolean isSneezing() {
        return this.getHandle().gP();
    }

    public void setSneezing(boolean flag) {
        this.getHandle().A(flag);
    }

    public boolean isSitting() {
        return this.getHandle().gQ();
    }

    public void setSitting(boolean flag) {
        this.getHandle().x(flag);
    }

    public boolean isOnBack() {
        return this.getHandle().gR();
    }

    public void setOnBack(boolean flag) {
        this.getHandle().y(flag);
    }

    public boolean isEating() {
        return this.getHandle().gS();
    }

    public void setEating(boolean flag) {
        this.getHandle().z(flag);
    }

    public boolean isScared() {
        return this.getHandle().hl();
    }

    public int getUnhappyTicks() {
        return this.getHandle().p();
    }

    public static Panda.Gene fromNms(EntityPanda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }

    public static EntityPanda.Gene toNms(Panda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return EntityPanda.Gene.values()[gene.ordinal()];
    }
}

