/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.FeatureHooks;
import io.papermc.paper.adventure.BossBarImplementationImpl;
import io.papermc.paper.adventure.DisplayNames;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.PlayerGameConnection;
import io.papermc.paper.connection.PluginMessageBridgeImpl;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.dialog.PaperDialog;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.entity.PaperPlayerGiveResult;
import io.papermc.paper.entity.PlayerGiveResult;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.BossBarImplementation;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.pointer.PointersSupplier;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.kyori.adventure.util.MonkeyBars;
import net.kyori.adventure.util.TriState;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundClearDialogPacket;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.EnumHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Input;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.ServerLinks;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.ban.IpBanList;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_21_R7.CraftEffect;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.CraftInput;
import org.bukkit.craftbukkit.v1_21_R7.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R7.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftServerLinks;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R7.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_21_R7.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R7.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerHideEntityEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShowEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemType;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player,
PluginMessageBridgeImpl {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private static final PointersSupplier<Player> POINTERS_SUPPLIER = (PointersSupplier)PointersSupplier.builder().parent(CraftEntity.POINTERS_SUPPLIER).resolving(Identity.NAME, Player::getName).resolving(Identity.DISPLAY_NAME, Player::displayName).resolving(Identity.LOCALE, Player::locale).build();
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Map<UUID, Set<WeakReference<Plugin>>> invertedVisibilityEntities = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private final Set<UUID> unlistedEntities = new HashSet<UUID>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private CraftWorldBorder clientWorldBorder = null;
    private IWorldBorderListener clientWorldBorderListener = this.createWorldBorderListener();
    private long lastSaveTime;
    private @Nullable CraftScoreboard scoreboardOverride;
    private Component playerListHeader;
    private Component playerListFooter;
    private @Nullable Set<BossBar> activeBossBars;
    private final Player.Spigot spigot = new Player.Spigot(){

        public InetSocketAddress getRawAddress() {
            return (InetSocketAddress)CraftPlayer.this.getHandle().g.getRawAddress();
        }

        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().bA().respawn(CraftPlayer.this.getHandle(), false, Entity.RemovalReason.a, PlayerRespawnEvent.RespawnReason.PLUGIN);
                CraftPlayer.this.getHandle().g.y();
            }
        }

        public Set<Player> getHiddenPlayers() {
            HashSet<Player> ret = new HashSet<Player>();
            for (Player player : CraftPlayer.this.getServer().getOnlinePlayers()) {
                if (CraftPlayer.this.canSee(player)) continue;
                ret.add(player);
            }
            return Collections.unmodifiableSet(ret);
        }

        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        public void sendMessage(BaseComponent ... components) {
            this.sendMessage(ChatMessageType.SYSTEM, components);
        }

        public void sendMessage(UUID sender, BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, sender, component);
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
            this.sendMessage(ChatMessageType.CHAT, sender, components);
        }

        public void sendMessage(ChatMessageType position, BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            this.sendMessage(position, (UUID)null, components);
        }

        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent component) {
            this.sendMessage(position, sender, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().g == null) {
                return;
            }
            CraftPlayer.this.getHandle().g.b(new ClientboundSystemChatPacket(components, position == ChatMessageType.ACTION_BAR));
        }

        public int getPing() {
            return CraftPlayer.this.getPing();
        }
    };

    public CraftPlayer(CraftServer server, EntityPlayer entity) {
        super(server, entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    @Override
    public EntityPlayer getHandle() {
        return (EntityPlayer)this.entity;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        return this.getUniqueId().equals(other.getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + this.getUniqueId().hashCode();
        }
        return this.hash;
    }

    public GameProfile getProfile() {
        return this.getHandle().gI();
    }

    @Override
    public void remove() {
        if (this.getHandle().getClass().equals(EntityPlayer.class)) {
            throw new UnsupportedOperationException(String.format("Cannot remove player %s, use Player#kickPlayer(String) instead.", this.getName()));
        }
        super.remove();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().f(this.getHandle().gJ());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().d(this.getHandle().gJ());
        } else {
            this.server.getHandle().e(this.getHandle().gJ());
        }
        this.perm.recalculatePermissions();
    }

    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    public boolean isConnected() {
        return !this.getHandle().w();
    }

    public InetSocketAddress getAddress() {
        if (this.getHandle().g == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().g.n();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    public @Nullable InetSocketAddress getHAProxyAddress() {
        InetSocketAddress inetSocketAddress;
        if (this.getHandle().g == null) {
            return null;
        }
        SocketAddress socketAddress = this.getHandle().g.e.haProxyAddress;
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddress = (InetSocketAddress)socketAddress) : null;
    }

    public boolean isTransferred() {
        return this.getHandle().g.playerGameConnection.isTransferred();
    }

    public CompletableFuture<byte @Nullable []> retrieveCookie(NamespacedKey key) {
        return this.getHandle().g.playerGameConnection.retrieveCookie(key);
    }

    public void storeCookie(NamespacedKey key, byte[] value) {
        this.getHandle().g.playerGameConnection.storeCookie(key, value);
    }

    public void transfer(String host, int port) {
        this.getHandle().g.playerGameConnection.transfer(host, port);
    }

    public int getProtocolVersion() {
        if (this.getHandle().g == null) {
            return -1;
        }
        return this.getHandle().g.e.protocolVersion;
    }

    public InetSocketAddress getVirtualHost() {
        if (this.getHandle().g == null) {
            return null;
        }
        return this.getHandle().g.e.virtualHost;
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    public void sendRawMessage(String message) {
        this.sendRawMessage(null, message);
    }

    public void sendRawMessage(UUID sender, String message) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        for (IChatBaseComponent component : CraftChatMessage.fromString(message)) {
            this.getHandle().a(component);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(sender, message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(sender, message);
        }
    }

    @Deprecated
    public void sendActionBar(BaseComponent[] message) {
        if (this.getHandle().g == null || message == null) {
            return;
        }
        ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket(CraftChatMessage.bungeeToVanilla(message));
        this.getHandle().g.b(packet);
    }

    @Deprecated
    public void sendActionBar(String message) {
        if (this.getHandle().g == null || message == null || message.isEmpty()) {
            return;
        }
        this.getHandle().g.b(new ClientboundSetActionBarTextPacket(CraftChatMessage.fromStringOrNull(message)));
    }

    @Deprecated
    public void sendActionBar(char alternateChar, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        this.sendActionBar(ChatColor.translateAlternateColorCodes((char)alternateChar, (String)message));
    }

    public void setPlayerListHeaderFooter(BaseComponent @Nullable [] header, BaseComponent @Nullable [] footer) {
        if (header != null) {
            String headerJson = CraftChatMessage.bungeeToJson(header);
            this.playerListHeader = GsonComponentSerializer.gson().deserialize((Object)headerJson);
        } else {
            this.playerListHeader = null;
        }
        if (footer != null) {
            String footerJson = CraftChatMessage.bungeeToJson(footer);
            this.playerListFooter = GsonComponentSerializer.gson().deserialize((Object)footerJson);
        } else {
            this.playerListFooter = null;
        }
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(@Nullable BaseComponent header, @Nullable BaseComponent footer) {
        BaseComponent[] baseComponentArray;
        BaseComponent[] baseComponentArray2;
        if (header == null) {
            baseComponentArray2 = null;
        } else {
            BaseComponent[] baseComponentArray3 = new BaseComponent[1];
            baseComponentArray2 = baseComponentArray3;
            baseComponentArray3[0] = header;
        }
        if (footer == null) {
            baseComponentArray = null;
        } else {
            BaseComponent[] baseComponentArray4 = new BaseComponent[1];
            baseComponentArray = baseComponentArray4;
            baseComponentArray4[0] = footer;
        }
        this.setPlayerListHeaderFooter(baseComponentArray2, baseComponentArray);
    }

    public void setTitleTimes(int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.getHandle().g.b(new ClientboundSetTitlesAnimationPacket(fadeInTicks, stayTicks, fadeOutTicks));
    }

    public void setSubtitle(BaseComponent[] subtitle) {
        ClientboundSetSubtitleTextPacket packet = new ClientboundSetSubtitleTextPacket(CraftChatMessage.bungeeToVanilla(subtitle));
        this.getHandle().g.b(packet);
    }

    public void setSubtitle(BaseComponent subtitle) {
        this.setSubtitle(new BaseComponent[]{subtitle});
    }

    public void showTitle(BaseComponent[] title) {
        ClientboundSetTitleTextPacket packet = new ClientboundSetTitleTextPacket(CraftChatMessage.bungeeToVanilla(title));
        this.getHandle().g.b(packet);
    }

    public void showTitle(BaseComponent title) {
        this.showTitle(new BaseComponent[]{title});
    }

    public void showTitle(BaseComponent[] title, BaseComponent[] subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void showTitle(BaseComponent title, BaseComponent subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void sendTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        this.setSubtitle(title.getSubtitle() == null ? new BaseComponent[]{} : title.getSubtitle());
        this.showTitle(title.getTitle());
    }

    public void updateTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        if (title.getSubtitle() != null) {
            this.setSubtitle(title.getSubtitle());
        }
        this.showTitle(title.getTitle());
    }

    public void hideTitle() {
        this.getHandle().g.b(new ClientboundClearTitlesPacket(false));
    }

    public String getDisplayName() {
        return DisplayNames.getLegacy(this);
    }

    public void setDisplayName(String name) {
        this.getHandle().adventure$displayName = name != null ? LegacyComponentSerializer.legacySection().deserialize(name) : Component.text((String)this.getName());
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    public void playerListName(Component name) {
        IChatBaseComponent iChatBaseComponent = this.getHandle().listName = name == null ? null : PaperAdventure.asVanilla(name);
        if (this.getHandle().g == null) {
            return;
        }
        for (EntityPlayer player : this.server.getHandle().k) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.g.b(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.f, this.getHandle()));
        }
    }

    public Component playerListName() {
        return this.getHandle().listName == null ? Component.text((String)this.getName()) : PaperAdventure.asAdventure(this.getHandle().listName);
    }

    public Component playerListHeader() {
        return this.playerListHeader;
    }

    public Component playerListFooter() {
        return this.playerListFooter;
    }

    public String getPlayerListName() {
        return this.getHandle().listName == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().listName);
    }

    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        IChatBaseComponent iChatBaseComponent = this.getHandle().listName = name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name);
        if (this.getHandle().g == null) {
            return;
        }
        for (EntityPlayer player : this.server.getHandle().k) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.g.b(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.f, this.getHandle()));
        }
    }

    public int getPlayerListOrder() {
        return this.getHandle().listOrder;
    }

    public void setPlayerListOrder(int order) {
        Preconditions.checkArgument((order >= 0 ? 1 : 0) != 0, (Object)"order cannot be negative");
        this.getHandle().listOrder = order;
        if (this.getHandle().g == null) {
            return;
        }
        for (EntityPlayer player : this.server.getHandle().k) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.g.b(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.g, this.getHandle()));
        }
    }

    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : LegacyComponentSerializer.legacySection().serialize(this.playerListHeader);
    }

    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : LegacyComponentSerializer.legacySection().serialize(this.playerListFooter);
    }

    public void setPlayerListHeader(String header) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListFooter(String footer) {
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().g == null) {
            return;
        }
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter(PaperAdventure.asVanillaNullToEmpty(this.playerListHeader), PaperAdventure.asVanillaNullToEmpty(this.playerListFooter));
        this.getHandle().g.b(packet);
    }

    public void kickPlayer(String message) {
        AsyncCatcher.catchOp("player kick");
        this.getHandle().g.disconnect(CraftChatMessage.fromStringOrEmpty(message, true), PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick(Component message, PlayerKickEvent.Cause cause) {
        AsyncCatcher.catchOp("player kick");
        PlayerConnection connection = this.getHandle().g;
        if (connection != null) {
            connection.disconnect((Component)(message == null ? Component.empty() : message), cause);
        }
    }

    public <T> T getClientOption(ClientOption<T> type) {
        if (ClientOption.SKIN_PARTS == type) {
            return type.getType().cast(new PaperSkinParts(this.getHandle().aD().a(Avatar.t).byteValue()));
        }
        if (ClientOption.CHAT_COLORS_ENABLED == type) {
            return type.getType().cast(this.getHandle().F());
        }
        if (ClientOption.CHAT_VISIBILITY == type) {
            return type.getType().cast(ClientOption.ChatVisibility.valueOf((String)this.getHandle().G().name()));
        }
        if (ClientOption.LOCALE == type) {
            return type.getType().cast(this.getLocale());
        }
        if (ClientOption.MAIN_HAND == type) {
            return type.getType().cast(this.getMainHand());
        }
        if (ClientOption.VIEW_DISTANCE == type) {
            return type.getType().cast(this.getClientViewDistance());
        }
        if (ClientOption.TEXT_FILTERING_ENABLED == type) {
            return type.getType().cast(this.getHandle().Z());
        }
        if (ClientOption.ALLOW_SERVER_LISTINGS == type) {
            return type.getType().cast(this.getHandle().aa());
        }
        if (ClientOption.PARTICLE_VISIBILITY == type) {
            return type.getType().cast(ClientOption.ParticleVisibility.valueOf((String)this.getHandle().db.name()));
        }
        throw new RuntimeException("Unknown settings type");
    }

    public void sendOpLevel(byte level) {
        Preconditions.checkArgument((level >= PermissionLevel.a.a() && level <= PermissionLevel.e.a() ? 1 : 0) != 0, (String)"Level must be within [%s, %s]", (int)PermissionLevel.a.a(), (int)PermissionLevel.e.a());
        this.server.getServer().bA().sendPlayerPermissionLevel(this.getHandle(), LevelBasedPermissionSet.a(PermissionLevel.a(level)), false);
    }

    public void addAdditionalChatCompletions(@NonNull Collection<String> completions) {
        this.getHandle().g.b(new ClientboundCustomChatCompletionsPacket(ClientboundCustomChatCompletionsPacket.Action.a, new ArrayList<String>(completions)));
    }

    public void removeAdditionalChatCompletions(@NonNull Collection<String> completions) {
        this.getHandle().g.b(new ClientboundCustomChatCompletionsPacket(ClientboundCustomChatCompletionsPacket.Action.b, new ArrayList<String>(completions)));
    }

    public void setCompassTarget(Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new PacketPlayOutSpawnPosition(WorldData.a.a(((CraftWorld)loc.getWorld()).getHandle().aq(), CraftLocation.toBlockPosition(loc), loc.getYaw(), loc.getPitch())));
    }

    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    public void chat(String msg) {
        Preconditions.checkArgument((msg != null ? 1 : 0) != 0, (Object)"msg cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        if (PlayerConnection.d(msg)) {
            this.getHandle().g.disconnect((IChatBaseComponent)IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (msg.startsWith("/")) {
            this.getHandle().g.handleCommand(msg);
        } else {
            PlayerChatMessage playerChatMessage = PlayerChatMessage.a(msg).a(IChatBaseComponent.b(msg));
            this.getHandle().g.chat(msg, playerChatMessage, false);
        }
    }

    public boolean performCommand(String command) {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"command cannot be null");
        return this.server.dispatchCommand((CommandSender)this, command);
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((instrument != null ? 1 : 0) != 0, (Object)"Instrument cannot be null");
        Preconditions.checkArgument((note != null ? 1 : 0) != 0, (Object)"Note cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        Sound instrumentSound = instrument.getSound();
        if (instrumentSound == null) {
            return;
        }
        BlockPropertyInstrument noteBlockInstrument = CraftBlockData.toNMS(instrument, BlockPropertyInstrument.class);
        float pitch = noteBlockInstrument.b() ? note.getPitch() : 1.0f;
        this.getHandle().g.b(new PacketPlayOutNamedSoundEffect(CraftSound.bukkitToMinecraftHolder(instrumentSound), net.minecraft.sounds.SoundCategory.c, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 3.0f, pitch, this.getHandle().ep().g()));
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().as.g());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().as.g());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().g == null) {
            return;
        }
        this.playSound0(loc, CraftSound.bukkitToMinecraftHolder(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().g == null) {
            return;
        }
        this.playSound0(loc, Holder.a(SoundEffect.a(MinecraftKey.a(sound))), net.minecraft.sounds.SoundCategory.valueOf(category.name()), volume, pitch, seed);
    }

    private void playSound0(Location loc, Holder<SoundEffect> soundEffectHolder, net.minecraft.sounds.SoundCategory categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        PacketPlayOutNamedSoundEffect packet = new PacketPlayOutNamedSoundEffect(soundEffectHolder, categoryNMS, loc.getX(), loc.getY(), loc.getZ(), volume, pitch, seed);
        this.getHandle().g.b(packet);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().as.g());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().as.g());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        if (!(entity instanceof CraftEntity) || sound == null || category == null || this.getHandle().g == null) {
            return;
        }
        this.playSound0(entity, CraftSound.bukkitToMinecraftHolder(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        if (!(entity instanceof CraftEntity) || sound == null || category == null || this.getHandle().g == null) {
            return;
        }
        this.playSound0(entity, Holder.a(SoundEffect.a(MinecraftKey.a(sound))), net.minecraft.sounds.SoundCategory.valueOf(category.name()), volume, pitch, seed);
    }

    private void playSound0(Entity entity, Holder<SoundEffect> soundEffectHolder, net.minecraft.sounds.SoundCategory categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((soundEffectHolder != null ? 1 : 0) != 0, (Object)"Holder of SoundEffect cannot be null");
        Preconditions.checkArgument((categoryNMS != null ? 1 : 0) != 0, (Object)"SoundCategory cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        if (!(entity instanceof CraftEntity)) {
            return;
        }
        CraftEntity craftEntity = (CraftEntity)entity;
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(soundEffectHolder, categoryNMS, craftEntity.getHandle(), volume, pitch, seed);
        this.getHandle().g.b(packet);
    }

    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new PacketPlayOutStopSound(MinecraftKey.a(sound), category == null ? net.minecraft.sounds.SoundCategory.a : net.minecraft.sounds.SoundCategory.valueOf(category.name())));
    }

    public void stopSound(SoundCategory category) {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new PacketPlayOutStopSound(null, net.minecraft.sounds.SoundCategory.valueOf(category.name())));
    }

    public void stopAllSounds() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new PacketPlayOutStopSound(null, null));
    }

    public void playEffect(Location loc, Effect effect, int data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        int packetData = effect.getId();
        PacketPlayOutWorldEvent packet = new PacketPlayOutWorldEvent(packetData, CraftLocation.toBlockPosition(loc), data, false);
        this.getHandle().g.b(packet);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.isApplicable(data), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    public boolean breakBlock(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals((Object)this.getWorld()), (Object)"Cannot break blocks across worlds");
        return this.getHandle().h.a(new BlockPosition(block.getX(), block.getY(), block.getZ()));
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().g == null) {
            return;
        }
        PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(CraftLocation.toBlockPosition(loc), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().g.b(packet);
    }

    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().g == null) {
            return;
        }
        PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(CraftLocation.toBlockPosition(loc), ((CraftBlockData)block).getState());
        this.getHandle().g.b(packet);
    }

    public void sendMultiBlockChange(Map<? extends Position, BlockData> blockChanges) {
        if (this.getHandle().g == null) {
            return;
        }
        HashMap<SectionPosition, Short2ObjectMap> sectionMap = new HashMap<SectionPosition, Short2ObjectMap>();
        for (Map.Entry<? extends Position, BlockData> entry : blockChanges.entrySet()) {
            BlockData blockData = entry.getValue();
            BlockPosition blockPos = MCUtil.toBlockPos(entry.getKey());
            SectionPosition sectionPos = SectionPosition.a(blockPos);
            Short2ObjectMap sectionData = sectionMap.computeIfAbsent(sectionPos, key -> new Short2ObjectArrayMap());
            sectionData.put(SectionPosition.b(blockPos), (Object)((CraftBlockData)blockData).getState());
        }
        for (Map.Entry<Object, Object> entry : sectionMap.entrySet()) {
            SectionPosition sectionPos = (SectionPosition)entry.getKey();
            Short2ObjectMap blockData = (Short2ObjectMap)entry.getValue();
            PacketPlayOutMultiBlockChange packet = new PacketPlayOutMultiBlockChange(sectionPos, (Short2ObjectMap<IBlockData>)blockData);
            this.getHandle().g.b(packet);
        }
    }

    public void sendBlockChanges(Collection<BlockState> blocks) {
        Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
        if (this.getHandle().g == null || blocks.isEmpty()) {
            return;
        }
        HashMap<SectionPosition, ChunkSectionChanges> changes = new HashMap<SectionPosition, ChunkSectionChanges>();
        for (BlockState blockState : blocks) {
            CraftBlockState cstate = (CraftBlockState)blockState;
            BlockPosition pos = cstate.getPosition();
            SectionPosition sectionPosition = SectionPosition.a(pos);
            ChunkSectionChanges sectionChanges = changes.computeIfAbsent(sectionPosition, ignore -> new ChunkSectionChanges());
            sectionChanges.positions().add(SectionPosition.b(pos));
            sectionChanges.blockData().add(cstate.getHandle());
        }
        for (Map.Entry entry : changes.entrySet()) {
            ChunkSectionChanges chunkChanges = (ChunkSectionChanges)entry.getValue();
            PacketPlayOutMultiBlockChange packet = new PacketPlayOutMultiBlockChange((SectionPosition)entry.getKey(), chunkChanges.positions(), (IBlockData[])chunkChanges.blockData().toArray(IBlockData[]::new));
            this.getHandle().g.b(packet);
        }
    }

    public void sendBlockDamage(Location loc, float progress, Entity source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source must not be null");
        this.sendBlockDamage(loc, progress, source.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, int sourceId) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().g == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        if (progress == 0.0f) {
            stage = -1;
        }
        PacketPlayOutBlockBreakAnimation packet = new PacketPlayOutBlockBreakAnimation(sourceId, CraftLocation.toBlockPosition(loc), stage);
        this.getHandle().g.b(packet);
    }

    public void sendSignChange(Location loc, @Nullable List<? extends Component> lines, DyeColor dyeColor, boolean hasGlowingText) {
        if (this.getHandle().g == null) {
            return;
        }
        if (lines == null) {
            lines = new ArrayList<Component>(4);
        }
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((dyeColor != null ? 1 : 0) != 0, (Object)"DyeColor cannot be null");
        if (lines.size() < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(lines);
        this.sendSignChange0(components, loc, dyeColor, hasGlowingText);
    }

    public void sendSignChange(Location loc, @Nullable String @Nullable [] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(Location loc, @Nullable String @Nullable [] lines, DyeColor dyeColor) {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    public void sendSignChange(Location loc, @Nullable String @Nullable [] lines, DyeColor dyeColor, boolean hasGlowingText) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((dyeColor != null ? 1 : 0) != 0, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new String[4];
        }
        Preconditions.checkArgument((lines.length >= 4 ? 1 : 0) != 0, (String)"Must have at least 4 lines (%s)", (int)lines.length);
        if (this.getHandle().g == null) {
            return;
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(lines);
        this.sendSignChange0(components, loc, dyeColor, hasGlowingText);
    }

    private void sendSignChange0(IChatBaseComponent[] components, Location loc, DyeColor dyeColor, boolean hasGlowingText) {
        TileEntitySign sign = new TileEntitySign(CraftLocation.toBlockPosition(loc), Blocks.db.m());
        SignText text = sign.h();
        text = text.a(EnumColor.a(dyeColor.getWoolData()));
        text = text.a(hasGlowingText);
        for (int i2 = 0; i2 < components.length; ++i2) {
            text = text.a(i2, components[i2]);
        }
        sign.a(text, true);
        this.getHandle().g.b(new PacketPlayOutTileEntityData(sign.aD_(), sign.s(), sign.a(this.getHandle().eo())));
    }

    public void sendBlockUpdate(@NonNull Location location, @NonNull TileState tileState) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location can not be null");
        Preconditions.checkArgument((tileState != null ? 1 : 0) != 0, (Object)"TileState can not be null");
        if (this.getHandle().g == null) {
            return;
        }
        CraftBlockEntityState craftState = (CraftBlockEntityState)tileState;
        this.getHandle().g.b(craftState.getUpdatePacket(location));
    }

    public void sendEquipmentChange(LivingEntity entity, EquipmentSlot slot, @Nullable org.bukkit.inventory.ItemStack item) {
        this.sendEquipmentChange(entity, Collections.singletonMap(slot, item));
    }

    public void sendEquipmentChange(LivingEntity entity, Map<EquipmentSlot, @Nullable org.bukkit.inventory.ItemStack> items) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0, (Object)"items cannot be empty");
        if (this.getHandle().g == null) {
            return;
        }
        ArrayList<Pair<EnumItemSlot, ItemStack>> equipment = new ArrayList<Pair<EnumItemSlot, ItemStack>>(items.size());
        for (Map.Entry<EquipmentSlot, org.bukkit.inventory.ItemStack> entry : items.entrySet()) {
            EquipmentSlot slot = entry.getKey();
            Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Cannot set null EquipmentSlot");
            equipment.add((Pair<EnumItemSlot, ItemStack>)new Pair((Object)CraftEquipmentSlot.getNMS(slot), (Object)CraftItemStack.asNMSCopy(entry.getValue())));
        }
        this.getHandle().g.b(new PacketPlayOutEntityEquipment(entity.getEntityId(), equipment));
    }

    public void sendPotionEffectChange(LivingEntity entity, PotionEffect effect) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new PacketPlayOutEntityEffect(entity.getEntityId(), CraftPotionUtil.fromBukkit(effect), true));
    }

    public void sendPotionEffectChangeRemove(LivingEntity entity, PotionEffectType type) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new PacketPlayOutRemoveEntityEffect(entity.getEntityId(), CraftPotionEffectType.bukkitToMinecraftHolder(type)));
    }

    public WorldBorder getWorldBorder() {
        return this.clientWorldBorder;
    }

    public void setWorldBorder(WorldBorder border) {
        net.minecraft.world.level.border.WorldBorder newWorldBorder;
        CraftWorldBorder craftBorder = (CraftWorldBorder)border;
        if (border != null && !craftBorder.isVirtual() && !craftBorder.getWorld().equals((Object)this.getWorld())) {
            throw new UnsupportedOperationException("Cannot set player world border to that of another world");
        }
        if (this.clientWorldBorder != null) {
            this.clientWorldBorder.getHandle().b(this.clientWorldBorderListener);
        }
        if (craftBorder == null || !craftBorder.isVirtual()) {
            this.clientWorldBorder = null;
            newWorldBorder = ((CraftWorldBorder)this.getWorld().getWorldBorder()).getHandle();
        } else {
            this.clientWorldBorder = craftBorder;
            this.clientWorldBorder.getHandle().a(this.clientWorldBorderListener);
            newWorldBorder = this.clientWorldBorder.getHandle();
        }
        PlayerConnection connection = this.getHandle().g;
        connection.b(new ClientboundSetBorderSizePacket(newWorldBorder));
        connection.b(new ClientboundSetBorderLerpSizePacket(newWorldBorder));
        connection.b(new ClientboundSetBorderCenterPacket(newWorldBorder));
        connection.b(new ClientboundSetBorderWarningDelayPacket(newWorldBorder));
        connection.b(new ClientboundSetBorderWarningDistancePacket(newWorldBorder));
    }

    private IWorldBorderListener createWorldBorderListener() {
        return new IWorldBorderListener(){

            @Override
            public void a(net.minecraft.world.level.border.WorldBorder border, double size) {
                CraftPlayer.this.getHandle().g.b(new ClientboundSetBorderSizePacket(border));
            }

            @Override
            public void a(net.minecraft.world.level.border.WorldBorder border, double fromSize, double toSize, long time, long gameTime) {
                CraftPlayer.this.getHandle().g.b(new ClientboundSetBorderLerpSizePacket(border));
            }

            @Override
            public void a(net.minecraft.world.level.border.WorldBorder border, double centerX, double centerZ) {
                CraftPlayer.this.getHandle().g.b(new ClientboundSetBorderCenterPacket(border));
            }

            @Override
            public void a(net.minecraft.world.level.border.WorldBorder border, int warningTime) {
                CraftPlayer.this.getHandle().g.b(new ClientboundSetBorderWarningDelayPacket(border));
            }

            @Override
            public void b(net.minecraft.world.level.border.WorldBorder border, int warningBlockDistance) {
                CraftPlayer.this.getHandle().g.b(new ClientboundSetBorderWarningDistancePacket(border));
            }

            @Override
            public void b(net.minecraft.world.level.border.WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(net.minecraft.world.level.border.WorldBorder border, double safeZoneRadius) {
            }
        };
    }

    public boolean hasClientWorldBorder() {
        return this.clientWorldBorder != null;
    }

    public void sendMap(MapView map) {
        if (this.getHandle().g == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new MapIcon(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
        }
        PacketPlayOutMap packet = new PacketPlayOutMap(new MapId(map.getId()), map.getScale().getValue(), map.isLocked(), icons, new WorldMap.c(0, 0, 128, 128, data.buffer));
        this.getHandle().g.b(packet);
    }

    public void sendHurtAnimation(float yaw) {
        this.sendHurtAnimation(yaw, this);
    }

    public void sendHurtAnimation(float yaw, Entity target) {
        if (this.getHandle().g == null) {
            return;
        }
        float actualYaw = yaw + 90.0f;
        this.getHandle().g.b(new ClientboundHurtAnimationPacket(target.getEntityId(), actualYaw));
    }

    public void sendLinks(ServerLinks links) {
        if (this.getHandle().g == null) {
            return;
        }
        Preconditions.checkArgument((links != null ? 1 : 0) != 0, (Object)"links cannot be null");
        net.minecraft.server.ServerLinks nms = ((CraftServerLinks)links).getServerLinks();
        this.getHandle().g.b(new ClientboundServerLinksPacket(nms.b()));
    }

    public void addCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.a);
    }

    public void removeCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.b);
    }

    public void setCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.c);
    }

    private void sendCustomChatCompletionPacket(Collection<String> completions, ClientboundCustomChatCompletionsPacket.Action action) {
        if (this.getHandle().g == null) {
            return;
        }
        ClientboundCustomChatCompletionsPacket packet = new ClientboundCustomChatCompletionsPacket(action, new ArrayList<String>(completions));
        this.getHandle().g.b(packet);
    }

    public void showWinScreen() {
        if (this.getHandle().g == null) {
            return;
        }
        PacketPlayOutGameStateChange packet = new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 1.0f);
        this.getHandle().g.b(packet);
    }

    public boolean hasSeenWinScreen() {
        return this.getHandle().i;
    }

    public void setHasSeenWinScreen(boolean hasSeenWinScreen) {
        this.getHandle().i = hasSeenWinScreen;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        if (this.getHandle().g == null) {
            return;
        }
        super.setRotation(yaw, pitch);
    }

    public void lookAt(@NonNull Entity entity, @NonNull LookAnchor playerAnchor, @NonNull LookAnchor entityAnchor) {
        this.getHandle().a(CraftPlayer.toNmsAnchor(playerAnchor), ((CraftEntity)entity).getHandle(), CraftPlayer.toNmsAnchor(entityAnchor));
    }

    @Override
    protected boolean teleport0(Location location, PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... flags) {
        if (this.getHandle().g == null) {
            return false;
        }
        if (location.getWorld() != this.getWorld() && !((net.minecraft.world.entity.Entity)this.getHandle()).aS.isEmpty()) {
            return false;
        }
        return super.teleport0(location, cause, flags);
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().h(sneak);
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().cu();
    }

    public boolean isSprinting() {
        return this.getHandle().cA();
    }

    public void setSprinting(boolean sprinting) {
        this.getHandle().i(sprinting);
    }

    public void loadData() {
        this.server.getHandle().s.a(this.getHandle().gJ()).map(tag -> TagValueInput.a(ProblemReporter.a, (HolderLookup.a)this.server.getServer().bc(), tag)).ifPresent(this.getHandle()::d);
    }

    public void saveData() {
        this.server.getHandle().s.a(this.getHandle());
    }

    @Deprecated
    public void updateInventory() {
        this.getHandle().cn.b();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().h();
    }

    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    public Location getRespawnLocation(boolean loadLocationAndValidate) {
        EntityPlayer.RespawnConfig respawnConfig = this.getHandle().V();
        if (respawnConfig == null) {
            return null;
        }
        WorldData.a respawnData = respawnConfig.a();
        WorldServer world = this.server.getServer().a(respawnData.a());
        if (world == null) {
            return null;
        }
        if (!loadLocationAndValidate) {
            return CraftLocation.toBukkit((BaseBlockPosition)respawnData.b(), (World)world, respawnData.d(), respawnData.e());
        }
        return EntityPlayer.a(world, respawnConfig, false).map(pos -> CraftLocation.toBukkit(pos.a(), (World)world, pos.b(), pos.c())).orElse(null);
    }

    public void setRespawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().setRespawnPosition(null, false, PlayerSetSpawnEvent.Cause.PLUGIN);
        } else {
            this.getHandle().setRespawnPosition(new EntityPlayer.RespawnConfig(WorldData.a.a(((CraftWorld)location.getWorld()).getHandle().aq(), CraftLocation.toBlockPosition(location), location.getYaw(), location.getPitch()), override), false, PlayerSetSpawnEvent.Cause.PLUGIN);
        }
    }

    public Collection<EnderPearl> getEnderPearls() {
        return this.getHandle().ak().stream().map(e2 -> (EnderPearl)e2.getBukkitEntity()).collect(Collectors.toList());
    }

    public Input getCurrentInput() {
        return new CraftInput(this.getHandle().ai());
    }

    @Override
    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPosition bed = this.getHandle().V().a().b();
        return CraftLocation.toBukkit((BaseBlockPosition)bed, this.getWorld());
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0, (Object)"recipe cannot be null");
        return this.getHandle().L().b(CraftRecipe.toMinecraft(recipe));
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        ImmutableSet.Builder bukkitRecipeKeys = ImmutableSet.builder();
        this.getHandle().L().c.forEach(key -> bukkitRecipeKeys.add((Object)CraftNamespacedKey.fromMinecraft(key.a())));
        return bukkitRecipeKeys.build();
    }

    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, this.getHandle());
    }

    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().K(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().K(), statistic, newValue, this.getHandle());
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, material, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, material, this.getHandle());
    }

    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().K(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, material, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, material, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().K(), statistic, material, newValue, this.getHandle());
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, entityType, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, entityType, this.getHandle());
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().K(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().K(), statistic, entityType, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().K(), statistic, entityType, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().K(), statistic, entityType, newValue, this.getHandle());
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
        if (this.getHandle().g == null) {
            return;
        }
        long gameTime = this.getHandle().A().au();
        long dayTime = this.getHandle().getPlayerTime();
        boolean tickDayTime = this.getHandle().relativeTime && this.getHandle().A().U().a(GameRules.a) != false;
        this.getHandle().g.b(new PacketPlayOutUpdateTime(gameTime, dayTime, tickDayTime));
    }

    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    public WeatherType getPlayerWeather() {
        return this.getHandle().weatherType;
    }

    public int getExpCooldown() {
        return this.getHandle().cq;
    }

    public void setExpCooldown(int ticks) {
        this.getHandle().cq = CraftEventFactory.callPlayerXpCooldownEvent(this.getHandle(), ticks, PlayerExpCooldownChangeEvent.ChangeReason.PLUGIN).getNewCooldown();
    }

    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    public boolean isBanned() {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).isBanned((Object)this.getPlayerProfile());
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source) {
        return this.ban(reason, expires, source, true);
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant expires, String source) {
        return this.ban(reason, expires != null ? Date.from(expires) : null, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source, boolean kickPlayer) {
        BanEntry banEntry = ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.ban(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    public BanEntry<InetAddress> banIp(String reason, Date expires, String source, boolean kickPlayer) {
        Preconditions.checkArgument((this.getAddress() != null ? 1 : 0) != 0, (Object)"The Address of this Player is null");
        BanEntry banEntry = ((IpBanList)this.server.getBanList(BanList.Type.IP)).addBan((Object)this.getAddress().getAddress(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    public BanEntry<InetAddress> banIp(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.banIp(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    public BanEntry<InetAddress> banIp(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.banIp(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().i().a(this.getHandle().gJ());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().i().a(new WhiteListEntry(this.getHandle().gJ()));
        } else {
            this.server.getHandle().i().b(this.getHandle().gJ());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().setGameMode(EnumGamemode.a(mode.getValue()), PlayerGameModeChangeEvent.Cause.PLUGIN, null);
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.getHandle().h.b().a());
    }

    public GameMode getPreviousGameMode() {
        EnumGamemode previousGameMode = this.getHandle().h.c();
        return previousGameMode == null ? null : GameMode.getByValue((int)previousGameMode.a());
    }

    public int applyMending(int amount) {
        EntityPlayer handle = this.getHandle();
        Optional<EnchantedItemInUse> stackEntry = EnchantmentManager.a(EnchantmentEffectComponents.A, (EntityLiving)handle, ItemStack::n);
        ItemStack itemstack = stackEntry.map(EnchantedItemInUse::a).orElse(ItemStack.l);
        if (!itemstack.f() && itemstack.h().f().c(DataComponents.d)) {
            EntityExperienceOrb orb = EntityTypes.Z.a(handle.A(), EntitySpawnReason.n);
            orb.b(amount);
            orb.spawnReason = ExperienceOrb.SpawnReason.CUSTOM;
            orb.n(handle.dP(), handle.dR(), handle.dV());
            int possibleDurabilityFromXp = EnchantmentManager.c(handle.A(), itemstack, amount);
            int i2 = Math.min(possibleDurabilityFromXp, itemstack.o());
            int consumedExperience = i2 > 0 ? i2 * amount / possibleDurabilityFromXp : possibleDurabilityFromXp;
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(handle, orb, itemstack, stackEntry.get().b(), i2, consumedExperience);
            i2 = event.getRepairAmount();
            orb.discard(EntityRemoveEvent.Cause.DESPAWN);
            if (!event.isCancelled()) {
                amount -= consumedExperience;
                itemstack.b(itemstack.o() - i2);
            }
        }
        return amount;
    }

    public void giveExp(int exp, boolean applyMending) {
        if (applyMending) {
            exp = this.applyMending(exp);
        }
        this.getHandle().d(exp);
    }

    public void giveExpLevels(int levels) {
        this.getHandle().c(levels);
    }

    public float getExp() {
        return this.getHandle().cu;
    }

    public void setExp(float exp) {
        Preconditions.checkArgument(((double)exp >= 0.0 && (double)exp <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp));
        this.getHandle().cu = exp;
        this.getHandle().cZ = -1;
    }

    public int getLevel() {
        return this.getHandle().cs;
    }

    public void setLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        this.getHandle().cs = level;
        this.getHandle().cZ = -1;
    }

    public int getTotalExperience() {
        return this.getHandle().ct;
    }

    public void setTotalExperience(int exp) {
        Preconditions.checkArgument((exp >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)exp);
        this.getHandle().ct = exp;
    }

    public int calculateTotalExperiencePoints() {
        return this.calculateTotalExperiencePoints(this.getLevel()) + Math.round((float)this.getExperiencePointsNeededForNextLevel() * this.getExp());
    }

    public void setExperienceLevelAndProgress(int totalExperience) {
        Preconditions.checkArgument((totalExperience >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)totalExperience);
        int level = this.calculateLevelsForExperiencePoints(totalExperience);
        int remainingPoints = totalExperience - this.calculateTotalExperiencePoints(level);
        this.getHandle().cs = level;
        this.getHandle().cu = (float)remainingPoints / (float)this.getExperiencePointsNeededForNextLevel();
        this.getHandle().cZ = -1;
    }

    public int getExperiencePointsNeededForNextLevel() {
        return this.getHandle().gU();
    }

    private int calculateTotalExperiencePoints(int level) {
        if (level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level <= 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    private int calculateLevelsForExperiencePoints(int points) {
        if (points <= 352) {
            return (int)Math.floor(Math.sqrt(points + 9) - 3.0);
        }
        if (points <= 1507) {
            return (int)Math.floor(8.1 + Math.sqrt(0.4 * ((double)points - 195.975)));
        }
        return (int)Math.floor(18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)points - 752.9861111111111)));
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        if (this.getHandle().g == null) {
            return;
        }
        PacketPlayOutExperience packet = new PacketPlayOutExperience(progress, this.getTotalExperience(), level);
        this.getHandle().g.b(packet);
    }

    private static @Nullable WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Deprecated
    public void hidePlayer(Player player) {
        this.hideEntity0(null, (Entity)player);
    }

    public void hideEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (String)"Plugin (%s) cannot be disabled", (Object)plugin.getName());
        this.hideEntity0(plugin, entity);
    }

    private void hideEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity hidden cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldHide = entity.isVisibleByDefault() ? this.addInvertedVisibility(plugin, entity) : this.removeInvertedVisibility(plugin, entity);
        if (shouldHide) {
            this.untrackAndHideEntity(entity);
        }
    }

    private boolean addInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins != null) {
            invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return false;
        }
        invertedPlugins = new HashSet<WeakReference<Plugin>>();
        invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.invertedVisibilityEntities.put(entity.getUniqueId(), invertedPlugins);
        return true;
    }

    private void untrackAndHideEntity(Entity entity) {
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        this.unregisterEntity(other);
        this.server.getPluginManager().callEvent((Event)new PlayerHideEntityEvent((Player)this, entity));
    }

    private void unregisterEntity(net.minecraft.world.entity.Entity other) {
        PlayerChunkMap tracker = this.getHandle().A().p().a;
        PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.G.get(other.aA());
        if (entry != null) {
            entry.a(this.getHandle());
        }
        if (other instanceof EntityPlayer) {
            EntityPlayer otherPlayer = (EntityPlayer)other;
            if (this.getHandle().sentListPacket && otherPlayer.sentListPacket) {
                this.getHandle().g.b(new ClientboundPlayerInfoRemovePacket(List.of(otherPlayer.cY())));
            }
        }
    }

    void resetAndHideEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.untrackAndHideEntity(entity);
        }
    }

    @Deprecated
    public void showPlayer(Player player) {
        this.showEntity0(null, (Entity)player);
    }

    public void showEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        this.showEntity0(plugin, entity);
    }

    private void showEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity show cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldShow = entity.isVisibleByDefault() ? this.removeInvertedVisibility(plugin, entity) : this.addInvertedVisibility(plugin, entity);
        if (shouldShow) {
            this.trackAndShowEntity(entity);
        }
    }

    private boolean removeInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins == null) {
            return false;
        }
        invertedPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!invertedPlugins.isEmpty()) {
            return false;
        }
        this.invertedVisibilityEntities.remove(entity.getUniqueId());
        return true;
    }

    private void trackAndShowEntity(Entity entity) {
        this.trackAndShowEntity(entity, null);
    }

    private void trackAndShowEntity(Entity entity, @Nullable UUID uuidOverride) {
        PlayerChunkMap.EntityTracker entry;
        PlayerChunkMap tracker = this.getHandle().A().p().a;
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        if (other instanceof EntityPlayer) {
            EntityPlayer otherPlayer = (EntityPlayer)other;
            UUID original = null;
            if (uuidOverride != null) {
                original = otherPlayer.cY();
                otherPlayer.a(uuidOverride);
            }
            this.getHandle().g.b(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(otherPlayer), this.getHandle()));
            if (original != null) {
                otherPlayer.a(original);
            }
        }
        if ((entry = (PlayerChunkMap.EntityTracker)tracker.G.get(other.aA())) != null && !entry.f.contains(this.getHandle().g)) {
            entry.b(this.getHandle());
        }
        this.server.getPluginManager().callEvent((Event)new PlayerShowEntityEvent((Player)this, entity));
    }

    public void setPlayerProfile(PlayerProfile profile) {
        CraftPlayer bukkitPlayer;
        EntityPlayer self = this.getHandle();
        GameProfile gameProfile = CraftPlayerProfile.asAuthlibCopy(profile);
        if (!self.sentListPacket) {
            ((EntityHuman)self).cI = gameProfile;
            return;
        }
        List<EntityPlayer> players = this.server.getServer().bA().k;
        for (EntityPlayer player : players) {
            bukkitPlayer = player.getBukkitEntity();
            if (!bukkitPlayer.canSee(this)) continue;
            bukkitPlayer.unregisterEntity(self);
        }
        ((EntityHuman)self).cI = gameProfile;
        for (EntityPlayer player : players) {
            bukkitPlayer = player.getBukkitEntity();
            if (!bukkitPlayer.canSee(this)) continue;
            bukkitPlayer.trackAndShowEntity(self.getBukkitEntity(), gameProfile.id());
        }
        this.refreshPlayer();
    }

    void resetAndShowEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.trackAndShowEntity(entity);
        }
    }

    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this);
    }

    private void refreshPlayer() {
        EntityPlayer handle = this.getHandle();
        PlayerConnection connection = handle.g;
        WorldServer level = handle.A();
        connection.b(new PacketPlayOutRespawn(handle.b(level), 3));
        handle.z();
        connection.internalTeleport(PositionMoveRotation.a(this.getHandle()), Collections.emptySet());
        DedicatedPlayerList playerList = this.server.getServer().bA();
        playerList.sendPlayerPermissionLevel(handle, false);
        playerList.a(handle, level);
        playerList.e(handle);
        connection.b(new PacketPlayOutExperience(handle.cu, handle.ct, handle.cs));
        for (MobEffect mobEffect : handle.eW()) {
            connection.b(new PacketPlayOutEntityEffect(handle.aA(), mobEffect, false));
        }
    }

    public void onEntityRemove(net.minecraft.world.entity.Entity entity) {
        this.invertedVisibilityEntities.remove(entity.cY());
    }

    public boolean canSee(Player player) {
        return this.canSee((Entity)player);
    }

    public boolean canSee(Entity entity) {
        return this.equals(entity) || entity.isVisibleByDefault() ^ this.invertedVisibilityEntities.containsKey(entity.getUniqueId());
    }

    public boolean canSeePlayer(UUID uuid) {
        Player entity = this.getServer().getPlayer(uuid);
        return entity != null ? this.canSee((Entity)entity) : false;
    }

    public boolean isListed(Player other) {
        return !this.unlistedEntities.contains(other.getUniqueId());
    }

    public boolean unlistPlayer(@NonNull Player other) {
        Preconditions.checkNotNull((Object)other, (Object)"hidden entity cannot be null");
        if (this.getHandle().g == null) {
            return false;
        }
        if (!this.canSee(other)) {
            return false;
        }
        if (this.unlistedEntities.add(other.getUniqueId())) {
            this.getHandle().g.b(ClientboundPlayerInfoUpdatePacket.updateListed(other.getUniqueId(), false));
            return true;
        }
        return false;
    }

    public boolean listPlayer(@NonNull Player other) {
        Preconditions.checkNotNull((Object)other, (Object)"hidden entity cannot be null");
        if (this.getHandle().g == null) {
            return false;
        }
        if (!this.canSee(other)) {
            throw new IllegalStateException("Player cannot see other player");
        }
        if (this.unlistedEntities.remove(other.getUniqueId())) {
            this.getHandle().g.b(ClientboundPlayerInfoUpdatePacket.updateListed(other.getUniqueId(), true));
            return true;
        }
        return false;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public Player getPlayer() {
        return this;
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public long getLastLogin() {
        return this.getHandle().loginTime;
    }

    public long getLastSeen() {
        return this.isOnline() ? System.currentTimeMillis() : this.lastSaveTime;
    }

    public void readExtraData(ValueInput input) {
        this.hasPlayedBefore = true;
        input.a("bukkit").ifPresent(data -> {
            this.firstPlayed = data.a("firstPlayed", 0L);
            this.lastPlayed = data.a("lastPlayed", 0L);
            EntityPlayer handle = this.getHandle();
            handle.newExp = data.a("newExp", 0);
            handle.newTotalExp = data.a("newTotalExp", 0);
            handle.newLevel = data.a("newLevel", 0);
            handle.expToDrop = data.a("expToDrop", 0);
            handle.keepLevel = data.a("keepLevel", false);
        });
    }

    public void setExtraData(ValueOutput output) {
        this.lastSaveTime = System.currentTimeMillis();
        ValueOutput data = output.a("bukkit");
        EntityPlayer handle = this.getHandle();
        data.a("newExp", handle.newExp);
        data.a("newTotalExp", handle.newTotalExp);
        data.a("newLevel", handle.newLevel);
        data.a("expToDrop", handle.expToDrop);
        data.a("keepLevel", handle.keepLevel);
        data.a("firstPlayed", this.getFirstPlayed());
        data.a("lastPlayed", System.currentTimeMillis());
        data.a("lastKnownName", handle.gI().name());
        ValueOutput paper = output.a("Paper");
        paper.a("LastLogin", handle.loginTime);
        paper.a("LastSeen", System.currentTimeMillis());
    }

    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, (ConversationCanceller)new ManuallyAbandonedConversationCanceller()));
    }

    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.getHandle().g == null) {
            return;
        }
        if (this.channels().contains(channel)) {
            MinecraftKey id = MinecraftKey.a(StandardMessenger.validateAndCorrectChannel((String)channel));
            this.sendCustomPayload(id, message);
        }
    }

    private void sendCustomPayload(MinecraftKey id, byte[] message) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(new DiscardedPayload(id, message));
        this.getHandle().g.b(packet);
    }

    public void setResourcePack(String url, byte @Nullable [] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        this.setResourcePack(UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)), url, hash, prompt, force);
    }

    public void setResourcePack(UUID id, String url, byte @Nullable [] hash, String prompt, boolean force) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Resource pack ID cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new ClientboundResourcePackPushPacket(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), true);
    }

    public void addResourcePack(UUID id, String url, byte @Nullable [] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new ClientboundResourcePackPushPacket(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), false);
    }

    public void setResourcePack(UUID uuid, String url, byte @Nullable [] hashBytes, Component prompt, boolean force) {
        String hash;
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Resource pack UUID cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        if (hashBytes != null) {
            Preconditions.checkArgument((hashBytes.length == 20 ? 1 : 0) != 0, (Object)("Resource pack hash should be 20 bytes long but was " + hashBytes.length));
            hash = BaseEncoding.base16().lowerCase().encode(hashBytes);
        } else {
            hash = "";
        }
        this.getHandle().g.b(new ClientboundResourcePackPopPacket(Optional.empty()));
        this.getHandle().g.b(new ClientboundResourcePackPushPacket(uuid, url, hash, force, Optional.ofNullable(prompt).map(PaperAdventure::asVanilla)));
    }

    void sendBundle(List<? extends Packet<? extends ClientCommonPacketListener>> packet) {
        this.getHandle().g.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)packet));
    }

    public void sendResourcePacks(ResourcePackRequest request) {
        if (this.getHandle().g == null) {
            return;
        }
        ArrayList<ClientboundResourcePackPushPacket> packs = new ArrayList<ClientboundResourcePackPushPacket>(request.packs().size());
        if (request.replace()) {
            this.clearResourcePacks();
        }
        IChatBaseComponent prompt = PaperAdventure.asVanilla(request.prompt());
        Iterator iter = request.packs().iterator();
        while (iter.hasNext()) {
            ResourcePackInfo pack = (ResourcePackInfo)iter.next();
            packs.add(new ClientboundResourcePackPushPacket(pack.id(), pack.uri().toASCIIString(), pack.hash(), request.required(), iter.hasNext() ? Optional.empty() : Optional.ofNullable(prompt)));
            if (request.callback() == ResourcePackCallback.noOp()) continue;
            this.getHandle().g.packCallbacks.put(pack.id(), request.callback());
        }
        this.sendBundle(packs);
        super.sendResourcePacks(request);
    }

    public void removeResourcePacks(UUID id, UUID ... others) {
        if (this.getHandle().g == null) {
            return;
        }
        this.sendBundle(MonkeyBars.nonEmptyArrayToList(pack -> new ClientboundResourcePackPopPacket(Optional.of(pack)), (Object)id, (Object[])others));
    }

    public void clearResourcePacks() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new ClientboundResourcePackPopPacket(Optional.empty()));
    }

    public void showDialog(DialogLike dialog) {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().b(PaperDialog.bukkitToMinecraftHolder((Dialog)dialog));
    }

    public void closeDialog() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(ClientboundClearDialogPacket.a);
    }

    public PlayerResourcePackStatusEvent.Status getResourcePackStatus() {
        if (this.getHandle().g == null) {
            throw new UnsupportedOperationException("Too early to call this method at this stage");
        }
        return this.getHandle().g.e.resourcePackStatus;
    }

    public void removeResourcePack(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Resource pack id cannot be null");
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new ClientboundResourcePackPopPacket(Optional.of(id)));
    }

    public void removeResourcePacks() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new ClientboundResourcePackPopPacket(Optional.empty()));
    }

    private void handlePushResourcePack(ClientboundResourcePackPushPacket resourcePackPushPacket, boolean resetBeforePush) {
        if (this.getHandle().g == null) {
            return;
        }
        if (resetBeforePush) {
            this.removeResourcePacks();
        }
        this.getHandle().g.b(resourcePackPushPacket);
    }

    @Override
    public Set<String> channels() {
        if (this.getHandle().g == null) {
            return new HashSet<String>();
        }
        return this.getHandle().g.pluginMessagerChannels;
    }

    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels());
    }

    public void sendSupportedChannels() {
        if (this.getHandle().g == null) {
            return;
        }
        Set listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes(StandardCharsets.UTF_8));
                    stream.write(0);
                }
                catch (IOException ex) {
                    java.util.logging.Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.sendCustomPayload(ServerCommonPacketListenerImpl.CUSTOM_REGISTER, stream.toByteArray());
        }
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        Container container = this.getHandle().cn;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        container.b(prop.getId(), value);
        return true;
    }

    public void disconnect() {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    public boolean isFlying() {
        return this.getHandle().gL().b;
    }

    public void setFlying(boolean value) {
        boolean needsUpdate;
        boolean bl = needsUpdate = this.getHandle().gL().b != value;
        if (!this.getAllowFlight()) {
            Preconditions.checkArgument((!value ? 1 : 0) != 0, (Object)"Player is not allowed to fly (check #getAllowFlight())");
        }
        this.getHandle().gL().b = value;
        if (needsUpdate) {
            this.getHandle().z();
        }
    }

    public boolean getAllowFlight() {
        return this.getHandle().gL().c;
    }

    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().gL().b = false;
        }
        this.getHandle().gL().c = value;
        this.getHandle().z();
    }

    public void setFlyingFallDamage(@NonNull TriState flyingFallDamage) {
        this.getHandle().flyingFallDamage = flyingFallDamage;
    }

    public @NonNull TriState hasFlyingFallDamage() {
        return this.getHandle().flyingFallDamage;
    }

    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        EntityPlayer player = this.getHandle();
        player.gL().m = value / 2.0f;
        player.z();
    }

    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        EntityPlayer player = this.getHandle();
        player.gL().n = value / 2.0f;
        player.z();
        this.getHandle().h(GenericAttributes.x).a(player.gL().n);
    }

    public float getFlySpeed() {
        return this.getHandle().gL().m * 2.0f;
    }

    public float getWalkSpeed() {
        return this.getHandle().gL().n * 2.0f;
    }

    private void validateSpeed(float value) {
        Preconditions.checkArgument((value <= 1.0f && value >= -1.0f ? 1 : 0) != 0, (String)"Speed value (%s) need to be between -1f and 1f", (Object)Float.valueOf(value));
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, amount);
        this.getHandle().x();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().x();
    }

    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    public @Nullable CraftScoreboard getScoreboardOverride() {
        return this.scoreboardOverride;
    }

    public void setScoreboardOverride(@Nullable CraftScoreboard scoreboardOverride) {
        this.scoreboardOverride = scoreboardOverride;
    }

    public void setScoreboard(Scoreboard scoreboard) {
        Preconditions.checkArgument((scoreboard != null ? 1 : 0) != 0, (Object)"Scoreboard cannot be null");
        Preconditions.checkState((this.getHandle().g != null ? 1 : 0) != 0, (Object)"Cannot set scoreboard yet (invalid player connection)");
        if (!(scoreboard instanceof CraftScoreboard)) {
            throw new IllegalArgumentException("Cannot set player scoreboard to an unregistered Scoreboard");
        }
        CraftScoreboard craftScoreboard = (CraftScoreboard)scoreboard;
        this.server.getScoreboardManager().setPlayerBoard(this, craftScoreboard);
    }

    public void setHealthScale(double value) {
        Preconditions.checkArgument((value > 0.0 ? 1 : 0) != 0, (String)"Health value (%s) must be greater than 0", (Object)value);
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        if (Double.isNaN(health)) {
            return;
        }
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        if (this.getHandle().g != null) {
            this.getHandle().g.b(new PacketPlayOutUpdateAttributes(this.getHandle().aA(), Set.of(this.getScaledMaxHealth())));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().aD().a(EntityLiving.cd, Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturation) {
        this.getHandle().g.b(new PacketPlayOutUpdateHealth((float)health, foodLevel, saturation));
    }

    public void sendHealthUpdate() {
        FoodMetaData foodData = this.getHandle().gW();
        PacketPlayOutUpdateHealth packet = new PacketPlayOutUpdateHealth(this.getScaledHealth(), foodData.a(), foodData.d());
        if (this.getHandle().queueHealthUpdatePacket) {
            this.getHandle().queuedHealthUpdatePacket = packet;
        } else {
            this.getHandle().g.b(packet);
        }
    }

    public void injectScaledMaxHealth(Collection<AttributeModifiable> collection, boolean force) {
        if (!this.scaledHealth && !force) {
            return;
        }
        Iterator<AttributeModifiable> iterator = collection.iterator();
        while (iterator.hasNext()) {
            AttributeModifiable genericInstance = iterator.next();
            if (genericInstance.a() != GenericAttributes.u) continue;
            iterator.remove();
            break;
        }
        collection.add(this.getScaledMaxHealth());
    }

    public AttributeModifiable getScaledMaxHealth() {
        double healthMod;
        AttributeModifiable dummy = new AttributeModifiable(GenericAttributes.u, attribute -> {});
        double d2 = healthMod = this.scaledHealth ? this.healthScale : this.getMaxHealth();
        if (healthMod >= 3.4028234663852886E38 || healthMod <= 0.0) {
            healthMod = 20.0;
            this.getServer().getLogger().warning(this.getName() + " tried to crash the server with a large health attribute");
        }
        dummy.a(healthMod);
        return dummy;
    }

    public Entity getSpectatorTarget() {
        net.minecraft.world.entity.Entity followed = this.getHandle().N();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument((this.getGameMode() == GameMode.SPECTATOR ? 1 : 0) != 0, (Object)"Player must be in spectator mode");
        this.getHandle().d(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        ClientboundSetTitlesAnimationPacket times = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        this.getHandle().g.b(times);
        if (title != null) {
            ClientboundSetTitleTextPacket packetTitle = new ClientboundSetTitleTextPacket(CraftChatMessage.fromString(title)[0]);
            this.getHandle().g.b(packetTitle);
        }
        if (subtitle != null) {
            ClientboundSetSubtitleTextPacket packetSubtitle = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromString(subtitle)[0]);
            this.getHandle().g.b(packetSubtitle);
        }
    }

    public void resetTitle() {
        ClientboundClearTitlesPacket packet = new ClientboundClearTitlesPacket(true);
        this.getHandle().g.b(packet);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(CraftParticle.createParticleParam(particle, data), force, false, x2, y2, z2, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().g.b(packet);
    }

    public org.bukkit.advancement.AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        AdvancementDataPlayer data = this.getHandle().U();
        AdvancementProgress progress = data.b(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    public int getClientViewDistance() {
        return this.getHandle().H() == 0 ? Bukkit.getViewDistance() : this.getHandle().H();
    }

    public Locale locale() {
        return this.getHandle().adventure$locale;
    }

    public int getPing() {
        if (this.getHandle().g == null) {
            throw new UnsupportedOperationException("Too early to call this method at this stage");
        }
        return this.getHandle().g.k();
    }

    public String getLocale() {
        String locale = this.getHandle().dl;
        return locale != null ? locale : "en_us";
    }

    public void setAffectsSpawning(boolean affects) {
        this.getHandle().affectsSpawning = affects;
    }

    public boolean getAffectsSpawning() {
        return this.getHandle().affectsSpawning;
    }

    public void updateCommands() {
        if (this.getHandle().g == null) {
            return;
        }
        this.server.getServer().aF().a(this.getHandle());
    }

    @Override
    public void openSign(@NonNull Sign sign, @NonNull Side side) {
        CraftSign.openSign(sign, this, side);
    }

    public void openVirtualSign(Position block, Side side) {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new PacketPlayOutOpenSignEditor(MCUtil.toBlockPos(block), side == Side.FRONT));
    }

    public void showDemoScreen() {
        if (this.getHandle().g == null) {
            return;
        }
        this.getHandle().g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.g, 0.0f));
    }

    public boolean isAllowingServerListings() {
        return this.getHandle().aa();
    }

    public Component displayName() {
        return this.getHandle().adventure$displayName;
    }

    public void displayName(Component displayName) {
        this.getHandle().adventure$displayName = displayName != null ? displayName : Component.text((String)this.getName());
        this.getHandle().displayName = null;
    }

    public void deleteMessage(SignedMessage.Signature signature) {
        if (this.getHandle().g == null) {
            return;
        }
        MessageSignature sig = new MessageSignature(signature.bytes());
        this.getHandle().g.b(new ClientboundDeleteChatPacket(new MessageSignature.a(sig)));
    }

    private ChatMessageType.a toHandle(ChatType.Bound boundChatType) {
        IRegistry<net.minecraft.network.chat.ChatMessageType> chatTypeRegistry = this.getHandle().A().J_().f(Registries.aU);
        return new ChatMessageType.a(chatTypeRegistry.b(ResourceKey.a(Registries.aU, PaperAdventure.asVanilla(boundChatType.type().key()))), PaperAdventure.asVanilla(boundChatType.name()), Optional.ofNullable(PaperAdventure.asVanilla(boundChatType.target())));
    }

    public void sendMessage(Component message, ChatType.Bound boundChatType) {
        if (this.getHandle().g == null) {
            return;
        }
        IChatBaseComponent component = PaperAdventure.asVanilla(message);
        this.getHandle().a(new OutgoingChatMessage.a(component), this.getHandle().Z(), this.toHandle(boundChatType));
    }

    public void sendMessage(SignedMessage signedMessage, ChatType.Bound boundChatType) {
        Component message;
        if (this.getHandle().g == null) {
            return;
        }
        if (signedMessage instanceof PlayerChatMessage.AdventureView) {
            PlayerChatMessage.AdventureView view = (PlayerChatMessage.AdventureView)signedMessage;
            this.getHandle().a(OutgoingChatMessage.a(view.playerChatMessage()), this.getHandle().Z(), this.toHandle(boundChatType));
            return;
        }
        Object object = message = signedMessage.unsignedContent() == null ? Component.text((String)signedMessage.message()) : signedMessage.unsignedContent();
        if (signedMessage.isSystem()) {
            this.sendMessage(message, boundChatType);
        } else {
            super.sendMessage(signedMessage, boundChatType);
        }
    }

    @Deprecated(forRemoval=true)
    public void sendMessage(Identity identity, Component message, MessageType type) {
        if (this.getHandle().g == null) {
            return;
        }
        IRegistry<net.minecraft.network.chat.ChatMessageType> chatTypeRegistry = this.getHandle().A().J_().f(Registries.aU);
        this.getHandle().g.b(new ClientboundSystemChatPacket(message, false));
    }

    public void sendActionBar(Component message) {
        ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket(PaperAdventure.asVanillaNullToEmpty(message));
        this.getHandle().g.b(packet);
    }

    public void sendPlayerListHeader(Component header) {
        this.playerListHeader = header;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListFooter(Component footer) {
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.playerListHeader = header;
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    private void adventure$sendPlayerListHeaderAndFooter() {
        PlayerConnection connection = this.getHandle().g;
        if (connection == null) {
            return;
        }
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter(PaperAdventure.asVanillaNullToEmpty(this.playerListHeader), PaperAdventure.asVanillaNullToEmpty(this.playerListFooter));
        connection.b(packet);
    }

    public void showTitle(net.kyori.adventure.title.Title title) {
        PlayerConnection connection = this.getHandle().g;
        Title.Times times = title.times();
        if (times != null) {
            connection.b(new ClientboundSetTitlesAnimationPacket(CraftPlayer.ticks(times.fadeIn()), CraftPlayer.ticks(times.stay()), CraftPlayer.ticks(times.fadeOut())));
        }
        ClientboundSetSubtitleTextPacket sp = new ClientboundSetSubtitleTextPacket(PaperAdventure.asVanilla(title.subtitle()));
        connection.b(sp);
        ClientboundSetTitleTextPacket tp = new ClientboundSetTitleTextPacket(PaperAdventure.asVanilla(title.title()));
        connection.b(tp);
    }

    public <T> void sendTitlePart(TitlePart<T> part, T value) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value cannot be null");
        if (part == TitlePart.TITLE) {
            ClientboundSetTitleTextPacket tp = new ClientboundSetTitleTextPacket(PaperAdventure.asVanilla((Component)value));
            this.getHandle().g.b(tp);
        } else if (part == TitlePart.SUBTITLE) {
            ClientboundSetSubtitleTextPacket sp = new ClientboundSetSubtitleTextPacket(PaperAdventure.asVanilla((Component)value));
            this.getHandle().g.b(sp);
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            this.getHandle().g.b(new ClientboundSetTitlesAnimationPacket(CraftPlayer.ticks(times.fadeIn()), CraftPlayer.ticks(times.stay()), CraftPlayer.ticks(times.fadeOut())));
        } else {
            throw new IllegalArgumentException("Unknown TitlePart");
        }
    }

    private static int ticks(Duration duration) {
        if (duration == null) {
            return -1;
        }
        return (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        this.getHandle().g.b(new ClientboundClearTitlesPacket(false));
    }

    public @NonNull Iterable<? extends BossBar> activeBossBars() {
        if (this.activeBossBars != null) {
            return Collections.unmodifiableSet(this.activeBossBars);
        }
        return Set.of();
    }

    public void showBossBar(BossBar bar) {
        ((BossBarImplementationImpl)BossBarImplementation.get((BossBar)bar, BossBarImplementationImpl.class)).playerShow(this);
        if (this.activeBossBars == null) {
            this.activeBossBars = new HashSet<BossBar>();
        }
        this.activeBossBars.add(bar);
    }

    public void hideBossBar(BossBar bar) {
        ((BossBarImplementationImpl)BossBarImplementation.get((BossBar)bar, BossBarImplementationImpl.class)).playerHide(this);
        if (this.activeBossBars != null) {
            this.activeBossBars.remove(bar);
            if (this.activeBossBars.isEmpty()) {
                this.activeBossBars = null;
            }
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound) {
        Vec3D pos = this.getHandle().dI();
        this.playSound(sound, pos.g, pos.h, pos.i);
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, double x2, double y2, double z2) {
        this.getHandle().g.b(PaperAdventure.asSoundPacket(sound, x2, y2, z2, sound.seed().orElseGet(this.getHandle().ep()::g), null));
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, Sound.Emitter emitter) {
        net.minecraft.world.entity.Entity entity;
        if (emitter == Sound.Emitter.self()) {
            entity = this.getHandle();
        } else if (emitter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)emitter;
            entity = craftEntity.getHandle();
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + String.valueOf(emitter));
        }
        this.getHandle().g.b(PaperAdventure.asSoundPacket(sound, entity, sound.seed().orElseGet(this.getHandle().ep()::g), null));
    }

    public void stopSound(SoundStop stop) {
        this.getHandle().g.b(new PacketPlayOutStopSound(PaperAdventure.asVanillaNullable(stop.sound()), PaperAdventure.asVanillaNullable(stop.source())));
    }

    public void openBook(org.bukkit.inventory.ItemStack book) {
        Preconditions.checkArgument((book != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        Preconditions.checkArgument((boolean)book.hasData((DataComponentType)DataComponentTypes.WRITTEN_BOOK_CONTENT), (Object)"ItemStack must have a 'written_book_content' component");
        ItemStack bookItem = CraftItemStack.asNMSCopy(book);
        EntityPlayer serverPlayer = this.getHandle();
        WrittenBookContent.a(bookItem, serverPlayer.C(), serverPlayer);
        this.sendBookOpen(bookItem);
    }

    public void openBook(Book book) {
        org.bukkit.inventory.ItemStack mutatedItem = ItemType.WRITTEN_BOOK.createItemStack();
        mutatedItem.setData(DataComponentTypes.WRITTEN_BOOK_CONTENT, (DataComponentBuilder)io.papermc.paper.datacomponent.item.WrittenBookContent.writtenBookContent((String)"", (String)"").addPages(book.pages()));
        this.sendBookOpen(CraftItemStack.unwrap(mutatedItem));
    }

    private void sendBookOpen(ItemStack bookItem) {
        ItemStack selectedItem = this.getHandle().gK().h();
        int slot = this.getHandle().gK().g();
        this.getHandle().g.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new ClientboundSetPlayerInventoryPacket(slot, bookItem), new PacketPlayOutOpenBook(EnumHand.a), new ClientboundSetPlayerInventoryPacket(slot, selectedItem))));
    }

    @Override
    public Pointers pointers() {
        return POINTERS_SUPPLIER.view((Object)this);
    }

    public float getCooldownPeriod() {
        return this.getHandle().he();
    }

    public float getCooledAttackStrength(float adjustTicks) {
        return this.getHandle().I(adjustTicks);
    }

    public void resetCooldown() {
        this.getHandle().hf();
    }

    public String getClientBrandName() {
        return this.getHandle().g.playerBrand;
    }

    public void showElderGuardian(boolean silent) {
        if (this.getHandle().g != null) {
            this.getHandle().g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.l, silent ? 0.0f : 1.0f));
        }
    }

    public int getWardenWarningCooldown() {
        return this.getHandle().dw.i;
    }

    public void setWardenWarningCooldown(int cooldown) {
        this.getHandle().dw.i = Math.max(cooldown, 0);
    }

    public int getWardenTimeSinceLastWarning() {
        return this.getHandle().dw.g;
    }

    public void setWardenTimeSinceLastWarning(int time) {
        this.getHandle().dw.g = time;
    }

    public int getWardenWarningLevel() {
        return this.getHandle().dw.c();
    }

    public void setWardenWarningLevel(int warningLevel) {
        this.getHandle().dw.a(warningLevel);
    }

    public void increaseWardenWarningLevel() {
        this.getHandle().dw.e();
    }

    public Duration getIdleDuration() {
        return Duration.ofMillis(SystemUtils.c() - this.getHandle().P());
    }

    public void resetIdleDuration() {
        this.getHandle().J();
    }

    public Set<Long> getSentChunkKeys() {
        AsyncCatcher.catchOp("accessing sent chunks");
        return FeatureHooks.getSentChunkKeys(this.getHandle());
    }

    public Set<Chunk> getSentChunks() {
        AsyncCatcher.catchOp("accessing sent chunks");
        return FeatureHooks.getSentChunks(this.getHandle());
    }

    public boolean isChunkSent(long chunkKey) {
        AsyncCatcher.catchOp("accessing sent chunks");
        return FeatureHooks.isChunkSent(this.getHandle(), chunkKey);
    }

    public Player.Spigot spigot() {
        return this.spigot;
    }

    public int getViewDistance() {
        return PlatformHooks.get().getViewDistance(this.getHandle());
    }

    public void setViewDistance(int viewDistance) {
        FeatureHooks.setViewDistance(this.getHandle(), viewDistance);
    }

    public int getSimulationDistance() {
        return PlatformHooks.get().getTickViewDistance(this.getHandle());
    }

    public void setSimulationDistance(int simulationDistance) {
        FeatureHooks.setSimulationDistance(this.getHandle(), simulationDistance);
    }

    public int getSendViewDistance() {
        return PlatformHooks.get().getSendViewDistance(this.getHandle());
    }

    public void setSendViewDistance(int viewDistance) {
        FeatureHooks.setSendViewDistance(this.getHandle(), viewDistance);
    }

    public void sendEntityEffect(EntityEffect effect, Entity target) {
        if (this.getHandle().g == null) {
            return;
        }
        Preconditions.checkArgument((boolean)effect.isApplicableTo(target), (Object)"Entity effect cannot apply to the target");
        this.getHandle().g.b(new PacketPlayOutEntityStatus(((CraftEntity)target).getHandle(), effect.getData()));
    }

    public @NonNull PlayerGiveResult give(@NonNull Collection<@NonNull org.bukkit.inventory.ItemStack> items, boolean dropIfFull) {
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        if (items.isEmpty()) {
            return PaperPlayerGiveResult.EMPTY;
        }
        for (org.bukkit.inventory.ItemStack item : items) {
            Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
            Preconditions.checkArgument((!item.isEmpty() ? 1 : 0) != 0, (Object)"ItemStack cannot be empty");
            Preconditions.checkArgument((item.getAmount() <= item.getMaxStackSize() ? 1 : 0) != 0, (Object)"ItemStack amount cannot be greater than its max stack size");
        }
        EntityPlayer handle = this.getHandle();
        ImmutableList.Builder drops = ImmutableList.builder();
        ImmutableList.Builder leftovers = ImmutableList.builder();
        for (org.bukkit.inventory.ItemStack item : items) {
            EntityItem entity;
            ItemStack nmsStack = CraftItemStack.asNMSCopy(item);
            boolean added = handle.gK().g(nmsStack);
            if (added && nmsStack.f()) continue;
            leftovers.add((Object)CraftItemStack.asBukkitCopy(nmsStack));
            if (!dropIfFull || (entity = handle.a(nmsStack, false, true)) == null) continue;
            drops.add((Object)((Item)entity.getBukkitEntity()));
        }
        handle.cn.d();
        return new PaperPlayerGiveResult((Collection<org.bukkit.inventory.ItemStack>)leftovers.build(), (Collection<Item>)drops.build());
    }

    @Override
    public float getSidewaysMovement() {
        boolean rightMovement;
        boolean leftMovement = this.getHandle().ai().c();
        return leftMovement == (rightMovement = this.getHandle().ai().d()) ? 0.0f : (leftMovement ? 1.0f : -1.0f);
    }

    @Override
    public float getForwardsMovement() {
        boolean backwardMovement;
        boolean forwardMovement = this.getHandle().ai().a();
        return forwardMovement == (backwardMovement = this.getHandle().ai().b()) ? 0.0f : (forwardMovement ? 1.0f : -1.0f);
    }

    public int getDeathScreenScore() {
        return this.getHandle().gF();
    }

    public void setDeathScreenScore(int score) {
        this.getHandle().q(score);
    }

    public PlayerGameConnection getConnection() {
        return this.getHandle().g.playerGameConnection;
    }

    @Override
    public Entity releaseLeftShoulderEntity() {
        net.minecraft.world.entity.Entity entity;
        if (!this.getHandle().al().j() && (entity = this.getHandle().releaseLeftShoulderEntity()) != null) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public Entity releaseRightShoulderEntity() {
        net.minecraft.world.entity.Entity entity;
        if (!this.getHandle().am().j() && (entity = this.getHandle().releaseRightShoulderEntity()) != null) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().al().j()) {
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this.getHandle().es(), LOGGER);){
                Entity entity = EntityTypes.a(TagValueInput.a(scopedCollector.a(() -> ".shoulder"), (HolderLookup.a)this.getHandle().eo(), this.getHandle().al()), (World)this.getHandle().A(), EntitySpawnReason.r).map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
                return entity;
            }
        }
        return null;
    }

    @Override
    public void setShoulderEntityLeft(Entity entity) {
        if (entity != null) {
            Preconditions.checkArgument((boolean)((CraftEntity)entity).getHandle().ay().b(), (String)"Cannot set entity of type %s as a shoulder entity", (Object)entity.getType().getKey());
        }
        this.getHandle().b(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    @Override
    public Entity getShoulderEntityRight() {
        if (!this.getHandle().am().j()) {
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this.getHandle().es(), LOGGER);){
                Entity entity = EntityTypes.a(TagValueInput.a(scopedCollector.a(() -> ".shoulder"), (HolderLookup.a)this.getHandle().eo(), this.getHandle().am()), (World)this.getHandle().A(), EntitySpawnReason.r).map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
                return entity;
            }
        }
        return null;
    }

    @Override
    public void setShoulderEntityRight(Entity entity) {
        if (entity != null) {
            Preconditions.checkArgument((boolean)((CraftEntity)entity).getHandle().ay().b(), (String)"Cannot set entity of type %s as a shoulder entity", (Object)entity.getType().getKey());
        }
        this.getHandle().c(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    private record ChunkSectionChanges(ShortSet positions, List<IBlockData> blockData) {
        public ChunkSectionChanges() {
            this((ShortSet)new ShortArraySet(), new ArrayList<IBlockData>());
        }
    }
}

