/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityPotion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftThrowableProjectile;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionUtil;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public abstract class CraftThrownPotion
extends CraftThrowableProjectile
implements ThrownPotion {
    protected CraftThrownPotion(CraftServer server, EntityPotion entity) {
        super(server, entity);
    }

    @Override
    public EntityPotion getHandle() {
        return (EntityPotion)this.entity;
    }

    public Collection<PotionEffect> getEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : this.getHandle().e().a(DataComponents.Y, PotionContents.a).a()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().e());
    }

    public void setPotionMeta(PotionMeta meta) {
        net.minecraft.world.item.ItemStack item = this.getHandle().e();
        CraftItemStack.applyMetaToItem(item, (ItemMeta)meta);
        this.getHandle().a(item);
    }

    public void splash() {
        this.getHandle().splash(null);
    }
}

