/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.zombie.EntityZombieVillager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZombie;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CraftVillagerZombie
extends CraftZombie
implements ZombieVillager {
    public CraftVillagerZombie(CraftServer server, EntityZombieVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityZombieVillager getHandle() {
        return (EntityZombieVillager)this.entity;
    }

    @Override
    public Villager.Profession getVillagerProfession() {
        return CraftVillager.CraftProfession.minecraftHolderToBukkit(this.getHandle().gZ().b());
    }

    @Override
    public void setVillagerProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Villager.Profession cannot be null");
        this.getHandle().a(this.getHandle().gZ().b(CraftVillager.CraftProfession.bukkitToMinecraftHolder(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftVillager.CraftType.minecraftHolderToBukkit(this.getHandle().gZ().a());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Villager.Type cannot be null");
        this.getHandle().a(this.getHandle().gZ().a(CraftVillager.CraftType.bukkitToMinecraftHolder(type)));
    }

    @Override
    public boolean isConverting() {
        return this.getHandle().gS();
    }

    @Override
    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.getHandle().cC;
    }

    @Override
    public void setConversionTime(int time) {
        this.setConversionTime(time, true);
    }

    public void setConversionTime(int time, boolean broadcastEntityEvent) {
        if (time < 0) {
            this.getHandle().cC = -1;
            this.getHandle().aD().a(EntityZombieVillager.a, false);
            this.getHandle().cD = null;
            this.getHandle().removeEffect(MobEffects.e, EntityPotionEffectEvent.Cause.CONVERSION);
        } else {
            this.getHandle().startConverting(null, time, broadcastEntityEvent);
        }
    }

    public OfflinePlayer getConversionPlayer() {
        return this.getHandle().cD == null ? null : Bukkit.getOfflinePlayer((UUID)this.getHandle().cD);
    }

    public void setConversionPlayer(OfflinePlayer conversionPlayer) {
        if (!this.isConverting()) {
            return;
        }
        this.getHandle().cD = conversionPlayer == null ? null : conversionPlayer.getUniqueId();
    }
}

