/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Suppliers;
import io.papermc.paper.registry.HolderableBase;
import io.papermc.paper.world.flag.PaperFeatureDependent;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.inventory.util.CraftMenus;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftMenuType<V extends @NonNull InventoryView, B extends InventoryViewBuilder<V>>
extends HolderableBase<Containers<?>>
implements MenuType.Typed<V, B>,
PaperFeatureDependent<Containers<?>> {
    private final Supplier<CraftMenus.MenuTypeData<V, B>> typeData = Suppliers.memoize(() -> CraftMenus.getMenuTypeData(this));

    public CraftMenuType(Holder<Containers<?>> holder) {
        super(holder);
    }

    public V create(HumanEntity player, @Nullable String title) {
        return (V)this.builder().title(title != null ? LegacyComponentSerializer.legacySection().deserialize(title) : null).build(player);
    }

    public V create(HumanEntity player, @Nullable Component title) {
        return (V)this.builder().title(title).build(player);
    }

    public B builder() {
        return (B)((InventoryViewBuilder)this.typeData.get().viewBuilder().get());
    }

    public MenuType.Typed<InventoryView, InventoryViewBuilder<InventoryView>> typed() {
        return this.typed(InventoryView.class);
    }

    public <NV extends InventoryView, NB extends InventoryViewBuilder<NV>> MenuType.Typed<NV, NB> typed(Class<NV> clazz) {
        if (clazz.isAssignableFrom(this.typeData.get().viewClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type InventoryView " + String.valueOf(this) + " to InventoryView type " + clazz.getSimpleName());
    }

    public Class<? extends InventoryView> getInventoryViewClass() {
        return this.typeData.get().viewClass();
    }

    public static MenuType minecraftToBukkit(Containers<?> minecraft) {
        return (MenuType)CraftRegistry.minecraftToBukkit(minecraft, Registries.ad);
    }

    public static MenuType minecraftHolderToBukkit(Holder<Containers<?>> minecraft) {
        return (MenuType)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.ad);
    }
}

