/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.component.LodestoneTracker;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.inventory.meta.CompassMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaCompass
extends CraftMetaItem
implements CompassMeta {
    static final CraftMetaItem.ItemMetaKeyType<LodestoneTracker> LODESTONE_TARGET = new CraftMetaItem.ItemMetaKeyType<LodestoneTracker>(DataComponents.ao, "LodestoneDimension");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS = new CraftMetaItem.ItemMetaKey("lodestone");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_WORLD = new CraftMetaItem.ItemMetaKey("LodestonePosWorld");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_X = new CraftMetaItem.ItemMetaKey("LodestonePosX");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_Y = new CraftMetaItem.ItemMetaKey("LodestonePosY");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_Z = new CraftMetaItem.ItemMetaKey("LodestonePosZ");
    static final CraftMetaItem.ItemMetaKey LODESTONE_TRACKED = new CraftMetaItem.ItemMetaKey("LodestoneTracked");
    private LodestoneTracker tracker;

    CraftMetaCompass(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaCompass)) {
            return;
        }
        CraftMetaCompass compassMeta = (CraftMetaCompass)meta;
        this.tracker = compassMeta.tracker;
    }

    CraftMetaCompass(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaCompass.getOrEmpty(tag, LODESTONE_TARGET).ifPresent(lodestoneTarget -> {
            this.tracker = lodestoneTarget;
        });
    }

    CraftMetaCompass(Map<String, Object> map) {
        super(map);
        String lodestoneWorldKey = SerializableMeta.getString(map, CraftMetaCompass.LODESTONE_POS_WORLD.BUKKIT, true);
        if (lodestoneWorldKey != null) {
            ResourceKey<net.minecraft.world.level.World> lodestoneWorld = ResourceKey.a(Registries.bE, MinecraftKey.c(lodestoneWorldKey));
            int lodestoneX = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_X.BUKKIT);
            int lodestoneY = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_Y.BUKKIT);
            int lodestoneZ = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_Z.BUKKIT);
            this.tracker = new LodestoneTracker(Optional.of(new GlobalPos(lodestoneWorld, new BlockPosition(lodestoneX, lodestoneY, lodestoneZ))), true);
        } else {
            Location lodestone = SerializableMeta.getObject(Location.class, map, CraftMetaCompass.LODESTONE_POS.BUKKIT, true);
            if (lodestone != null && lodestone.getWorld() != null) {
                this.setLodestone(lodestone);
            }
        }
        Optional<Boolean> tracked = SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaCompass.LODESTONE_TRACKED.BUKKIT, true);
        Optional trackedPos = this.tracker != null ? this.tracker.a() : Optional.empty();
        tracked.ifPresent(isTracked -> {
            this.tracker = new LodestoneTracker(trackedPos, (boolean)isTracked);
        });
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.tracker != null) {
            tag.put(LODESTONE_TARGET, this.tracker);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isCompassEmpty();
    }

    boolean isCompassEmpty() {
        return this.tracker == null;
    }

    @Override
    public CraftMetaCompass clone() {
        CraftMetaCompass clone = (CraftMetaCompass)super.clone();
        return clone;
    }

    public boolean hasLodestone() {
        return this.tracker != null && this.tracker.a().isPresent();
    }

    public Location getLodestone() {
        if (this.tracker == null || this.tracker.a().isEmpty()) {
            return null;
        }
        WorldServer level = MinecraftServer.getServer().a(this.tracker.a().get().a());
        CraftWorld world = level != null ? level.getWorld() : null;
        return CraftLocation.toBukkit((BaseBlockPosition)this.tracker.a().get().b(), (World)world);
    }

    public void setLodestone(Location lodestone) {
        Preconditions.checkArgument((lodestone == null || lodestone.getWorld() != null ? 1 : 0) != 0, (Object)"world is null");
        if (lodestone == null) {
            if (this.tracker != null) {
                this.tracker = new LodestoneTracker(Optional.empty(), this.tracker.b());
            }
        } else {
            GlobalPos pos = GlobalPos.a(((CraftWorld)lodestone.getWorld()).getHandle().aq(), CraftLocation.toBlockPosition(lodestone));
            boolean tracked = this.tracker == null || this.tracker.b();
            this.tracker = new LodestoneTracker(Optional.of(pos), tracked);
        }
    }

    public boolean isLodestoneTracked() {
        return this.tracker != null && this.tracker.b();
    }

    public void setLodestoneTracked(boolean tracked) {
        Optional<GlobalPos> trackedPos = this.tracker != null ? this.tracker.a() : Optional.empty();
        this.tracker = new LodestoneTracker(trackedPos, tracked);
    }

    public boolean isLodestoneCompass() {
        return this.tracker != null;
    }

    public void clearLodestone() {
        this.tracker = null;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.isLodestoneCompass()) {
            hash = 73 * hash + this.tracker.hashCode();
        }
        return original != hash ? CraftMetaCompass.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaCompass) {
            CraftMetaCompass other = (CraftMetaCompass)meta;
            return Objects.equals(this.tracker, other.tracker);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaCompass || this.isCompassEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.isLodestoneCompass()) {
            if (this.tracker.a().isPresent()) {
                builder.put((Object)CraftMetaCompass.LODESTONE_POS_WORLD.BUKKIT, (Object)this.tracker.a().get().a().a().toString());
                builder.put((Object)CraftMetaCompass.LODESTONE_POS_X.BUKKIT, (Object)this.tracker.a().get().b().u());
                builder.put((Object)CraftMetaCompass.LODESTONE_POS_Y.BUKKIT, (Object)this.tracker.a().get().b().v());
                builder.put((Object)CraftMetaCompass.LODESTONE_POS_Z.BUKKIT, (Object)this.tracker.a().get().b().w());
            }
            builder.put((Object)CraftMetaCompass.LODESTONE_TRACKED.BUKKIT, (Object)this.tracker.b());
        }
        return builder;
    }
}

