/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaSkull
extends CraftMetaItem
implements SkullMeta {
    static final CraftMetaItem.ItemMetaKeyType<ResolvableProfile> SKULL_PROFILE = new CraftMetaItem.ItemMetaKeyType<ResolvableProfile>(DataComponents.ar, "SkullProfile");
    static final CraftMetaItem.ItemMetaKey SKULL_OWNER = new CraftMetaItem.ItemMetaKey("skull-owner");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKey("BlockEntityTag");
    static final CraftMetaItem.ItemMetaKeyType<MinecraftKey> NOTE_BLOCK_SOUND = new CraftMetaItem.ItemMetaKeyType<MinecraftKey>(DataComponents.as, "note_block_sound");
    static final int MAX_OWNER_LENGTH = 16;
    private ResolvableProfile profile;
    private MinecraftKey noteBlockSound;

    CraftMetaSkull(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSkull)) {
            return;
        }
        CraftMetaSkull skullMeta = (CraftMetaSkull)meta;
        this.setProfile(skullMeta.profile);
        this.noteBlockSound = skullMeta.noteBlockSound;
    }

    CraftMetaSkull(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaSkull.getOrEmpty(tag, SKULL_PROFILE).ifPresent(this::setProfile);
        CraftMetaSkull.getOrEmpty(tag, NOTE_BLOCK_SOUND).ifPresent(noteBlockSound -> {
            this.noteBlockSound = noteBlockSound;
        });
    }

    CraftMetaSkull(Map<String, Object> map) {
        super(map);
        Object object;
        if (this.profile == null) {
            object = map.get(CraftMetaSkull.SKULL_OWNER.BUKKIT);
            if (object instanceof org.bukkit.profile.PlayerProfile) {
                org.bukkit.profile.PlayerProfile playerProfile = (org.bukkit.profile.PlayerProfile)object;
                this.setOwnerProfile(playerProfile);
            } else {
                this.setOwner(SerializableMeta.getString(map, CraftMetaSkull.SKULL_OWNER.BUKKIT, true));
            }
        }
        if (this.noteBlockSound == null && (object = map.get(CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT)) != null) {
            this.setNoteBlockSound(NamespacedKey.fromString((String)object.toString()));
        }
    }

    @Override
    void deserializeInternal(NBTTagCompound tag, Object context) {
        super.deserializeInternal(tag, context);
        tag.m(CraftMetaSkull.SKULL_PROFILE.NBT).ifPresent(skullTag -> {
            skullTag.a("Id", UUIDUtil.d).ifPresent(legacyId -> skullTag.a("Id", UUIDUtil.a, legacyId));
            ResolvableProfile.a.parse((DynamicOps)DynamicOpsNBT.a, skullTag).result().ifPresent(this::setProfile);
        });
        tag.m(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT).flatMap(blockEntityTag -> blockEntityTag.l().i(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT)).ifPresent(noteBlockSound -> {
            this.noteBlockSound = MinecraftKey.c(noteBlockSound);
        });
    }

    private void setProfile(ResolvableProfile profile) {
        this.profile = profile;
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.hasOwner()) {
            tag.put(SKULL_PROFILE, this.profile);
            CraftPlayerProfile ownerProfile = new CraftPlayerProfile(this.profile);
            if (ownerProfile.getTextures().isEmpty()) {
                ownerProfile.update().thenAcceptAsync(filledProfile -> {
                    this.setOwnerProfile((org.bukkit.profile.PlayerProfile)filledProfile);
                    tag.skullCallback(this.profile);
                }, (Executor)((CraftServer)Bukkit.getServer()).getServer());
            }
        }
        if (this.noteBlockSound != null) {
            tag.put(NOTE_BLOCK_SOUND, this.noteBlockSound);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isSkullEmpty();
    }

    boolean isSkullEmpty() {
        return this.profile == null && this.noteBlockSound == null;
    }

    @Override
    public CraftMetaSkull clone() {
        return (CraftMetaSkull)super.clone();
    }

    public boolean hasOwner() {
        return this.profile != null;
    }

    public String getOwner() {
        return this.hasOwner() ? (String)this.profile.d().orElse(null) : null;
    }

    public void setPlayerProfile(@Nullable PlayerProfile profile) {
        this.setProfile(profile == null ? null : com.destroystokyo.paper.profile.CraftPlayerProfile.asResolvableProfileCopy(profile));
    }

    @Nullable
    public PlayerProfile getPlayerProfile() {
        return this.profile != null ? new com.destroystokyo.paper.profile.CraftPlayerProfile(this.profile) : null;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            GameProfile gameProfile = this.profile.b();
            if (!gameProfile.id().equals(SystemUtils.e)) {
                return Bukkit.getOfflinePlayer((UUID)gameProfile.id());
            }
            if (!gameProfile.name().isEmpty()) {
                return Bukkit.getOfflinePlayer((String)gameProfile.name());
            }
        }
        return null;
    }

    public boolean setOwner(String name) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (name == null) {
            this.setProfile(null);
        } else {
            EntityPlayer player = MinecraftServer.getServer().aj().a(name);
            this.setProfile(player != null ? ResolvableProfile.a(player.gI()) : new ResolvableProfile.Dynamic(Either.left(name), PlayerSkin.Patch.a));
        }
        return true;
    }

    public boolean setOwningPlayer(OfflinePlayer owner) {
        if (owner == null) {
            this.setProfile(null);
        } else if (owner instanceof CraftPlayer) {
            CraftPlayer craftPlayer = (CraftPlayer)owner;
            this.setProfile(ResolvableProfile.a(craftPlayer.getProfile()));
        } else {
            this.setProfile(new ResolvableProfile.Dynamic(Either.right(owner.getUniqueId()), PlayerSkin.Patch.a));
        }
        return true;
    }

    @Deprecated
    public org.bukkit.profile.PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    @Deprecated
    public void setOwnerProfile(org.bukkit.profile.PlayerProfile profile) {
        if (profile instanceof SharedPlayerProfile) {
            SharedPlayerProfile sharedProfile = (SharedPlayerProfile)profile;
            this.setProfile(sharedProfile.buildResolvableProfile());
        } else {
            this.setProfile(null);
        }
    }

    public void setNoteBlockSound(NamespacedKey noteBlockSound) {
        this.noteBlockSound = noteBlockSound == null ? null : CraftNamespacedKey.toMinecraft(noteBlockSound);
    }

    public NamespacedKey getNoteBlockSound() {
        return this.noteBlockSound == null ? null : CraftNamespacedKey.fromMinecraft(this.noteBlockSound);
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasOwner()) {
            hash = 61 * hash + this.profile.hashCode();
        }
        if (this.noteBlockSound != null) {
            hash = 61 * hash + this.noteBlockSound.hashCode();
        }
        return original != hash ? CraftMetaSkull.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSkull) {
            CraftMetaSkull other = (CraftMetaSkull)meta;
            return Objects.equals(this.profile, other.profile) && Objects.equals(this.noteBlockSound, other.noteBlockSound);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSkull || this.isSkullEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        NamespacedKey noteBlockSound;
        super.serialize(builder);
        if (this.hasOwner()) {
            builder.put((Object)CraftMetaSkull.SKULL_OWNER.BUKKIT, (Object)new com.destroystokyo.paper.profile.CraftPlayerProfile(this.profile));
        }
        if ((noteBlockSound = this.getNoteBlockSound()) != null) {
            builder.put((Object)CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT, (Object)noteBlockSound.toString());
        }
        return builder;
    }
}

