/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TypedEntityData;
import org.bukkit.DyeColor;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaTropicalFishBucket
extends CraftMetaItem
implements TropicalFishBucketMeta {
    static final CraftMetaItem.ItemMetaKey VARIANT = new CraftMetaItem.ItemMetaKey("BucketVariantTag", "fish-variant");
    static final CraftMetaItem.ItemMetaKeyType<TypedEntityData<EntityTypes<?>>> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(DataComponents.af, "entity-tag");
    static final CraftMetaItem.ItemMetaKeyType<CustomData> BUCKET_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.ag, "bucket-entity-tag");
    private Integer variant;
    private NBTTagCompound entityTag;
    private NBTTagCompound bucketEntityTag;

    CraftMetaTropicalFishBucket(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaTropicalFishBucket)) {
            return;
        }
        CraftMetaTropicalFishBucket tropicalFishBucketMeta = (CraftMetaTropicalFishBucket)meta;
        this.variant = tropicalFishBucketMeta.variant;
        this.entityTag = tropicalFishBucketMeta.entityTag;
        this.bucketEntityTag = tropicalFishBucketMeta.bucketEntityTag;
    }

    CraftMetaTropicalFishBucket(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaTropicalFishBucket.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt.copyTagWithEntityId();
            this.entityTag.e(CraftMetaTropicalFishBucket.VARIANT.NBT).ifPresent(variant -> {
                this.variant = variant;
            });
        });
        CraftMetaTropicalFishBucket.getOrEmpty(tag, BUCKET_ENTITY_TAG).ifPresent(nbt -> {
            this.bucketEntityTag = nbt.b();
            this.bucketEntityTag.e(CraftMetaTropicalFishBucket.VARIANT.NBT).ifPresent(variant -> {
                this.variant = variant;
            });
        });
    }

    CraftMetaTropicalFishBucket(Map<String, Object> map) {
        super(map);
        Integer variant = SerializableMeta.getObject(Integer.class, map, CraftMetaTropicalFishBucket.VARIANT.BUKKIT, true);
        if (variant != null) {
            this.variant = variant;
        }
    }

    @Override
    void deserializeInternal(NBTTagCompound tag, Object context) {
        super.deserializeInternal(tag, context);
        this.entityTag = tag.m(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT).orElse(this.entityTag);
        this.bucketEntityTag = tag.m(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT).orElse(this.bucketEntityTag);
    }

    @Override
    void serializeInternal(Map<String, NBTBase> internalTags) {
        if (this.entityTag != null && !this.entityTag.j()) {
            internalTags.put(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT, this.entityTag);
        }
        if (this.bucketEntityTag != null && !this.bucketEntityTag.j()) {
            internalTags.put(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT, this.bucketEntityTag);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        NBTTagCompound bucketEntityTag;
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, TypedEntityData.decodeEntity(this.entityTag));
        }
        NBTTagCompound nBTTagCompound = bucketEntityTag = this.bucketEntityTag != null ? this.bucketEntityTag.l() : null;
        if (this.hasVariant()) {
            if (bucketEntityTag == null) {
                bucketEntityTag = new NBTTagCompound();
            }
            bucketEntityTag.a(CraftMetaTropicalFishBucket.VARIANT.NBT, this.variant);
        }
        if (bucketEntityTag != null) {
            tag.put(BUCKET_ENTITY_TAG, CustomData.a(bucketEntityTag));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBucketEmpty();
    }

    boolean isBucketEmpty() {
        return !this.hasVariant() && this.entityTag == null && this.bucketEntityTag == null;
    }

    public DyeColor getPatternColor() {
        Preconditions.checkState((boolean)this.hasVariant(), (Object)"This bucket doesn't have variant, check hasVariant first!");
        return CraftTropicalFish.getPatternColor(this.variant);
    }

    public void setPatternColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(color, this.getBodyColor(), this.getPattern());
    }

    public DyeColor getBodyColor() {
        Preconditions.checkState((boolean)this.hasVariant(), (Object)"This bucket doesn't have variant, check hasVariant first!");
        return CraftTropicalFish.getBodyColor(this.variant);
    }

    public void setBodyColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), color, this.getPattern());
    }

    public TropicalFish.Pattern getPattern() {
        Preconditions.checkState((boolean)this.hasVariant(), (Object)"This bucket doesn't have variant, check hasVariant first!");
        return CraftTropicalFish.getPattern(this.variant);
    }

    public void setPattern(TropicalFish.Pattern pattern) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), this.getBodyColor(), pattern);
    }

    public boolean hasVariant() {
        return this.variant != null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaTropicalFishBucket) {
            CraftMetaTropicalFishBucket other = (CraftMetaTropicalFishBucket)meta;
            return Objects.equals(this.variant, other.variant) && Objects.equals(this.entityTag, other.entityTag) && Objects.equals(this.bucketEntityTag, other.bucketEntityTag);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaTropicalFishBucket || this.isBucketEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasVariant()) {
            hash = 61 * hash + this.variant;
        }
        if (this.entityTag != null) {
            hash = 61 * hash + this.entityTag.hashCode();
        }
        if (this.bucketEntityTag != null) {
            hash = 61 * hash + this.bucketEntityTag.hashCode();
        }
        return original != hash ? CraftMetaTropicalFishBucket.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaTropicalFishBucket clone() {
        CraftMetaTropicalFishBucket clone = (CraftMetaTropicalFishBucket)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.l();
        }
        if (this.bucketEntityTag != null) {
            clone.bucketEntityTag = this.bucketEntityTag.l();
        }
        return clone;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasVariant()) {
            builder.put((Object)CraftMetaTropicalFishBucket.VARIANT.BUKKIT, (Object)this.variant);
        }
        return builder;
    }
}

