/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.configuration.ConfigSerializationUtil;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.tag.CraftBlockTag;
import org.bukkit.inventory.meta.components.ToolComponent;

@SerializableAs(value="Tool")
public final class CraftToolComponent
implements ToolComponent {
    private Tool handle;

    public CraftToolComponent(Tool tool) {
        this.handle = tool;
    }

    public CraftToolComponent(CraftToolComponent tool) {
        this.handle = tool.handle;
    }

    public CraftToolComponent(Map<String, Object> map) {
        Float speed = SerializableMeta.getObject(Float.class, map, "default-mining-speed", false);
        Integer damage = SerializableMeta.getObject(Integer.class, map, "damage-per-block", false);
        ImmutableList.Builder rules = ImmutableList.builder();
        Iterable rawRuleList = SerializableMeta.getObject(Iterable.class, map, "rules", true);
        if (rawRuleList != null) {
            for (Object obj : rawRuleList) {
                Preconditions.checkArgument((boolean)(obj instanceof ToolComponent.ToolRule), (String)"Object (%s) in rule list is not valid", obj.getClass());
                CraftToolRule rule = new CraftToolRule((ToolComponent.ToolRule)obj);
                if (rule.handle.a().b() <= 0) continue;
                rules.add((Object)rule);
            }
        }
        this.handle = new Tool(rules.build().stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), speed.floatValue(), damage, true);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("default-mining-speed", Float.valueOf(this.getDefaultMiningSpeed()));
        result.put("damage-per-block", this.getDamagePerBlock());
        result.put("rules", this.getRules());
        return result;
    }

    public Tool getHandle() {
        return this.handle;
    }

    public float getDefaultMiningSpeed() {
        return this.handle.b();
    }

    public void setDefaultMiningSpeed(float speed) {
        this.handle = new Tool(this.handle.a(), speed, this.handle.c(), this.handle.d());
    }

    public int getDamagePerBlock() {
        return this.handle.c();
    }

    public void setDamagePerBlock(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, was %d", (int)damage);
        this.handle = new Tool(this.handle.a(), this.handle.b(), damage, this.handle.d());
    }

    public List<ToolComponent.ToolRule> getRules() {
        return this.handle.a().stream().map(CraftToolRule::new).collect(Collectors.toList());
    }

    public void setRules(List<ToolComponent.ToolRule> rules) {
        Preconditions.checkArgument((rules != null ? 1 : 0) != 0, (Object)"rules must not be null");
        this.handle = new Tool(rules.stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), this.handle.b(), this.handle.c(), this.handle.d());
    }

    public ToolComponent.ToolRule addRule(Material block, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
        Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
        Holder.c<Block> nmsBlock = CraftBlockType.bukkitToMinecraft(block).p();
        return this.addRule(HolderSet.a(nmsBlock), speed, correctForDrops);
    }

    public ToolComponent.ToolRule addRule(Collection<Material> blocks, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
        ArrayList<Holder.c<Block>> nmsBlocks = new ArrayList<Holder.c<Block>>(blocks.size());
        for (Material material : blocks) {
            Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            nmsBlocks.add(CraftBlockType.bukkitToMinecraft(material).p());
        }
        return this.addRule(HolderSet.a(nmsBlocks), speed, correctForDrops);
    }

    public ToolComponent.ToolRule addRule(Tag<Material> tag, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((boolean)(tag instanceof CraftBlockTag), (Object)"tag must be a block tag");
        Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
        return this.addRule(((CraftBlockTag)tag).getHandle(), speed, correctForDrops);
    }

    private ToolComponent.ToolRule addRule(HolderSet<Block> blocks, Float speed, Boolean correctForDrops) {
        Tool.a rule = new Tool.a(blocks, Optional.ofNullable(speed), Optional.ofNullable(correctForDrops));
        ArrayList<Tool.a> rules = new ArrayList<Tool.a>(this.handle.a().size() + 1);
        rules.addAll(this.handle.a());
        rules.add(rule);
        this.handle = new Tool(rules, this.handle.b(), this.handle.c(), this.handle.d());
        return new CraftToolRule(rule);
    }

    public boolean removeRule(ToolComponent.ToolRule rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"rule must not be null");
        ArrayList<Tool.a> rules = new ArrayList<Tool.a>(this.handle.a());
        boolean removed = rules.remove(((CraftToolRule)rule).handle);
        this.handle = new Tool(rules, this.handle.b(), this.handle.c(), this.handle.d());
        return removed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.handle.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftToolComponent other = (CraftToolComponent)obj;
        return this.handle.equals(other.handle);
    }

    public String toString() {
        return "CraftToolComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="ToolRule")
    public static class CraftToolRule
    implements ToolComponent.ToolRule {
        private Tool.a handle;

        public CraftToolRule(Tool.a handle) {
            this.handle = handle;
        }

        public CraftToolRule(ToolComponent.ToolRule bukkit) {
            Tool.a toCopy = ((CraftToolRule)bukkit).handle;
            this.handle = new Tool.a(toCopy.a(), toCopy.b(), toCopy.c());
        }

        public CraftToolRule(Map<String, Object> map) {
            Float speed = SerializableMeta.getObject(Float.class, map, "speed", true);
            Boolean correct = SerializableMeta.getObject(Boolean.class, map, "correct-for-drops", true);
            HolderSet<Block> blocks = ConfigSerializationUtil.getHolderSet(SerializableMeta.getObject(Object.class, map, "blocks", false), Registries.i);
            this.handle = new Tool.a(blocks, Optional.ofNullable(speed), Optional.ofNullable(correct));
        }

        public Map<String, Object> serialize() {
            Boolean correct;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            ConfigSerializationUtil.setHolderSet(result, "blocks", this.handle.a());
            Float speed = this.getSpeed();
            if (speed != null) {
                result.put("speed", speed);
            }
            if ((correct = this.isCorrectForDrops()) != null) {
                result.put("correct-for-drops", correct);
            }
            return result;
        }

        public Tool.a getHandle() {
            return this.handle;
        }

        public Collection<Material> getBlocks() {
            return this.handle.a().a().map(Holder::a).map(CraftBlockType::minecraftToBukkit).collect(Collectors.toList());
        }

        public void setBlocks(Material block) {
            Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
            Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
            this.handle = new Tool.a(HolderSet.a(CraftBlockType.bukkitToMinecraft(block).p()), this.handle.b(), this.handle.c());
        }

        public void setBlocks(Collection<Material> blocks) {
            Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
            for (Material material : blocks) {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            }
            this.handle = new Tool.a(HolderSet.a(blocks.stream().map(CraftBlockType::bukkitToMinecraft).map(Block::p).collect(Collectors.toList())), this.handle.b(), this.handle.c());
        }

        public void setBlocks(Tag<Material> tag) {
            Preconditions.checkArgument((boolean)(tag instanceof CraftBlockTag), (Object)"tag must be a block tag");
            this.handle = new Tool.a(((CraftBlockTag)tag).getHandle(), this.handle.b(), this.handle.c());
        }

        public Float getSpeed() {
            return this.handle.b().orElse(null);
        }

        public void setSpeed(Float speed) {
            Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
            this.handle = new Tool.a(this.handle.a(), Optional.ofNullable(speed), this.handle.c());
        }

        public Boolean isCorrectForDrops() {
            return this.handle.c().orElse(null);
        }

        public void setCorrectForDrops(Boolean correct) {
            this.handle = new Tool.a(this.handle.a(), this.handle.b(), Optional.ofNullable(correct));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + this.handle.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftToolRule other = (CraftToolRule)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftToolRule{rule=" + String.valueOf(this.handle) + "}";
        }
    }
}

