/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.util;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.IInventory;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R7.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public abstract class CraftBlockInventoryConverter
implements CraftInventoryCreator.InventoryConverter {
    public abstract IInventory getBlockEntity();

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.getInventory(holder, type, this.getBlockEntity());
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
        IInventory blockEntity = this.getBlockEntity();
        if (blockEntity instanceof TileEntityLootable) {
            ((TileEntityLootable)blockEntity).e = PaperAdventure.asVanilla(title);
        }
        return this.getInventory(owner, type, blockEntity);
    }

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        IInventory blockEntity = this.getBlockEntity();
        if (blockEntity instanceof TileEntityLootable) {
            ((TileEntityLootable)blockEntity).e = CraftChatMessage.fromStringOrNull(title);
        }
        return this.getInventory(holder, type, blockEntity);
    }

    @Deprecated
    public Inventory getInventory(IInventory blockEntity) {
        return this.getInventory(null, null, blockEntity);
    }

    public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory blockEntity) {
        if (owner != null) {
            return new CraftInventoryCustom(owner, type, blockEntity);
        }
        return new CraftInventory(blockEntity);
    }

    public static class Crafter
    extends CraftBlockInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            return new CrafterBlockEntity(BlockPosition.c, Blocks.uP.m());
        }
    }

    public static class Smoker
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            return new TileEntitySmoker(BlockPosition.c, Blocks.oS.m());
        }
    }

    public static class Lectern
    extends CraftBlockInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            return new TileEntityLectern((BlockPosition)BlockPosition.c, (IBlockData)Blocks.oX.m()).e;
        }
    }

    public static class BlastFurnace
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            return new TileEntityBlastFurnace(BlockPosition.c, Blocks.oT.m());
        }
    }

    public static class Hopper
    extends CraftBlockInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            return new TileEntityHopper(BlockPosition.c, Blocks.hT.m());
        }
    }

    public static class Dropper
    extends CraftBlockInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            return new TileEntityDropper(BlockPosition.c, Blocks.hZ.m());
        }
    }

    public static class Dispenser
    extends CraftBlockInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            return new TileEntityDispenser(BlockPosition.c, Blocks.bb.m());
        }
    }

    public static class BrewingStand
    extends CraftBlockInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            return new TileEntityBrewingStand(BlockPosition.c, Blocks.gh.m());
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
            IInventory blockEntity = this.getBlockEntity();
            if (blockEntity instanceof TileEntityBrewingStand) {
                ((TileEntityContainer)((TileEntityBrewingStand)blockEntity)).e = PaperAdventure.asVanilla(title);
            }
            return this.getInventory(owner, type, blockEntity);
        }

        @Override
        public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
            IInventory blockEntity = this.getBlockEntity();
            if (blockEntity instanceof TileEntityBrewingStand) {
                ((TileEntityContainer)((TileEntityBrewingStand)blockEntity)).e = CraftChatMessage.fromStringOrNull(title);
            }
            return this.getInventory(holder, type, blockEntity);
        }

        @Override
        public Inventory getInventory(IInventory blockEntity) {
            return this.getInventory(null, null, blockEntity);
        }

        @Override
        public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory blockEntity) {
            if (owner != null) {
                return new CraftInventoryCustom(owner, type, blockEntity);
            }
            return new CraftInventoryBrewer(blockEntity);
        }
    }

    public static abstract class AbstractFurnaceInventoryConverter
    extends CraftBlockInventoryConverter {
        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
            IInventory blockEntity = this.getBlockEntity();
            ((TileEntityContainer)((TileEntityFurnace)blockEntity)).e = PaperAdventure.asVanilla(title);
            return this.getInventory(owner, type, blockEntity);
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
            IInventory blockEntity = this.getBlockEntity();
            ((TileEntityContainer)((TileEntityFurnace)blockEntity)).e = CraftChatMessage.fromStringOrNull(title);
            return this.getInventory(owner, type, blockEntity);
        }

        @Override
        public Inventory getInventory(IInventory blockEntity) {
            return this.getInventory(null, null, blockEntity);
        }

        @Override
        public Inventory getInventory(InventoryHolder owner, InventoryType type, IInventory blockEntity) {
            if (owner != null) {
                return new CraftInventoryCustom(owner, type, blockEntity);
            }
            return new CraftInventoryFurnace((TileEntityFurnace)blockEntity);
        }
    }

    public static class Furnace
    extends AbstractFurnaceInventoryConverter {
        @Override
        public IInventory getBlockEntity() {
            TileEntityFurnaceFurnace furnace = new TileEntityFurnaceFurnace(BlockPosition.c, Blocks.da.m());
            return furnace;
        }
    }
}

