/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.view;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.view.EnchantmentView;
import org.jetbrains.annotations.NotNull;

public class CraftEnchantmentView
extends CraftInventoryView<ContainerEnchantTable, EnchantingInventory>
implements EnchantmentView {
    public CraftEnchantmentView(HumanEntity player, EnchantingInventory viewing, ContainerEnchantTable container) {
        super(player, viewing, container);
    }

    public int getEnchantmentSeed() {
        return ((ContainerEnchantTable)this.container).m();
    }

    public void setEnchantmentSeed(int seed) {
        ((ContainerEnchantTable)this.container).setEnchantmentSeed(seed);
    }

    @NotNull
    public EnchantmentOffer[] getOffers() {
        Registry<Holder<Enchantment>> registry = CraftRegistry.getMinecraftRegistry().f(Registries.bf).t();
        EnchantmentOffer[] offers = new EnchantmentOffer[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            org.bukkit.enchantments.Enchantment enchantment = ((ContainerEnchantTable)this.container).n[i2] >= 0 ? CraftEnchantment.minecraftHolderToBukkit(registry.a(((ContainerEnchantTable)this.container).n[i2])) : null;
            offers[i2] = enchantment != null ? new EnchantmentOffer(enchantment, ((ContainerEnchantTable)this.container).o[i2], ((ContainerEnchantTable)this.container).m[i2]) : null;
        }
        return offers;
    }

    public void setOffers(@NotNull EnchantmentOffer[] offers) {
        Preconditions.checkArgument((offers.length == 3 ? 1 : 0) != 0, (Object)"There must be 3 offers given");
        Registry<Holder<Enchantment>> registry = CraftRegistry.getMinecraftRegistry().f(Registries.bf).t();
        for (int i2 = 0; i2 < offers.length; ++i2) {
            EnchantmentOffer offer = offers[i2];
            if (offer == null) {
                ((ContainerEnchantTable)this.container).n[i2] = -1;
                ((ContainerEnchantTable)this.container).o[i2] = -1;
                ((ContainerEnchantTable)this.container).m[i2] = 0;
                continue;
            }
            ((ContainerEnchantTable)this.container).n[i2] = registry.c(CraftEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
            ((ContainerEnchantTable)this.container).o[i2] = offer.getEnchantmentLevel();
            ((ContainerEnchantTable)this.container).m[i2] = offer.getCost();
        }
    }
}

