/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.view.builder;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.trading.IMerchant;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R7.inventory.view.builder.CraftAbstractInventoryViewBuilder;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;
import org.jspecify.annotations.Nullable;

public class CraftMerchantInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractInventoryViewBuilder<V>
implements MerchantInventoryViewBuilder<V> {
    private @Nullable IMerchant merchant;

    public CraftMerchantInventoryViewBuilder(Containers<?> handle) {
        super(handle);
    }

    @Override
    public MerchantInventoryViewBuilder<V> title(@Nullable Component title) {
        return (MerchantInventoryViewBuilder)super.title(title);
    }

    public MerchantInventoryViewBuilder<V> merchant(Merchant merchant) {
        this.merchant = ((CraftMerchant)merchant).getMerchant();
        return this;
    }

    public MerchantInventoryViewBuilder<V> checkReachable(boolean checkReachable) {
        this.checkReachable = checkReachable;
        return this;
    }

    @Override
    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof EntityPlayer), (Object)"The given player must be an ServerPlayer");
        EntityPlayer serverPlayer = (EntityPlayer)craftHuman.getHandle();
        if (this.merchant == null) {
            this.merchant = this.title == null ? new CraftMerchantCustom().getMerchant() : new CraftMerchantCustom(this.title).getMerchant();
        }
        ContainerMerchant container = new ContainerMerchant(serverPlayer.nextContainerCounter(), serverPlayer.gK(), this.merchant);
        container.checkReachable = this.checkReachable;
        this.setDefaultTitle(this.merchant);
        container.setTitle(this.title != null ? PaperAdventure.asVanilla(this.title) : this.defaultTitle);
        return (V)container.getBukkitView();
    }

    private void setDefaultTitle(IMerchant merchant) {
        if (merchant instanceof EntityVillagerAbstract) {
            EntityVillagerAbstract villager = (EntityVillagerAbstract)merchant;
            this.defaultTitle = villager.R_();
        } else if (merchant instanceof CraftMerchantCustom.MinecraftMerchant) {
            CraftMerchantCustom.MinecraftMerchant custom = (CraftMerchantCustom.MinecraftMerchant)merchant;
            this.defaultTitle = custom.getScoreboardDisplayName();
        } else {
            throw new IllegalStateException("Provided merchant during MenuType creation can not find a default title! This is a bug!");
        }
    }

    @Override
    protected Container buildContainer(EntityPlayer player) {
        throw new UnsupportedOperationException("buildContainer is not supported for CraftMerchantInventoryViewBuilder");
    }

    public MerchantInventoryViewBuilder<V> copy() {
        CraftMerchantInventoryViewBuilder<V> copy = new CraftMerchantInventoryViewBuilder<V>(this.handle);
        copy.checkReachable = this.checkReachable;
        copy.merchant = this.merchant;
        copy.title = this.title;
        return copy;
    }
}

