/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.scoreboard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.RenderType;

public final class CraftCriteria
implements Criteria {
    private static final Map<String, CraftCriteria> DEFAULTS;
    private static final CraftCriteria DUMMY;
    final IScoreboardCriteria criteria;
    final String name;

    private CraftCriteria(String name) {
        this.name = name;
        this.criteria = CraftCriteria.DUMMY.criteria;
    }

    private CraftCriteria(IScoreboardCriteria criteria) {
        this.criteria = criteria;
        this.name = criteria.d();
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.criteria.e();
    }

    public RenderType getDefaultRenderType() {
        return RenderType.values()[this.criteria.f().ordinal()];
    }

    public static CraftCriteria getFromNMS(IScoreboardCriteria criteria) {
        return Objects.requireNonNullElseGet(DEFAULTS.get(criteria.d()), () -> new CraftCriteria(criteria));
    }

    public static CraftCriteria getFromNMS(ScoreboardObjective objective) {
        return CraftCriteria.getFromNMS(objective.d());
    }

    public static CraftCriteria getFromBukkit(String name) {
        CraftCriteria criteria = DEFAULTS.get(name);
        if (criteria != null) {
            return criteria;
        }
        return IScoreboardCriteria.a(name).map(CraftCriteria::new).orElseGet(() -> new CraftCriteria(name));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftCriteria)) {
            return false;
        }
        CraftCriteria craftCriteria = (CraftCriteria)obj;
        return craftCriteria.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode() ^ CraftCriteria.class.hashCode();
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (Map.Entry<String, IScoreboardCriteria> entry : IScoreboardCriteria.p.entrySet()) {
            String name = entry.getKey();
            IScoreboardCriteria criteria = entry.getValue();
            defaults.put((Object)name, (Object)new CraftCriteria(criteria));
        }
        DEFAULTS = defaults.build();
        DUMMY = DEFAULTS.get(IScoreboardCriteria.c.d());
    }
}

