/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.scoreboard;

import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R7.util.WeakCollection;
import org.bukkit.scoreboard.ScoreboardManager;
import org.spigotmc.AsyncCatcher;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer server, Scoreboard scoreboard) {
        this.mainScoreboard = new CraftScoreboard(scoreboard);
        this.mainScoreboard.registeredGlobally = true;
        this.server = server;
        this.scoreboards.add(this.mainScoreboard);
    }

    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    public CraftScoreboard getNewScoreboard() {
        AsyncCatcher.catchOp("scoreboard creation");
        CraftScoreboard scoreboard = new CraftScoreboard(new ScoreboardServer(this.server));
        if (GlobalConfiguration.get().scoreboards.trackPluginScoreboards) {
            scoreboard.registeredGlobally = true;
            this.scoreboards.add(scoreboard);
        }
        return scoreboard;
    }

    public void registerScoreboardForVanilla(CraftScoreboard scoreboard) {
        AsyncCatcher.catchOp("scoreboard registration");
        this.scoreboards.add(scoreboard);
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = player.getScoreboardOverride();
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, CraftScoreboard scoreboard) {
        Scoreboard newBoard;
        Scoreboard oldBoard = this.getPlayerBoard(player).getHandle();
        if (oldBoard == (newBoard = scoreboard.getHandle())) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            player.setScoreboardOverride(null);
        } else {
            player.setScoreboardOverride(scoreboard);
        }
        EntityPlayer serverPlayer = player.getHandle();
        HashSet<ScoreboardObjective> removed = new HashSet<ScoreboardObjective>();
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            ScoreboardObjective objective = oldBoard.a(displaySlot);
            if (objective == null || removed.contains(objective)) continue;
            serverPlayer.g.b(new PacketPlayOutScoreboardObjective(objective, 1));
            removed.add(objective);
        }
        for (ScoreboardTeam team : oldBoard.f()) {
            serverPlayer.g.b(PacketPlayOutScoreboardTeam.a(team));
        }
        this.server.aj().a((ScoreboardServer)newBoard, player.getHandle());
    }

    public void removePlayer(CraftPlayer player) {
        player.setScoreboardOverride(null);
    }

    public void forAllObjectives(IScoreboardCriteria criteria, ScoreHolder holder, Consumer<ScoreAccess> consumer) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            scoreboard.getHandle().a(criteria, holder, consumer);
        }
    }
}

