/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.spawner;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.spawner.Spawner;
import org.slf4j.Logger;

public interface PaperSharedSpawnerLogic
extends Spawner {
    public static final Logger LOGGER = LogUtils.getLogger();

    public MobSpawnerAbstract getSpawner();

    public World getInternalWorld();

    public IRegistryCustom getRegistryAccess();

    public BlockPosition getInternalPosition();

    default public boolean isActivated() {
        return this.getSpawner().c(this.getInternalWorld(), this.getInternalPosition());
    }

    default public void resetTimer() {
        this.getSpawner().d(this.getInternalWorld(), this.getInternalPosition());
    }

    default public void setNextSpawnData(MobSpawnerData spawnData) {
        this.getSpawner().a(this.getInternalWorld(), this.getInternalPosition(), spawnData);
    }

    default public void setSpawnedItem(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null && !itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"spawners cannot spawn air");
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy(itemStack);
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(() -> this.getSpawner().toString(), LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, this.getInternalWorld().J_());
            tagValueOutput.a("id", BuiltInRegistries.g.b(EntityTypes.av).toString());
            tagValueOutput.a("Item", net.minecraft.world.item.ItemStack.b, item);
            this.setNextSpawnData(new MobSpawnerData(tagValueOutput.b(), Optional.empty(), Optional.ofNullable(this.getSpawner().m).flatMap(MobSpawnerData::f)));
        }
    }
}

