/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.util;

import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;

public final class CraftLocation {
    private CraftLocation() {
    }

    public static Location toBukkit(Vec3D pos) {
        return CraftLocation.toBukkit(pos, (World)null);
    }

    public static Location toBukkit(Vec3D pos, World world) {
        return CraftLocation.toBukkit(pos, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(Vec3D pos, World world, float yaw, float pitch) {
        return new Location(world, pos.a(), pos.b(), pos.c(), yaw, pitch);
    }

    public static Location toBukkit(Vec3D pos, net.minecraft.world.level.World level) {
        return CraftLocation.toBukkit(pos, (World)level.getWorld());
    }

    public static Location toBukkit(Vec3D pos, net.minecraft.world.level.World level, float yaw, float pitch) {
        return CraftLocation.toBukkit(pos, (World)level.getWorld(), yaw, pitch);
    }

    public static Location toBukkit(BaseBlockPosition pos) {
        return CraftLocation.toBukkit(pos, (World)null);
    }

    public static Location toBukkit(BaseBlockPosition pos, World world) {
        return CraftLocation.toBukkit(pos, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(BaseBlockPosition pos, World world, float yaw, float pitch) {
        return new Location(world, (double)pos.u(), (double)pos.v(), (double)pos.w(), yaw, pitch);
    }

    public static Location toBukkit(BaseBlockPosition pos, net.minecraft.world.level.World level) {
        return CraftLocation.toBukkit(pos, (World)level.getWorld());
    }

    public static Location toBukkit(BaseBlockPosition pos, net.minecraft.world.level.World level, float yaw, float pitch) {
        return CraftLocation.toBukkit(pos, (World)level.getWorld(), yaw, pitch);
    }

    public static Location toBukkit(PathPoint point, net.minecraft.world.level.World level) {
        return new Location((World)level.getWorld(), (double)point.a, (double)point.b, (double)point.c);
    }

    public static BlockPosition toBlockPosition(Location loc) {
        return new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static GlobalPos toGlobalPos(Location loc) {
        return GlobalPos.a(((CraftWorld)loc.getWorld()).getHandle().aq(), CraftLocation.toBlockPosition(loc));
    }

    public static Location fromGlobalPos(GlobalPos globalPos) {
        return CraftLocation.toBukkit((BaseBlockPosition)globalPos.b(), (net.minecraft.world.level.World)MinecraftServer.getServer().a(globalPos.a()));
    }

    public static Vec3D toVec3(Location loc) {
        return new Vec3D(loc.getX(), loc.getY(), loc.getZ());
    }
}

