/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.util;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.destroystokyo.paper.PaperVersionFetcher;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.AdventureCodecs;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.attribute.UnmodifiableAttributeMap;
import io.papermc.paper.entity.EntitySerializationFlag;
import io.papermc.paper.inventory.tooltip.TooltipContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.PaperLifecycleEventManager;
import io.papermc.paper.pluginremap.reflect.ReflectionRemapper;
import io.papermc.paper.registry.RegistryKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.arguments.item.ArgumentParserItemStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.damage.CraftDamageSourceBuilder;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.legacy.CraftLegacy;
import org.bukkit.craftbukkit.v1_21_R7.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R7.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R7.util.Commodore;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class CraftMagicNumbers
implements UnsafeValues {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CraftMagicNumbers INSTANCE = new CraftMagicNumbers();
    public static final boolean DISABLE_OLD_API_SUPPORT = Boolean.getBoolean("paper.disableOldApiSupport");
    private final Commodore commodore = new Commodore();
    private static final Map<Block, Material> BLOCK_MATERIAL = new HashMap<Block, Material>();
    private static final Map<Item, Material> ITEM_MATERIAL = new HashMap<Item, Material>();
    private static final Map<Material, Item> MATERIAL_ITEM = new HashMap<Material, Item>();
    private static final Map<Material, Block> MATERIAL_BLOCK = new HashMap<Material, Block>();
    private static final MojangsonParser<NBTBase> SNBT_REGISTRY_UNAWARE_PARSER;

    private CraftMagicNumbers() {
    }

    public ComponentFlattener componentFlattener() {
        return PaperAdventure.FLATTENER;
    }

    public GsonComponentSerializer colorDownsamplingGsonComponentSerializer() {
        return GsonComponentSerializer.colorDownsamplingGson();
    }

    public GsonComponentSerializer gsonComponentSerializer() {
        return GsonComponentSerializer.gson();
    }

    public PlainComponentSerializer plainComponentSerializer() {
        return PaperAdventure.PLAIN;
    }

    public PlainTextComponentSerializer plainTextSerializer() {
        return PlainTextComponentSerializer.plainText();
    }

    public LegacyComponentSerializer legacyComponentSerializer() {
        return LegacyComponentSerializer.legacySection();
    }

    public Component resolveWithContext(Component component, CommandSender context, Entity scoreboardSubject, boolean bypassPermissions) throws IOException {
        return PaperAdventure.resolveWithContext(component, context, scoreboardSubject, bypassPermissions);
    }

    public static IBlockData getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static IBlockData getBlock(Material material, byte data) {
        return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
    }

    public static MaterialData getMaterial(IBlockData data) {
        return CraftLegacy.toLegacy(CraftMagicNumbers.getMaterial(data.b())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static Item getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(Item item) {
        return CraftLegacy.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    public static Material getMaterial(Block block) {
        return BLOCK_MATERIAL.get(block);
    }

    public static Material getMaterial(Item item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static Item getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_ITEM.get(material);
    }

    public static Block getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_BLOCK.get(material);
    }

    public static byte toLegacyData(IBlockData data) {
        return CraftLegacy.toLegacyData(data);
    }

    public Commodore getCommodore() {
        return this.commodore;
    }

    public Material toLegacy(Material material) {
        return CraftLegacy.toLegacy(material);
    }

    public Material fromLegacy(Material material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacy.fromLegacy(material, itemPriority);
    }

    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    public Material getMaterial(String material, int version) {
        Dynamic converted;
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial((String)material);
        }
        Dynamic<NBTTagString> name = new Dynamic<NBTTagString>(DynamicOpsNBT.a, NBTTagString.a("minecraft:" + material.toLowerCase(Locale.ROOT)));
        if (name.equals((Object)(converted = DataConverterRegistry.a().update(DataConverterTypes.J, name, version, this.getDataVersion())))) {
            converted = DataConverterRegistry.a().update(DataConverterTypes.I, name, version, this.getDataVersion());
        }
        return Material.matchMaterial((String)converted.asString(""));
    }

    @Deprecated(forRemoval=true, since="1.21.6")
    public String getMappingsVersion() {
        throw new UnsupportedOperationException("Use ServerBuildInfo#minecraftVersionId instead.");
    }

    public int getDataVersion() {
        return SharedConstants.b().a().b();
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.b(new ArgumentParserItemStack(CommandDispatcher.a(CraftRegistry.getMinecraftRegistry())).a(new StringReader(arguments)).b());
        }
        catch (CommandSyntaxException ex) {
            LogUtils.getClassLogger().error("Exception modifying ItemStack", new Throwable(ex));
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    private static File getBukkitDataPackFolder() {
        return new File(MinecraftServer.getServer().a(SavedFile.j).toFile(), "bukkit");
    }

    public org.bukkit.advancement.Advancement loadAdvancement(NamespacedKey key, String advancement) {
        Preconditions.checkArgument((Bukkit.getAdvancement((NamespacedKey)key) == null ? 1 : 0) != 0, (String)"Advancement %s already exists", (Object)key);
        MinecraftKey resourceKey = CraftNamespacedKey.toMinecraft(key);
        JsonElement jsonelement = JsonParser.parseString((String)advancement);
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().a(JsonOps.INSTANCE);
        Advancement nms = (Advancement)Advancement.a.parse(ops, (Object)jsonelement).getOrThrow(JsonParseException::new);
        if (nms != null) {
            org.bukkit.advancement.Advancement bukkit;
            AdvancementNode root;
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            mapBuilder.putAll(MinecraftServer.getServer().aB().b);
            AdvancementHolder holder = new AdvancementHolder(resourceKey, nms);
            mapBuilder.put((Object)resourceKey, (Object)holder);
            MinecraftServer.getServer().aB().b = mapBuilder.build();
            AdvancementTree tree = MinecraftServer.getServer().aB().a();
            tree.a(List.of(holder));
            AdvancementNode node = tree.a(resourceKey);
            if (node != null && (root = node.d()).b().b().c().isPresent()) {
                TreeNodePosition.a(root);
            }
            if ((bukkit = Bukkit.getAdvancement((NamespacedKey)key)) != null) {
                File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + String.valueOf(key), ex);
                }
                MinecraftServer.getServer().aj().t().forEach(player -> {
                    player.U().a(MinecraftServer.getServer().aB());
                    player.U().a((EntityPlayer)player, false);
                });
                return bukkit;
            }
        }
        return null;
    }

    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    public void checkSupported(PluginDescriptionFile descriptionFile) throws InvalidPluginException {
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(descriptionFile.getAPIVersion());
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        if (toCheck.isNewerThan(ApiVersion.CURRENT)) {
            throw new InvalidPluginException("Unsupported API version " + descriptionFile.getAPIVersion());
        }
        if (toCheck.isOlderThan(minimumVersion)) {
            throw new InvalidPluginException("Plugin API version " + descriptionFile.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
        }
        if (!DISABLE_OLD_API_SUPPORT && toCheck.isOlderThan(ApiVersion.FLATTENING)) {
            CraftLegacy.init();
        }
        if (toCheck == ApiVersion.NONE) {
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + descriptionFile.getFullName() + " does not specify an api-version.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        if (DISABLE_OLD_API_SUPPORT) {
            return ReflectionRemapper.processClass(clazz);
        }
        try {
            clazz = this.commodore.convert(clazz, pdf.getName(), ApiVersion.getOrCreateVersion(pdf.getAPIVersion()), ((CraftServer)Bukkit.getServer()).activeCompatibilities);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex);
        }
        return clazz;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material material, EquipmentSlot slot) {
        ItemType item = material.asItemType();
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)(String.valueOf(material) + " is not an item and does not have default attributes"));
        return item.getDefaultAttributeModifiers(slot);
    }

    public CreativeCategory getCreativeCategory(Material material) {
        return material.getCreativeCategory();
    }

    public String getBlockTranslationKey(Material material) {
        return material.getBlockTranslationKey();
    }

    public String getItemTranslationKey(Material material) {
        return material.getItemTranslationKey();
    }

    public String getTranslationKey(EntityType entityType) {
        Preconditions.checkArgument((entityType.getName() != null ? 1 : 0) != 0, (String)"Invalid name of EntityType %s for translation key", (Object)entityType);
        return EntityTypes.a(entityType.getName()).map(EntityTypes::g).orElseThrow();
    }

    public String getTranslationKey(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        return nmsItemStack.h().j();
    }

    public boolean isSupportedApiVersion(String apiVersion) {
        if (apiVersion == null) {
            return false;
        }
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(apiVersion);
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        return !toCheck.isNewerThan(ApiVersion.CURRENT) && !toCheck.isOlderThan(minimumVersion);
    }

    public String getTranslationKey(Attribute attribute) {
        return attribute.getTranslationKey();
    }

    public PotionType.InternalPotionData getInternalPotionData(NamespacedKey namespacedKey) {
        PotionRegistry potionRegistry = CraftRegistry.getMinecraftRegistry(Registries.am).b(CraftNamespacedKey.toMinecraft(namespacedKey)).orElseThrow();
        return new CraftPotionType(namespacedKey, potionRegistry);
    }

    public DamageSource.Builder createDamageSourceBuilder(DamageType damageType) {
        return new CraftDamageSourceBuilder(damageType);
    }

    public String get(Class<?> aClass, String s2) {
        if (aClass == Enchantment.class) {
            return FieldRename.convertEnchantmentName(ApiVersion.CURRENT, s2);
        }
        return s2;
    }

    public <B extends Keyed> B get(RegistryKey<B> registry, NamespacedKey namespacedKey) {
        return CraftRegistry.get(registry, namespacedKey, ApiVersion.CURRENT);
    }

    public VersionFetcher getVersionFetcher() {
        return new PaperVersionFetcher();
    }

    public byte[] serializeItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"null cannot be serialized");
        Preconditions.checkArgument((!item.isEmpty() ? 1 : 0) != 0, (Object)"Empty itemstack cannot be serialized");
        return this.serializeNbtToBytes((NBTTagCompound)net.minecraft.world.item.ItemStack.b.encodeStart(MinecraftServer.getServer().bc().a(DynamicOpsNBT.a), (Object)CraftItemStack.unwrap(item)).getOrThrow());
    }

    public ItemStack deserializeItem(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        NBTTagCompound compound = this.deserializeNbtFromBytes(data);
        return this.deserializeItem(compound);
    }

    private ItemStack deserializeItem(NBTTagCompound compound) {
        int dataVersion = compound.b("DataVersion", 0);
        compound = PlatformHooks.get().convertNBT(DataConverterTypes.x, DataConverterRegistry.a(), compound, dataVersion, this.getDataVersion());
        if (compound.b("id", "minecraft:air").equals("minecraft:air")) {
            return CraftItemStack.asCraftMirror(net.minecraft.world.item.ItemStack.l);
        }
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.b.parse(CraftRegistry.getMinecraftRegistry().a(DynamicOpsNBT.a), (Object)compound).getOrThrow());
    }

    @NotNull
    public Map<String, Object> serializeStack(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return Map.of("id", "minecraft:air", "DataVersion", this.getDataVersion(), "schema_version", 1);
        }
        NBTTagCompound tag = (NBTTagCompound)net.minecraft.world.item.ItemStack.b.encodeStart(CraftRegistry.getMinecraftRegistry().a(DynamicOpsNBT.a), (Object)CraftItemStack.asNMSCopy(itemStack)).getOrThrow();
        GameProfileSerializer.e(tag);
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        tag.s_().get().a((key, value) -> {
            switch (key) {
                case "id": {
                    ret.put("id", value.p_().get());
                    break;
                }
                case "count": {
                    ret.put("count", value.r().get());
                    break;
                }
                case "components": {
                    LinkedHashMap components = new LinkedHashMap();
                    value.s_().ifPresent(compoundTag -> compoundTag.a((componentKey, componentTag) -> {
                        String serializedComponent = componentTag.toString();
                        components.put(componentKey, serializedComponent);
                    }));
                    ret.put("components", components);
                    break;
                }
                case "DataVersion": {
                    ret.put("DataVersion", value.r().get());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + key);
                }
            }
        });
        ret.put("schema_version", 1);
        return ret;
    }

    @NotNull
    public ItemStack deserializeStack(@NotNull Map<String, Object> args) {
        int n2;
        Object object = args.getOrDefault("schema_version", 1);
        if (object instanceof Number) {
            Number val = (Number)object;
            n2 = val.intValue();
        } else {
            n2 = -1;
        }
        int version = n2;
        NBTTagCompound tag = new NBTTagCompound();
        args.forEach((key, value) -> {
            switch (key) {
                case "id": {
                    tag.a("id", (String)value);
                    break;
                }
                case "count": {
                    tag.a("count", ((Number)value).intValue());
                    break;
                }
                case "components": {
                    if (version == 1) {
                        HashMap<String, String> componentMap;
                        if (value instanceof Map) {
                            componentMap = (HashMap<String, String>)value;
                        } else if (value instanceof MemorySection) {
                            MemorySection memory = (MemorySection)value;
                            componentMap = new HashMap<String, String>();
                            for (String memoryKey : memory.getKeys(false)) {
                                componentMap.put(memoryKey, memory.getString(memoryKey));
                            }
                        } else {
                            throw new IllegalArgumentException("components must be a Map");
                        }
                        NBTTagCompound componentsTag = new NBTTagCompound();
                        componentMap.forEach((componentKey, componentString) -> {
                            NBTBase componentTag;
                            try {
                                componentTag = SNBT_REGISTRY_UNAWARE_PARSER.b((String)componentString);
                            }
                            catch (CommandSyntaxException e2) {
                                throw new RuntimeException("Error parsing item stack data components", e2);
                            }
                            componentsTag.a((String)componentKey, componentTag);
                        });
                        tag.a("components", componentsTag);
                        break;
                    }
                    throw new IllegalStateException("Unexpected version: " + version);
                }
                case "DataVersion": {
                    tag.a("DataVersion", ((Number)value).intValue());
                    break;
                }
                case "==": 
                case "schema_version": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + key);
                }
            }
        });
        return this.deserializeItem(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject serializeItemAsJson(ItemStack itemStack) {
        JsonObject item;
        Preconditions.checkNotNull((Object)itemStack, (Object)"Cannot serialize empty ItemStack");
        Preconditions.checkArgument((!itemStack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot serialize empty ItemStack");
        IRegistryCustom.Dimension reg = MinecraftServer.getServer().bc();
        RegistryOps ops = reg.a(JsonOps.INSTANCE);
        CustomData.SERIALIZE_CUSTOM_AS_SNBT.set(true);
        try {
            item = ((JsonElement)net.minecraft.world.item.ItemStack.b.encodeStart(ops, (Object)CraftItemStack.unwrap(itemStack)).getOrThrow()).getAsJsonObject();
        }
        finally {
            CustomData.SERIALIZE_CUSTOM_AS_SNBT.set(false);
        }
        item.addProperty("DataVersion", (Number)this.getDataVersion());
        return item;
    }

    public ItemStack deserializeItemFromJson(JsonObject data) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        int dataVersion = data.get("DataVersion").getAsInt();
        int currentVersion = INSTANCE.getDataVersion();
        data = (JsonObject)MinecraftServer.getServer().M.update(DataConverterTypes.x, new Dynamic<JsonObject>((DynamicOps<JsonObject>)JsonOps.INSTANCE, data), dataVersion, currentVersion).getValue();
        RegistryOps ops = MinecraftServer.getServer().bc().a(JsonOps.INSTANCE);
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.b.parse(ops, (Object)data).getOrThrow(IllegalArgumentException::new));
    }

    public byte[] serializeEntity(Entity entity, EntitySerializationFlag ... serializationFlags) {
        Preconditions.checkNotNull((Object)entity, (Object)"null cannot be serialized");
        Preconditions.checkArgument((boolean)(entity instanceof CraftEntity), (Object)"Only CraftEntities can be serialized");
        Set<EntitySerializationFlag> flags = Set.of(serializationFlags);
        boolean serializePassengers = flags.contains(EntitySerializationFlag.PASSENGERS);
        boolean forceSerialization = flags.contains(EntitySerializationFlag.FORCE);
        boolean allowPlayerSerialization = flags.contains(EntitySerializationFlag.PLAYER);
        boolean allowMiscSerialization = flags.contains(EntitySerializationFlag.MISC);
        boolean includeNonSaveable = allowPlayerSerialization || allowMiscSerialization;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        (serializePassengers ? nmsEntity.dp() : Stream.of(nmsEntity)).forEach(e2 -> {
            Preconditions.checkArgument((e2.getBukkitEntity().isValid() && e2.getBukkitEntity().isPersistent() || forceSerialization ? 1 : 0) != 0, (String)"Cannot serialize invalid or non-persistent entity %s(%s) without the FORCE flag", (Object)e2.ay().i(), (Object)e2.cZ());
            if (e2 instanceof EntityHuman) {
                Preconditions.checkArgument((boolean)allowPlayerSerialization, (String)"Cannot serialize player(%s) without the PLAYER flag", (Object)e2.cZ());
            } else {
                Preconditions.checkArgument((nmsEntity.ay().b() || allowMiscSerialization ? 1 : 0) != 0, (String)"Cannot serialize misc non-saveable entity %s(%s) without the MISC flag", (Object)e2.ay().i(), (Object)e2.cZ());
            }
        });
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "serialiseEntity@" + String.valueOf(entity.getUniqueId()), LOGGER);){
            TagValueOutput output = TagValueOutput.a(problemReporter, nmsEntity.eo());
            if (serializePassengers) {
                if (!nmsEntity.saveAsPassenger(output, true, includeNonSaveable, forceSerialization)) {
                    throw new IllegalArgumentException("Couldn't serialize entity");
                }
            } else {
                ArrayList<net.minecraft.world.entity.Entity> pass = new ArrayList<net.minecraft.world.entity.Entity>(nmsEntity.dn());
                nmsEntity.aS = ImmutableList.of();
                boolean serialized = nmsEntity.saveAsPassenger(output, true, includeNonSaveable, forceSerialization);
                nmsEntity.aS = ImmutableList.copyOf(pass);
                if (!serialized) {
                    throw new IllegalArgumentException("Couldn't serialize entity");
                }
            }
            byte[] byArray = this.serializeNbtToBytes(output.b());
            return byArray;
        }
    }

    public Entity deserializeEntity(byte[] data, World world, boolean preserveUUID, boolean preservePassengers) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"Cannot deserialize empty data");
        NBTTagCompound compound = this.deserializeNbtFromBytes(data);
        int dataVersion = compound.b("DataVersion", 0);
        compound = PlatformHooks.get().convertNBT(DataConverterTypes.H, MinecraftServer.getServer().M, compound, dataVersion, this.getDataVersion());
        if (!preservePassengers) {
            compound.r("Passengers");
        }
        net.minecraft.world.entity.Entity nmsEntity = this.deserializeEntity(compound, ((CraftWorld)world).getHandle(), preserveUUID);
        return nmsEntity.getBukkitEntity();
    }

    private net.minecraft.world.entity.Entity deserializeEntity(NBTTagCompound compound, WorldServer world, boolean preserveUUID) {
        net.minecraft.world.entity.Entity nmsEntity;
        if (!preserveUUID) {
            compound.r("UUID");
        }
        try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "deserialiseEntity", LOGGER);){
            nmsEntity = EntityTypes.a(TagValueInput.a((ProblemReporter)problemReporter, (HolderLookup.a)world.J_(), compound), (net.minecraft.world.level.World)world, EntitySpawnReason.r).orElseThrow(() -> new IllegalArgumentException("An ID was not found for the data. Did you downgrade?"));
        }
        compound.o("Passengers").ifPresent(passengers -> {
            for (NBTBase tag : passengers) {
                if (!(tag instanceof NBTTagCompound)) continue;
                NBTTagCompound serializedPassenger = (NBTTagCompound)tag;
                net.minecraft.world.entity.Entity passengerEntity = this.deserializeEntity(serializedPassenger, world, preserveUUID);
                passengerEntity.a(nmsEntity, true, true);
            }
        });
        return nmsEntity;
    }

    private byte[] serializeNbtToBytes(NBTTagCompound compound) {
        compound.a("DataVersion", this.getDataVersion());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a(compound, outputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return outputStream.toByteArray();
    }

    private NBTTagCompound deserializeNbtFromBytes(byte[] data) {
        NBTTagCompound compound;
        try {
            compound = NBTCompressedStreamTools.a(new ByteArrayInputStream(data), NBTReadLimiter.c());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        int dataVersion = compound.b("DataVersion", 0);
        Preconditions.checkArgument((dataVersion <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        return compound;
    }

    public int nextEntityId() {
        return net.minecraft.world.entity.Entity.nextEntityId();
    }

    public String getMainLevelName() {
        return ((DedicatedServer)MinecraftServer.getServer()).a().o;
    }

    public int getProtocolVersion() {
        return SharedConstants.b().d();
    }

    public boolean isValidRepairItemStack(ItemStack itemToBeRepaired, ItemStack repairMaterial) {
        if (!itemToBeRepaired.getType().isItem() || !repairMaterial.getType().isItem()) {
            return false;
        }
        return CraftItemStack.unwrap(itemToBeRepaired).c(CraftItemStack.unwrap(repairMaterial));
    }

    public boolean hasDefaultEntityAttributes(NamespacedKey entityKey) {
        return AttributeDefaults.b(BuiltInRegistries.g.a(CraftNamespacedKey.toMinecraft(entityKey)));
    }

    public Attributable getDefaultEntityAttributes(NamespacedKey entityKey) {
        Preconditions.checkArgument((boolean)this.hasDefaultEntityAttributes(entityKey), (Object)(String.valueOf(entityKey) + " doesn't have default attributes"));
        AttributeProvider supplier = AttributeDefaults.a(BuiltInRegistries.g.a(CraftNamespacedKey.toMinecraft(entityKey)));
        return new UnmodifiableAttributeMap(supplier);
    }

    public NamespacedKey getBiomeKey(RegionAccessor accessor, int x2, int y2, int z2) {
        return accessor.getBiome(x2, y2, z2).getKey();
    }

    public void setBiomeKey(RegionAccessor accessor, int x2, int y2, int z2, NamespacedKey biomeKey) {
        accessor.setBiome(x2, y2, z2, (Biome)Registry.BIOME.getOrThrow(biomeKey));
    }

    public String getStatisticCriteriaKey(Statistic statistic) {
        if (statistic.getType() != Statistic.Type.UNTYPED) {
            return "minecraft.custom:minecraft." + statistic.getKey().getKey();
        }
        return CraftStatistic.getNMSStatistic(statistic).d();
    }

    public List<Component> computeTooltipLines(ItemStack itemStack, TooltipContext tooltipContext, Player player) {
        TooltipFlag.a flag;
        Preconditions.checkArgument((tooltipContext != null ? 1 : 0) != 0, (Object)"tooltipContext cannot be null");
        TooltipFlag.a a2 = flag = tooltipContext.isAdvanced() ? TooltipFlag.b : TooltipFlag.a;
        if (tooltipContext.isCreative()) {
            flag = flag.c();
        }
        List<IChatBaseComponent> lines = CraftItemStack.asNMSCopy(itemStack).a(Item.b.a(player == null ? CraftRegistry.getMinecraftRegistry() : ((CraftPlayer)player).getHandle().A().J_()), (EntityHuman)(player == null ? null : ((CraftPlayer)player).getHandle()), flag);
        return lines.stream().map(PaperAdventure::asAdventure).toList();
    }

    public Color getSpawnEggLayerColor(EntityType entityType, int layer) {
        EntityTypes<?> nmsType = CraftEntityType.bukkitToMinecraft(entityType);
        ItemMonsterEgg eggItem = ItemMonsterEgg.a(nmsType);
        if (eggItem != null) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public LifecycleEventManager<Plugin> createPluginLifecycleEventManager(JavaPlugin plugin, BooleanSupplier registrationCheck) {
        return new PaperLifecycleEventManager<JavaPlugin>(plugin, registrationCheck);
    }

    public ItemStack createEmptyStack() {
        return CraftItemStack.asCraftMirror(null);
    }

    public ItemStack deserializeItemHover(HoverEvent.ShowItem itemHover) {
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().a(JavaOps.INSTANCE);
        Object encoded = AdventureCodecs.SHOW_ITEM_CODEC.codec().encodeStart(ops, (Object)HoverEvent.showItem((HoverEvent.ShowItem)itemHover)).getOrThrow(IllegalStateException::new);
        return CraftItemStack.asBukkitCopy(((ChatHoverable.d)ChatHoverable.d.b.codec().parse(ops, encoded).getOrThrow(IllegalStateException::new)).b());
    }

    static {
        for (Block block2 : BuiltInRegistries.e) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial((String)BuiltInRegistries.e.b(block2).a().toUpperCase(Locale.ROOT)));
        }
        for (Item item2 : BuiltInRegistries.h) {
            ITEM_MATERIAL.put(item2, Material.getMaterial((String)BuiltInRegistries.h.b(item2).a().toUpperCase(Locale.ROOT)));
        }
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            MinecraftKey key = CraftNamespacedKey.toMinecraft(material.getKey());
            BuiltInRegistries.h.b(key).ifPresent(item -> MATERIAL_ITEM.put(material, (Item)item));
            BuiltInRegistries.e.b(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (Block)block));
        }
        SNBT_REGISTRY_UNAWARE_PARSER = MojangsonParser.a(DynamicOpsNBT.a);
    }
}

