/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import ca.spottedleaf.moonrise.common.util.TickThread;
import io.papermc.paper.FeatureHooks;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.spigotmc.RestartCommand;
import org.spigotmc.SpigotConfig;

public class WatchdogThread
extends TickThread {
    public static final boolean DISABLE_WATCHDOG = Boolean.getBoolean("disable.watchdog");
    private static WatchdogThread instance;
    private long timeoutTime;
    private boolean restart;
    private final long earlyWarningEvery;
    private final long earlyWarningDelay;
    public static volatile boolean hasStarted;
    private long lastEarlyWarning;
    private volatile long lastTick;
    private volatile boolean stopping;

    private WatchdogThread(long timeoutTime, boolean restart) {
        super("Paper Watchdog Thread");
        this.timeoutTime = timeoutTime;
        this.restart = restart;
        this.earlyWarningEvery = Math.min((long)GlobalConfiguration.get().watchdog.earlyWarningEvery, timeoutTime);
        this.earlyWarningDelay = Math.min((long)GlobalConfiguration.get().watchdog.earlyWarningDelay, timeoutTime);
    }

    private static long monotonicMillis() {
        return System.nanoTime() / 1000000L;
    }

    public static void doStart(int timeoutTime, boolean restart) {
        if (instance == null) {
            if (timeoutTime <= 0) {
                timeoutTime = 300;
            }
            instance = new WatchdogThread((long)timeoutTime * 1000L, restart);
            instance.start();
        } else {
            WatchdogThread.instance.timeoutTime = (long)timeoutTime * 1000L;
            WatchdogThread.instance.restart = restart;
        }
    }

    public static void tick() {
        WatchdogThread.instance.lastTick = WatchdogThread.monotonicMillis();
    }

    public static void doStop() {
        if (instance != null) {
            WatchdogThread.instance.stopping = true;
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            Logger logger = Bukkit.getServer().getLogger();
            long currentTime = WatchdogThread.monotonicMillis();
            MinecraftServer server = MinecraftServer.getServer();
            if (this.lastTick != 0L && this.timeoutTime > 0L && hasStarted && (!server.z() || currentTime > this.lastTick + this.earlyWarningEvery && !DISABLE_WATCHDOG)) {
                boolean isLongTimeout;
                boolean bl = isLongTimeout = currentTime > this.lastTick + this.timeoutTime || !server.z() && !server.hasStopped() && currentTime > this.lastTick + 1000L;
                if (!isLongTimeout && (this.earlyWarningEvery <= 0L || !hasStarted || currentTime < this.lastEarlyWarning + this.earlyWarningEvery || currentTime < this.lastTick + this.earlyWarningDelay) || !isLongTimeout && server.hasStopped()) continue;
                this.lastEarlyWarning = currentTime;
                if (isLongTimeout) {
                    logger.log(Level.SEVERE, "------------------------------");
                    logger.log(Level.SEVERE, "The server has stopped responding! This is (probably) not a Paper bug.");
                    logger.log(Level.SEVERE, "If you see a plugin in the Server thread dump below, then please report it to that author");
                    logger.log(Level.SEVERE, "\t *Especially* if it looks like HTTP or MySQL operations are occurring");
                    logger.log(Level.SEVERE, "If you see a world save or edit, then it means you did far more than your server can handle at once");
                    logger.log(Level.SEVERE, "\t If this is the case, consider increasing timeout-time in spigot.yml but note that this will replace the crash with LARGE lag spikes");
                    logger.log(Level.SEVERE, "If you are unsure or still think this is a Paper bug, please report this to https://github.com/PaperMC/Paper/issues");
                    logger.log(Level.SEVERE, "Be sure to include ALL relevant console errors and Minecraft crash reports");
                    logger.log(Level.SEVERE, "Paper version: " + Bukkit.getServer().getVersion());
                    if (World.lastPhysicsProblem != null) {
                        logger.log(Level.SEVERE, "------------------------------");
                        logger.log(Level.SEVERE, "During the run of the server, a physics stackoverflow was suppressed");
                        logger.log(Level.SEVERE, "near " + String.valueOf(World.lastPhysicsProblem));
                    }
                    if (CraftServer.excessiveVelEx != null) {
                        logger.log(Level.SEVERE, "------------------------------");
                        logger.log(Level.SEVERE, "During the run of the server, a plugin set an excessive velocity on an entity");
                        logger.log(Level.SEVERE, "This may be the cause of the issue, or it may be entirely unrelated");
                        logger.log(Level.SEVERE, CraftServer.excessiveVelEx.getMessage());
                        for (StackTraceElement stack : CraftServer.excessiveVelEx.getStackTrace()) {
                            logger.log(Level.SEVERE, "\t\t" + String.valueOf(stack));
                        }
                    }
                } else {
                    logger.log(Level.SEVERE, "--- DO NOT REPORT THIS TO PAPER - THIS IS NOT A BUG OR A CRASH  - " + Bukkit.getServer().getVersion() + " ---");
                    logger.log(Level.SEVERE, "The server has not responded for " + (currentTime - this.lastTick) / 1000L + " seconds! Creating thread dump");
                }
                logger.log(Level.SEVERE, "------------------------------");
                logger.log(Level.SEVERE, "Server thread dump (Look for plugins here before reporting to Paper!):");
                FeatureHooks.dumpAllChunkLoadInfo(MinecraftServer.getServer(), isLongTimeout);
                WatchdogThread.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(MinecraftServer.getServer().ak.threadId(), Integer.MAX_VALUE), logger);
                logger.log(Level.SEVERE, "------------------------------");
                if (isLongTimeout) {
                    ThreadInfo[] threads;
                    logger.log(Level.SEVERE, "Entire Thread Dump:");
                    for (ThreadInfo thread : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                        WatchdogThread.dumpThread(thread, logger);
                    }
                } else {
                    logger.log(Level.SEVERE, "--- DO NOT REPORT THIS TO PAPER - THIS IS NOT A BUG OR A CRASH ---");
                }
                logger.log(Level.SEVERE, "------------------------------");
                if (isLongTimeout) {
                    if (server.hasStopped()) break;
                    server.forceTicks = true;
                    if (this.restart) {
                        RestartCommand.addShutdownHook(SpigotConfig.restartScript);
                    }
                    server.abnormalExit = true;
                    server.safeShutdown(false, this.restart);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    if (server.hasStopped()) break;
                    server.close();
                    break;
                }
            }
            try {
                WatchdogThread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.interrupt();
            }
        }
    }

    private static void dumpThread(ThreadInfo thread, Logger logger) {
        logger.log(Level.SEVERE, "------------------------------");
        logger.log(Level.SEVERE, "Current Thread: " + thread.getThreadName());
        logger.log(Level.SEVERE, "\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + String.valueOf((Object)thread.getThreadState()));
        if (thread.getLockedMonitors().length != 0) {
            logger.log(Level.SEVERE, "\tThread is waiting on monitor(s):");
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                logger.log(Level.SEVERE, "\t\tLocked on:" + String.valueOf(monitor.getLockedStackFrame()));
            }
        }
        logger.log(Level.SEVERE, "\tStack:");
        for (StackTraceElement stack : StacktraceDeobfuscator.INSTANCE.deobfuscateStacktrace(thread.getStackTrace())) {
            logger.log(Level.SEVERE, "\t\t" + String.valueOf(stack));
        }
    }
}

