/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.art.api.ClassProvider;
import net.neoforged.art.api.Transformer;
import net.neoforged.art.internal.EnhancedClassRemapper;
import net.neoforged.art.internal.EnhancedRemapper;
import net.neoforged.art.internal.JavadoctorRemapper;
import net.neoforged.javadoctor.io.gson.GsonJDocIO;
import net.neoforged.javadoctor.spec.ClassJavadoc;
import net.neoforged.javadoctor.spec.DocReferences;
import net.neoforged.javadoctor.spec.JavadoctorInformation;
import net.neoforged.srgutils.IMappingFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class RenamingTransformer
implements Transformer {
    private static final String ABSTRACT_FILE = "fernflower_abstract_parameter_names.txt";
    private final EnhancedRemapper remapper;
    private final Set<String> abstractParams = ConcurrentHashMap.newKeySet();
    private final boolean collectAbstractParams;

    public RenamingTransformer(ClassProvider classProvider, IMappingFile map, Consumer<String> log) {
        this(classProvider, map, log, true);
    }

    public RenamingTransformer(ClassProvider classProvider, IMappingFile map, Consumer<String> log, boolean collectAbstractParams) {
        this.collectAbstractParams = collectAbstractParams;
        this.remapper = new EnhancedRemapper(classProvider, map, log);
    }

    @Override
    public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getData());
        ClassWriter writer = new ClassWriter(0);
        EnhancedClassRemapper remapper = new EnhancedClassRemapper((ClassVisitor)writer, this.remapper, this);
        reader.accept((ClassVisitor)remapper, 0);
        byte[] data = writer.toByteArray();
        String newName = this.remapper.map(entry.getClassName());
        if (entry.isMultiRelease()) {
            return Transformer.ClassEntry.create(newName, entry.getTime(), data, entry.getVersion());
        }
        return Transformer.ClassEntry.create(newName + ".class", entry.getTime(), data);
    }

    @Override
    public Transformer.JavadoctorEntry process(Transformer.JavadoctorEntry entry) {
        JavadoctorInformation docs = GsonJDocIO.read((Gson)GsonJDocIO.GSON, (JsonObject)((JsonObject)GsonJDocIO.GSON.fromJson(new String(entry.getData()), JsonObject.class)));
        JavadoctorRemapper remapper = new JavadoctorRemapper(this.remapper, docs.getReferences());
        HashMap newEntries = new HashMap();
        docs.getClassDocs().forEach((clazz, jdoc) -> newEntries.put(this.remapper.map(clazz.replace('.', '/')).replace('/', '.'), remapper.remap((String)clazz, clazz.replace('.', '/'), (ClassJavadoc)jdoc)));
        HashMap referencedClasses = new HashMap(docs.getReferences().getClasses().size(), 1.0f);
        docs.getReferences().getClasses().forEach((key, internal) -> {
            String mapped = this.remapper.map((String)internal);
            referencedClasses.put(mapped.replace('/', '.').replace('$', '.'), mapped);
        });
        return Transformer.JavadoctorEntry.create(entry.getTime(), GsonJDocIO.GSON.toJson((JsonElement)GsonJDocIO.write((Gson)GsonJDocIO.GSON, (JavadoctorInformation)new JavadoctorInformation(new DocReferences(referencedClasses), newEntries))).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        if (ABSTRACT_FILE.equals(entry.getName())) {
            return null;
        }
        return entry;
    }

    @Override
    public Collection<? extends Transformer.Entry> getExtras() {
        if (this.abstractParams.isEmpty() || !this.collectAbstractParams) {
            return Collections.emptyList();
        }
        byte[] data = this.abstractParams.stream().sorted().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
        return Collections.singletonList(Transformer.ResourceEntry.create(ABSTRACT_FILE, 946684800L, data));
    }

    void storeNames(String className, String methodName, String methodDescriptor, Collection<String> paramNames) {
        this.abstractParams.add(className + ' ' + methodName + ' ' + methodDescriptor + ' ' + paramNames.stream().collect(Collectors.joining(" ")));
    }
}

