/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.LevelHelper;
import alternate.current.wire.Node;
import alternate.current.wire.WireConnectionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class WireNode
extends Node {
    final WireConnectionManager connections;
    int currentPower;
    int virtualPower;
    int externalPower;
    int flowIn;
    int iFlowDir;
    boolean added;
    boolean removed;
    boolean shouldBreak;
    boolean root;
    boolean discovered;
    boolean searched;
    WireNode next_wire;

    WireNode(ServerLevel level, BlockPos pos, BlockState state) {
        super(level);
        this.pos = pos.immutable();
        this.state = state;
        this.connections = new WireConnectionManager(this);
        this.virtualPower = this.currentPower = this.state.getValue(RedStoneWireBlock.POWER).intValue();
        this.priority = this.priority();
    }

    @Override
    Node set(BlockPos pos, BlockState state, boolean clearNeighbors) {
        throw new UnsupportedOperationException("Cannot update a WireNode!");
    }

    @Override
    int priority() {
        return Mth.clamp(this.virtualPower, 0, 15);
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public WireNode asWire() {
        return this;
    }

    boolean offerPower(int power, int iDir) {
        if (this.removed || this.shouldBreak) {
            return false;
        }
        if (power == this.virtualPower) {
            this.flowIn |= 1 << iDir;
            return false;
        }
        if (power > this.virtualPower) {
            this.virtualPower = power;
            this.flowIn = 1 << iDir;
            return true;
        }
        return false;
    }

    boolean setPower() {
        if (this.removed) {
            return true;
        }
        this.state = this.level.getBlockState(this.pos);
        if (!this.state.is(Blocks.REDSTONE_WIRE)) {
            return false;
        }
        if (this.shouldBreak) {
            Block.dropResources(this.state, this.level, this.pos);
            this.level.setBlock(this.pos, Blocks.AIR.defaultBlockState(), 2);
            return true;
        }
        this.currentPower = LevelHelper.doRedstoneEvent(this.level, this.pos, this.currentPower, Mth.clamp(this.virtualPower, 0, 15));
        this.state = (BlockState)this.state.setValue(RedStoneWireBlock.POWER, this.currentPower);
        return LevelHelper.setWireState(this.level, this.pos, this.state, this.added);
    }
}

