/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.entity;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.ConverterAbstractStringValueTypeRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.function.Function;

public final class ConverterAbstractEntityRename {
    private ConverterAbstractEntityRename() {
    }

    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractEntityRename.register(version, 0, renamer);
    }

    public static void register(int version, int subVersion, final Function<String, String> renamer) {
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType, MapType>(version, subVersion){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String id = data.getString("id");
                if (id == null) {
                    return null;
                }
                String converted = (String)renamer.apply(id);
                if (converted != null) {
                    data.setString("id", converted);
                }
                return null;
            }
        });
        ConverterAbstractStringValueTypeRename.register(version, subVersion, MCTypeRegistry.ENTITY_NAME, renamer);
    }
}

