/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.datatypes;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataHook;
import ca.spottedleaf.dataconverter.converters.datatypes.DataType;
import ca.spottedleaf.dataconverter.minecraft.MCVersionRegistry;
import ca.spottedleaf.dataconverter.util.Long2ObjectArraySortedMap;
import java.util.ArrayList;
import java.util.List;

public class MCValueType
extends DataType<Object, Object> {
    public final String name;
    protected final ArrayList<DataConverter<Object, Object>> converters = new ArrayList();
    protected final Long2ObjectArraySortedMap<List<DataHook<Object, Object>>> structureHooks = new Long2ObjectArraySortedMap();

    public MCValueType(String name) {
        this.name = name;
    }

    public void addStructureHook(int minVersion, DataHook<Object, Object> hook) {
        this.addStructureHook(minVersion, 0, hook);
    }

    public void addStructureHook(int minVersion, int versionStep, DataHook<Object, Object> hook) {
        this.structureHooks.computeIfAbsent(DataConverter.encodeVersions(minVersion, versionStep), keyInMap -> new ArrayList()).add(hook);
    }

    public void addConverter(DataConverter<Object, Object> converter) {
        MCVersionRegistry.checkVersion(converter.getEncodedVersion());
        boolean sort = !this.converters.isEmpty() && DataConverter.LOWEST_VERSION_COMPARATOR.compare(this.converters.getLast(), converter) > 0;
        this.converters.add(converter);
        if (sort) {
            this.converters.sort(DataConverter.LOWEST_VERSION_COMPARATOR);
        }
    }

    @Override
    public Object convert(Object data, long fromVersion, long toVersion) {
        Object ret = null;
        ArrayList<DataConverter<Object, Object>> converters = this.converters;
        int len = converters.size();
        for (int i = 0; i < len; ++i) {
            Object converted;
            DataConverter converter = (DataConverter)converters.get(i);
            long converterVersion = converter.getEncodedVersion();
            if (converterVersion <= fromVersion) continue;
            if (converterVersion > toVersion) break;
            List<DataHook<Object, Object>> hooks = this.structureHooks.getFloor(converterVersion);
            if (hooks != null) {
                int klen = hooks.size();
                for (int k = 0; k < klen; ++k) {
                    Object replace = hooks.get(k).preHook(ret == null ? data : ret, fromVersion, toVersion);
                    if (replace == null) continue;
                    ret = replace;
                }
            }
            if ((converted = converter.convert(ret == null ? data : ret, fromVersion, toVersion)) != null) {
                ret = converted;
            }
            if ((hooks = this.structureHooks.getFloor(toVersion)) == null) continue;
            int klen = hooks.size();
            for (int k = 0; k < klen; ++k) {
                Object replace = hooks.get(k).postHook(ret == null ? data : ret, fromVersion, toVersion);
                if (replace == null) continue;
                ret = replace;
            }
        }
        return ret;
    }
}

