/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.ComponentUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.DataWalkerTypePaths;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V1458 {
    public static final int VERSION = 1458;

    public static MapType updateCustomName(MapType data) {
        String customName = data.getString("CustomName", "");
        if (customName.isEmpty()) {
            data.remove("CustomName");
        } else {
            data.setString("CustomName", ComponentUtils.createPlainTextComponent(customName));
        }
        return null;
    }

    static void named(int version, String id) {
        MCTypeRegistry.TILE_ENTITY.addWalker(version, id, new DataWalkerTypePaths<Object, Object>(MCTypeRegistry.TEXT_COMPONENT, "CustomName"));
    }

    static void namedInventory(int version, String id) {
        V1458.named(version, id);
        MCTypeRegistry.TILE_ENTITY.addWalker(version, id, new DataWalkerItemLists("Items"));
    }

    public static void register() {
        MCTypeRegistry.PLAYER.addStructureConverter(new DataConverter<MapType, MapType>(1458){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType, MapType>(1458){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                if ("minecraft:commandblock_minecart".equals(data.getString("id"))) {
                    return null;
                }
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType, MapType>(1458){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType tag = data.getMap("tag");
                if (tag == null) {
                    return null;
                }
                MapType display = tag.getMap("display");
                if (display == null) {
                    return null;
                }
                String name = display.getString("Name");
                if (name != null) {
                    display.setString("Name", ComponentUtils.createPlainTextComponent(name));
                }
                return null;
            }
        });
        MCTypeRegistry.TILE_ENTITY.addStructureConverter(new DataConverter<MapType, MapType>(1458){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                if ("minecraft:command_block".equals(data.getString("id"))) {
                    return null;
                }
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.ENTITY.addStructureWalker(1458, (data, fromVersion, toVersion) -> {
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, data, "Passengers", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "CustomName", fromVersion, toVersion);
            return MCTypeRegistry.ENTITY_EQUIPMENT.convert((MapType)data, fromVersion, toVersion);
        });
        MCTypeRegistry.PLAYER.addStructureWalker(1458, (data, fromVersion, toVersion) -> {
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data.getMap("RootVehicle"), "Entity", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, data, "ender_pearls", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, data, "Inventory", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, data, "EnderItems", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data, "ShoulderEntityLeft", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data, "ShoulderEntityRight", fromVersion, toVersion);
            MapType recipeBook = data.getMap("recipeBook");
            if (recipeBook != null) {
                WalkerUtils.convertList(MCTypeRegistry.RECIPE, recipeBook, "recipes", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.RECIPE, recipeBook, "toBeDisplayed", fromVersion, toVersion);
            }
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "CustomName", fromVersion, toVersion);
            return null;
        });
        V1458.named(1458, "minecraft:beacon");
        V1458.named(1458, "minecraft:banner");
        V1458.namedInventory(1458, "minecraft:brewing_stand");
        V1458.namedInventory(1458, "minecraft:chest");
        V1458.namedInventory(1458, "minecraft:trapped_chest");
        V1458.namedInventory(1458, "minecraft:dispenser");
        V1458.namedInventory(1458, "minecraft:dropper");
        V1458.named(1458, "minecraft:enchanting_table");
        V1458.namedInventory(1458, "minecraft:furnace");
        V1458.namedInventory(1458, "minecraft:hopper");
        V1458.namedInventory(1458, "minecraft:shulker_box");
    }

    private V1458() {
    }
}

