/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;
import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.datafix.PackedBitStorage;

public final class V1496 {
    private static final int VERSION = 1496;
    private static final int[][] DIRECTIONS = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}};
    private static final Object2IntOpenHashMap<String> LEAVES_TO_ID = new Object2IntOpenHashMap();
    private static final Set<String> LOGS;

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType, MapType>(1496){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                ListType sectionsNBT = level.getList("Sections", ObjectType.MAP);
                if (sectionsNBT == null) {
                    return null;
                }
                int newSides = 0;
                LeavesSection[] sections = new LeavesSection[16];
                boolean skippable = true;
                int len = sectionsNBT.size();
                for (int i = 0; i < len; ++i) {
                    LeavesSection section;
                    sections[section.sectionY] = section = new LeavesSection(sectionsNBT.getMap(i));
                    skippable &= section.isSkippable();
                }
                if (skippable) {
                    return null;
                }
                IntOpenHashSet[] positionsByDistance = new IntOpenHashSet[7];
                for (int i = 0; i < positionsByDistance.length; ++i) {
                    positionsByDistance[i] = new IntOpenHashSet();
                }
                for (LeavesSection section : sections) {
                    if (section == null || section.isSkippable()) continue;
                    for (int index = 0; index < 4096; ++index) {
                        int block = section.getBlock(index);
                        if (section.isLog(block)) {
                            positionsByDistance[0].add(section.getSectionY() << 12 | index);
                            continue;
                        }
                        if (!section.isLeaf(block)) continue;
                        int x = V1496.getX(index);
                        int z = V1496.getZ(index);
                        newSides |= V1496.getSideMask(x == 0, x == 15, z == 0, z == 15);
                    }
                }
                for (int distance = 1; distance < 7; ++distance) {
                    IntOpenHashSet positionsLess = positionsByDistance[distance - 1];
                    IntOpenHashSet positionsEqual = positionsByDistance[distance];
                    IntIterator iterator = positionsLess.iterator();
                    while (iterator.hasNext()) {
                        int position = iterator.nextInt();
                        int fromX = V1496.getX(position);
                        int fromY = V1496.getY(position);
                        int fromZ = V1496.getZ(position);
                        for (int[] direction : DIRECTIONS) {
                            int newDistance;
                            int sectionLocalIndex;
                            int toBlock;
                            LeavesSection toSection;
                            int toX = fromX + direction[0];
                            int toY = fromY + direction[1];
                            int toZ = fromZ + direction[2];
                            if (toX < 0 || toX > 15 || toZ < 0 || toZ > 15 || toY < 0 || toY > 255 || (toSection = sections[toY >> 4]) == null || toSection.isSkippable() || !toSection.isLeaf(toBlock = toSection.getBlock(sectionLocalIndex = V1496.getIndex(toX, toY & 0xF, toZ))) || (newDistance = toSection.getDistance(toBlock)) <= distance) continue;
                            toSection.setDistance(sectionLocalIndex, toBlock, distance);
                            positionsEqual.add(V1496.getIndex(toX, toY, toZ));
                        }
                    }
                }
                int len2 = sectionsNBT.size();
                for (int i = 0; i < len2; ++i) {
                    MapType sectionNBT = sectionsNBT.getMap(i);
                    int y = sectionNBT.getInt("Y");
                    LeavesSection section = sections[y];
                    section.writeInto(sectionNBT);
                }
                if (newSides != 0) {
                    MapType upgradeData = level.getMap("UpgradeData");
                    if (upgradeData == null) {
                        upgradeData = Types.NBT.createEmptyMap();
                        level.setMap("UpgradeData", upgradeData);
                    }
                    upgradeData.setByte("Sides", (byte)(upgradeData.getByte("Sides") | newSides));
                }
                return null;
            }
        });
    }

    public static int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public static int getX(int index) {
        return index & 0xF;
    }

    public static int getY(int index) {
        return index >> 8 & 0xFF;
    }

    public static int getZ(int index) {
        return index >> 4 & 0xF;
    }

    public static int getSideMask(boolean noLeft, boolean noRight, boolean noBack, boolean noForward) {
        int ret = noBack ? (noRight ? 2 : (noLeft ? 128 : 1)) : (noForward ? (noLeft ? 32 : (noRight ? 8 : 16)) : (noRight ? 4 : (noLeft ? 64 : 0)));
        return ret;
    }

    private V1496() {
    }

    static {
        LEAVES_TO_ID.put((Object)"minecraft:acacia_leaves", 0);
        LEAVES_TO_ID.put((Object)"minecraft:birch_leaves", 1);
        LEAVES_TO_ID.put((Object)"minecraft:dark_oak_leaves", 2);
        LEAVES_TO_ID.put((Object)"minecraft:jungle_leaves", 3);
        LEAVES_TO_ID.put((Object)"minecraft:oak_leaves", 4);
        LEAVES_TO_ID.put((Object)"minecraft:spruce_leaves", 5);
        LOGS = new HashSet<String>(Arrays.asList("minecraft:acacia_bark", "minecraft:birch_bark", "minecraft:dark_oak_bark", "minecraft:jungle_bark", "minecraft:oak_bark", "minecraft:spruce_bark", "minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log", "minecraft:stripped_acacia_log", "minecraft:stripped_birch_log", "minecraft:stripped_dark_oak_log", "minecraft:stripped_jungle_log", "minecraft:stripped_oak_log", "minecraft:stripped_spruce_log"));
    }

    public static final class LeavesSection
    extends Section {
        private IntOpenHashSet leaveIds;
        private IntOpenHashSet logIds;
        private Int2IntOpenHashMap stateToIdMap;

        public LeavesSection(MapType section) {
            super(section);
        }

        @Override
        protected boolean initSkippable() {
            this.leaveIds = new IntOpenHashSet();
            this.logIds = new IntOpenHashSet();
            this.stateToIdMap = new Int2IntOpenHashMap();
            this.stateToIdMap.defaultReturnValue(-1);
            for (int i = 0; i < this.palette.size(); ++i) {
                MapType blockState = this.palette.getMap(i);
                String name = blockState.getString("Name", "");
                if (LEAVES_TO_ID.containsKey((Object)name)) {
                    MapType properties = blockState.getMap("Properties");
                    boolean notDecayable = properties != null && "false".equals(properties.getString("decayable"));
                    this.leaveIds.add(i);
                    this.stateToIdMap.put(this.getStateId(name, notDecayable, 7), i);
                    this.palette.setMap(i, this.makeNewLeafTag(name, notDecayable, 7));
                }
                if (!LOGS.contains(name)) continue;
                this.logIds.add(i);
            }
            return this.leaveIds.isEmpty() && this.logIds.isEmpty();
        }

        private MapType makeNewLeafTag(String name, boolean notDecayable, int distance) {
            MapType properties = Types.NBT.createEmptyMap();
            MapType ret = Types.NBT.createEmptyMap();
            ret.setString("Name", name);
            ret.setMap("Properties", properties);
            properties.setString("persistent", Boolean.toString(notDecayable));
            properties.setString("distance", Integer.toString(distance));
            return ret;
        }

        public boolean isLog(int id) {
            return this.logIds.contains(id);
        }

        public boolean isLeaf(int id) {
            return this.leaveIds.contains(id);
        }

        private int getDistance(int id) {
            if (this.isLog(id)) {
                return 0;
            }
            return Integer.parseInt(this.palette.getMap(id).getMap("Properties").getString("distance"));
        }

        private void setDistance(int index, int id, int distance) {
            boolean persistent;
            MapType state = this.palette.getMap(id);
            String name = state.getString("Name");
            int newState = this.getStateId(name, persistent = "true".equals(state.getMap("Properties").getString("persistent")), distance);
            int newStateId = this.stateToIdMap.get(newState);
            if (newStateId == -1) {
                newStateId = this.palette.size();
                this.leaveIds.add(newStateId);
                this.stateToIdMap.put(newState, newStateId);
                this.palette.addMap(this.makeNewLeafTag(name, persistent, distance));
            }
            if (1 << this.storage.getBits() <= newStateId) {
                PackedBitStorage newStorage = new PackedBitStorage(this.storage.getBits() + 1, 4096);
                for (int i = 0; i < 4096; ++i) {
                    newStorage.set(i, this.storage.get(i));
                }
                this.storage = newStorage;
            }
            this.storage.set(index, newStateId);
        }
    }

    public static abstract class Section {
        protected final ListType palette;
        protected final int sectionY;
        protected PackedBitStorage storage;

        public Section(MapType section) {
            this.palette = section.getList("Palette", ObjectType.MAP);
            this.sectionY = section.getInt("Y");
            this.readStorage(section);
        }

        protected void readStorage(MapType section) {
            if (this.initSkippable()) {
                this.storage = null;
            } else {
                long[] states = section.getLongs("BlockStates");
                int bits = Math.max(4, DataFixUtils.ceillog2((int)this.palette.size()));
                this.storage = new PackedBitStorage(bits, 4096, states);
            }
        }

        public void writeInto(MapType section) {
            if (this.isSkippable()) {
                return;
            }
            section.setList("Palette", this.palette);
            section.setLongs("BlockStates", this.storage.getRaw());
        }

        public boolean isSkippable() {
            return this.storage == null;
        }

        public int getBlock(int index) {
            return this.storage.get(index);
        }

        protected int getStateId(String name, boolean persistent, int distance) {
            return LEAVES_TO_ID.getInt((Object)name) << 5 | (persistent ? 16 : 0) | distance;
        }

        protected int getSectionY() {
            return this.sectionY;
        }

        protected abstract boolean initSkippable();
    }
}

