/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataWalker;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import java.util.HashSet;
import java.util.Set;

public final class V4307 {
    private static final int VERSION = 4307;

    public static void register() {
        MCTypeRegistry.DATA_COMPONENTS.addStructureConverter(new DataConverter<MapType, MapType>(4307){
            private static final String[] ADDITIONAL_TOOLTIP_COMPONENTS = new String[]{"minecraft:banner_patterns", "minecraft:bees", "minecraft:block_entity_data", "minecraft:block_state", "minecraft:bundle_contents", "minecraft:charged_projectiles", "minecraft:container", "minecraft:container_loot", "minecraft:firework_explosion", "minecraft:fireworks", "minecraft:instrument", "minecraft:map_id", "minecraft:painting/variant", "minecraft:pot_decorations", "minecraft:potion_contents", "minecraft:tropical_fish/pattern", "minecraft:written_book_content"};

            private static void unwrapBlockPredicates(MapType root, String path, Set<String> hiddenComponents) {
                MapType component = root.getMap(path);
                if (component == null) {
                    return;
                }
                Object predicates = component.getGeneric("predicates");
                if (predicates == null) {
                    return;
                }
                root.setGeneric(path, predicates);
                if (!component.getBoolean("show_in_tooltip", true)) {
                    hiddenComponents.add(path);
                }
            }

            private static void updateComponent(MapType root, String path, Set<String> hiddenComponents) {
                MapType component = root.getMap(path);
                if (component == null) {
                    return;
                }
                if (!component.getBoolean("show_in_tooltip", true)) {
                    hiddenComponents.add(path);
                }
                component.remove("show_in_tooltip");
            }

            private static void updateComponentAndUnwrap(MapType root, String componentPath, String unwrapPath, Set<String> hiddenComponents) {
                MapType component = root.getMap(componentPath);
                if (component == null) {
                    return;
                }
                if (!component.getBoolean("show_in_tooltip", true)) {
                    hiddenComponents.add(componentPath);
                }
                component.remove("show_in_tooltip");
                Object wrapped = component.getGeneric(unwrapPath);
                if (wrapped != null) {
                    root.setGeneric(componentPath, wrapped);
                }
            }

            @Override
            public MapType convert(MapType root, long sourceVersion, long toVersion) {
                HashSet<String> hiddenComponents = new HashSet<String>();
                1.unwrapBlockPredicates(root, "minecraft:can_place_on", hiddenComponents);
                1.unwrapBlockPredicates(root, "minecraft:can_break", hiddenComponents);
                1.updateComponent(root, "minecraft:trim", hiddenComponents);
                1.updateComponent(root, "minecraft:unbreakable", hiddenComponents);
                1.updateComponentAndUnwrap(root, "minecraft:dyed_color", "rgb", hiddenComponents);
                1.updateComponentAndUnwrap(root, "minecraft:attribute_modifiers", "modifiers", hiddenComponents);
                1.updateComponentAndUnwrap(root, "minecraft:enchantments", "levels", hiddenComponents);
                1.updateComponentAndUnwrap(root, "minecraft:stored_enchantments", "levels", hiddenComponents);
                1.updateComponentAndUnwrap(root, "minecraft:jukebox_playable", "song", hiddenComponents);
                boolean hideTooltip = root.hasKey("minecraft:hide_tooltip");
                boolean hideAdditionalTooltip = root.hasKey("minecraft:hide_additional_tooltip");
                if (hideAdditionalTooltip) {
                    for (String component : ADDITIONAL_TOOLTIP_COMPONENTS) {
                        if (!root.hasKey(component)) continue;
                        hiddenComponents.add(component);
                    }
                }
                root.remove("minecraft:hide_tooltip");
                root.remove("minecraft:hide_additional_tooltip");
                if (hideTooltip || !hiddenComponents.isEmpty()) {
                    TypeUtil<?> typeUtil = root.getTypeUtil();
                    MapType tooltipDisplay = typeUtil.createEmptyMap();
                    ListType hiddenComponentsList = typeUtil.createEmptyList();
                    root.setMap("minecraft:tooltip_display", tooltipDisplay);
                    tooltipDisplay.setBoolean("hide_tooltip", hideTooltip);
                    tooltipDisplay.setList("hidden_components", hiddenComponentsList);
                    for (String component : hiddenComponents) {
                        hiddenComponentsList.addString(component);
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.DATA_COMPONENTS.addStructureWalker(4307, new DataWalker<MapType>(){

            private static void walkBlockPredicate(MapType data, long fromVersion, long toVersion) {
                if (data == null) {
                    return;
                }
                if (data.hasKey("blocks", ObjectType.LIST)) {
                    WalkerUtils.convertList(MCTypeRegistry.BLOCK_NAME, data, "blocks", fromVersion, toVersion);
                } else {
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, data, "blocks", fromVersion, toVersion);
                }
            }

            private static void walkBlockPredicates(MapType root, String path, long fromVersion, long toVersion) {
                Object value = root.getGeneric(path);
                if (value instanceof MapType) {
                    MapType data = (MapType)value;
                    2.walkBlockPredicate(data, fromVersion, toVersion);
                } else if (value instanceof ListType) {
                    ListType list = (ListType)value;
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        2.walkBlockPredicate(list.getMap(i, null), fromVersion, toVersion);
                    }
                }
            }

            @Override
            public MapType walk(MapType root, long fromVersion, long toVersion) {
                ListType pages;
                WalkerUtils.convertListPath(MCTypeRegistry.ENTITY, root, "minecraft:bees", "entity_data", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.TILE_ENTITY, root, "minecraft:block_entity_data", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, root, "minecraft:bundle_contents", fromVersion, toVersion);
                2.walkBlockPredicates(root, "minecraft:can_break", fromVersion, toVersion);
                2.walkBlockPredicates(root, "minecraft:can_place_on", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, root, "minecraft:charged_projectiles", fromVersion, toVersion);
                WalkerUtils.convertListPath(MCTypeRegistry.ITEM_STACK, root, "minecraft:container", "item", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ENTITY, root, "minecraft:entity_data", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.ITEM_NAME, root, "minecraft:pot_decorations", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, root, "minecraft:use_remainder", fromVersion, toVersion);
                MapType equippable = root.getMap("minecraft:equippable");
                if (equippable != null) {
                    WalkerUtils.convert(MCTypeRegistry.ENTITY_NAME, equippable, "allowed_entities", fromVersion, toVersion);
                    WalkerUtils.convertList(MCTypeRegistry.ENTITY_NAME, equippable, "allowed_entities", fromVersion, toVersion);
                }
                WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, root, "minecraft:custom_name", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, root, "minecraft:item_name", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.TEXT_COMPONENT, root, "minecraft:lore", fromVersion, toVersion);
                MapType writtenBookContent = root.getMap("minecraft:written_book_content");
                if (writtenBookContent != null && (pages = writtenBookContent.getListUnchecked("pages")) != null) {
                    int len = pages.size();
                    for (int i = 0; i < len; ++i) {
                        Object convertedGeneric;
                        Object pageGeneric = pages.getGeneric(i);
                        if (pageGeneric instanceof String || pageGeneric instanceof ListType) {
                            convertedGeneric = MCTypeRegistry.TEXT_COMPONENT.convert(pageGeneric, fromVersion, toVersion);
                            if (convertedGeneric == null) continue;
                            pages.setGeneric(i, convertedGeneric);
                            continue;
                        }
                        if (!(pageGeneric instanceof MapType)) continue;
                        MapType mapType = (MapType)pageGeneric;
                        if (mapType.hasKey("raw") || mapType.hasKey("filtered")) {
                            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, mapType, "raw", fromVersion, toVersion);
                            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, mapType, "filtered", fromVersion, toVersion);
                            continue;
                        }
                        convertedGeneric = MCTypeRegistry.TEXT_COMPONENT.convert(pageGeneric, fromVersion, toVersion);
                        if (convertedGeneric == null) continue;
                        pages.setGeneric(i, convertedGeneric);
                    }
                }
                return null;
            }
        });
    }

    private V4307() {
    }
}

