/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V4309 {
    private static final int VERSION = 4309;

    public static int[] makeBlockPosition(Number x, Number y, Number z) {
        return new int[]{x.intValue(), y.intValue(), z.intValue()};
    }

    public static void convertBlockPosition(MapType data, String xPath, String yPath, String zPath, String toPath) {
        Number x = data.getNumber(xPath);
        Number y = data.getNumber(yPath);
        Number z = data.getNumber(zPath);
        if (x == null || y == null || z == null) {
            return;
        }
        data.remove(xPath);
        data.remove(yPath);
        data.remove(zPath);
        data.setInts(toPath, V4309.makeBlockPosition(x, y, z));
    }

    public static void register() {
        MCTypeRegistry.SAVED_DATA_RAIDS.addStructureConverter(new DataConverter<MapType, MapType>(4309){

            @Override
            public MapType convert(MapType root, long sourceVersion, long toVersion) {
                MapType data = root.getMap("data");
                if (data == null) {
                    return null;
                }
                RenameHelper.renameSingle(data, "Raids", "raids");
                RenameHelper.renameSingle(data, "Tick", "tick");
                RenameHelper.renameSingle(data, "NextAvailableID", "next_id");
                ListType raids = data.getListUnchecked("raids");
                if (raids != null) {
                    int len = raids.size();
                    for (int i = 0; i < len; ++i) {
                        MapType raid = raids.getMap(i, null);
                        if (raid == null) continue;
                        V4309.convertBlockPosition(raid, "CX", "CY", "CZ", "center");
                        RenameHelper.renameSingle(raid, "Id", "id");
                        RenameHelper.renameSingle(raid, "Started", "started");
                        RenameHelper.renameSingle(raid, "Active", "active");
                        RenameHelper.renameSingle(raid, "TicksActive", "ticks_active");
                        RenameHelper.renameSingle(raid, "BadOmenLevel", "raid_omen_level");
                        RenameHelper.renameSingle(raid, "GroupsSpawned", "groups_spawned");
                        RenameHelper.renameSingle(raid, "PreRaidTicks", "cooldown_ticks");
                        RenameHelper.renameSingle(raid, "PostRaidTicks", "post_raid_ticks");
                        RenameHelper.renameSingle(raid, "TotalHealth", "total_health");
                        RenameHelper.renameSingle(raid, "NumGroups", "group_count");
                        RenameHelper.renameSingle(raid, "Status", "status");
                        RenameHelper.renameSingle(raid, "HeroesOfTheVillage", "heroes_of_the_village");
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.SAVED_DATA_TICKETS.addStructureConverter(new DataConverter<MapType, MapType>(4309){

            @Override
            public MapType convert(MapType root, long sourceVersion, long toVersion) {
                MapType data = root.getMap("data");
                if (data == null) {
                    return null;
                }
                ListType tickets = data.getListUnchecked("tickets");
                if (tickets == null) {
                    return null;
                }
                int len = tickets.size();
                for (int i = 0; i < len; ++i) {
                    MapType ticket = tickets.getMap(i, null);
                    if (ticket == null || !ticket.hasKey("chunk_pos")) continue;
                    long coordinate = ticket.getLong("chunk_pos", 0L);
                    ticket.setInts("chunk_pos", new int[]{(int)coordinate, (int)(coordinate >>> 32)});
                }
                return null;
            }
        });
    }

    private V4309() {
    }
}

