/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import net.minecraft.util.Mth;

public final class V4658 {
    private static final int VERSION = 4658;

    public static void register() {
        MCTypeRegistry.LEVEL.addStructureConverter(new DataConverter<MapType, MapType>(4658){

            private static void convertBool(MapType data, String src, String dst) {
                if (!data.hasKey(src)) {
                    return;
                }
                String value = data.getString(src, "");
                data.remove(src);
                data.setBoolean(dst, Boolean.parseBoolean(value));
            }

            private static void convertBoolInv(MapType data, String src, String dst) {
                if (!data.hasKey(src)) {
                    return;
                }
                String value = data.getString(src, "");
                data.remove(src);
                data.setBoolean(dst, !Boolean.parseBoolean(value));
            }

            private static void convertInt(MapType data, String src, String dst) {
                1.convertInt(data, src, dst, Integer.MIN_VALUE);
            }

            private static void convertInt(MapType data, String src, String dst, int min) {
                1.convertInt(data, src, dst, min, Integer.MAX_VALUE);
            }

            private static void convertInt(MapType data, String src, String dst, int min, int max) {
                if (!data.hasKey(src)) {
                    return;
                }
                String value = data.getString(src, "");
                data.remove(src);
                try {
                    data.setInt(dst, Mth.clamp(Integer.parseInt(value), min, max));
                }
                catch (NumberFormatException ex) {
                    data.setString(dst, value);
                }
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                RenameHelper.renameSingle(data, "GameRules", "game_rules");
                MapType gameRules = data.getMap("game_rules");
                if (gameRules == null) {
                    return null;
                }
                boolean doFireTick = Boolean.parseBoolean(gameRules.getString("doFireTick", "true"));
                boolean allowFireTicksAwayFromPlayer = Boolean.parseBoolean(gameRules.getString("allowFireTicksAwayFromPlayer", "false"));
                gameRules.remove("spawnChunkRadius");
                gameRules.remove("entitiesWithPassengersCanUsePortals");
                gameRules.remove("doFireTick");
                gameRules.remove("allowFireTicksAwayFromPlayer");
                if (!doFireTick) {
                    gameRules.setInt("minecraft:fire_spread_radius_around_player", 0);
                } else if (allowFireTicksAwayFromPlayer) {
                    gameRules.setInt("minecraft:fire_spread_radius_around_player", -1);
                }
                1.convertBool(gameRules, "allowEnteringNetherUsingPortals", "minecraft:allow_entering_nether_using_portals");
                1.convertBool(gameRules, "announceAdvancements", "minecraft:show_advancement_messages");
                1.convertBool(gameRules, "blockExplosionDropDecay", "minecraft:block_explosion_drop_decay");
                1.convertBool(gameRules, "commandBlockOutput", "minecraft:command_block_output");
                1.convertBool(gameRules, "enableCommandBlocks", "minecraft:command_blocks_work");
                1.convertBool(gameRules, "commandBlocksEnabled", "minecraft:command_blocks_work");
                1.convertInt(gameRules, "commandModificationBlockLimit", "minecraft:max_block_modifications", 1);
                1.convertBoolInv(gameRules, "disableElytraMovementCheck", "minecraft:elytra_movement_check");
                1.convertBoolInv(gameRules, "disablePlayerMovementCheck", "minecraft:player_movement_check");
                1.convertBoolInv(gameRules, "disableRaids", "minecraft:raids");
                1.convertBool(gameRules, "doDaylightCycle", "minecraft:advance_time");
                1.convertBool(gameRules, "doEntityDrops", "minecraft:entity_drops");
                1.convertBool(gameRules, "doImmediateRespawn", "minecraft:immediate_respawn");
                1.convertBool(gameRules, "doInsomnia", "minecraft:spawn_phantoms");
                1.convertBool(gameRules, "doLimitedCrafting", "minecraft:limited_crafting");
                1.convertBool(gameRules, "doMobLoot", "minecraft:mob_drops");
                1.convertBool(gameRules, "doMobSpawning", "minecraft:spawn_mobs");
                1.convertBool(gameRules, "doPatrolSpawning", "minecraft:spawn_patrols");
                1.convertBool(gameRules, "doTileDrops", "minecraft:block_drops");
                1.convertBool(gameRules, "doTraderSpawning", "minecraft:spawn_wandering_traders");
                1.convertBool(gameRules, "doVinesSpread", "minecraft:spread_vines");
                1.convertBool(gameRules, "doWardenSpawning", "minecraft:spawn_wardens");
                1.convertBool(gameRules, "doWeatherCycle", "minecraft:advance_weather");
                1.convertBool(gameRules, "drowningDamage", "minecraft:drowning_damage");
                1.convertBool(gameRules, "enderPearlsVanishOnDeath", "minecraft:ender_pearls_vanish_on_death");
                1.convertBool(gameRules, "fallDamage", "minecraft:fall_damage");
                1.convertBool(gameRules, "fireDamage", "minecraft:fire_damage");
                1.convertBool(gameRules, "forgiveDeadPlayers", "minecraft:forgive_dead_players");
                1.convertBool(gameRules, "freezeDamage", "minecraft:freeze_damage");
                1.convertBool(gameRules, "globalSoundEvents", "minecraft:global_sound_events");
                1.convertBool(gameRules, "keepInventory", "minecraft:keep_inventory");
                1.convertBool(gameRules, "lavaSourceConversion", "minecraft:lava_source_conversion");
                1.convertBool(gameRules, "locatorBar", "minecraft:locator_bar");
                1.convertBool(gameRules, "logAdminCommands", "minecraft:log_admin_commands");
                1.convertInt(gameRules, "maxCommandChainLength", "minecraft:max_command_sequence_length", 0);
                1.convertInt(gameRules, "maxCommandForkCount", "minecraft:max_command_forks", 0);
                1.convertInt(gameRules, "maxEntityCramming", "minecraft:max_entity_cramming", 0);
                1.convertInt(gameRules, "minecartMaxSpeed", "minecraft:max_minecart_speed");
                1.convertBool(gameRules, "mobExplosionDropDecay", "minecraft:mob_explosion_drop_decay");
                1.convertBool(gameRules, "mobGriefing", "minecraft:mob_griefing");
                1.convertBool(gameRules, "naturalRegeneration", "minecraft:natural_health_regeneration");
                1.convertInt(gameRules, "playersNetherPortalCreativeDelay", "minecraft:players_nether_portal_creative_delay", 0);
                1.convertInt(gameRules, "playersNetherPortalDefaultDelay", "minecraft:players_nether_portal_default_delay", 0);
                1.convertInt(gameRules, "playersSleepingPercentage", "minecraft:players_sleeping_percentage", 0);
                1.convertBool(gameRules, "projectilesCanBreakBlocks", "minecraft:projectiles_can_break_blocks");
                1.convertBool(gameRules, "pvp", "minecraft:pvp");
                1.convertInt(gameRules, "randomTickSpeed", "minecraft:random_tick_speed", 0);
                1.convertBool(gameRules, "reducedDebugInfo", "minecraft:reduced_debug_info");
                1.convertBool(gameRules, "sendCommandFeedback", "minecraft:send_command_feedback");
                1.convertBool(gameRules, "showDeathMessages", "minecraft:show_death_messages");
                1.convertInt(gameRules, "snowAccumulationHeight", "minecraft:max_snow_accumulation_height", 0, 8);
                1.convertBool(gameRules, "spawnMonsters", "minecraft:spawn_monsters");
                1.convertInt(gameRules, "spawnRadius", "minecraft:respawn_radius");
                1.convertBool(gameRules, "spawnerBlocksEnabled", "minecraft:spawner_blocks_work");
                1.convertBool(gameRules, "spectatorsGenerateChunks", "minecraft:spectators_generate_chunks");
                1.convertBool(gameRules, "tntExplodes", "minecraft:tnt_explodes");
                1.convertBool(gameRules, "tntExplosionDropDecay", "minecraft:tnt_explosion_drop_decay");
                1.convertBool(gameRules, "universalAnger", "minecraft:universal_anger");
                1.convertBool(gameRules, "waterSourceConversion", "minecraft:water_source_conversion");
                return null;
            }
        });
    }

    private V4658() {
    }
}

