/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V702 {
    private static final int VERSION = 702;

    public static void register() {
        MCTypeRegistry.ENTITY.addConverterForId("Zombie", new DataConverter<MapType, MapType>(702){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                int zombieType = data.getInt("ZombieType");
                data.remove("ZombieType");
                switch (zombieType) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        data.setString("id", "ZombieVillager");
                        data.setInt("Profession", zombieType - 1);
                        break;
                    }
                    case 6: {
                        data.setString("id", "Husk");
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addWalker(702, "ZombieVillager", (root, fromVersion, toVersion) -> {
            WalkerUtils.convertList(MCTypeRegistry.VILLAGER_TRADE, root.getMap("Offers"), "Recipes", fromVersion, toVersion);
            return null;
        });
    }

    private V702() {
    }
}

