/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;

public enum ObjectType {
    NONE(null),
    BYTE(Byte.class),
    SHORT(Short.class),
    INT(Integer.class),
    LONG(Long.class),
    FLOAT(Float.class),
    DOUBLE(Double.class),
    NUMBER(Number.class),
    BYTE_ARRAY(byte[].class),
    SHORT_ARRAY(short[].class),
    INT_ARRAY(int[].class),
    LONG_ARRAY(long[].class),
    LIST(ListType.class),
    MAP(MapType.class),
    STRING(String.class),
    UNDEFINED(null),
    MIXED(null);

    private final Class<?> clazz;
    private final boolean isNumber;

    private ObjectType(Class<?> clazz) {
        this.clazz = clazz;
        this.isNumber = clazz != null && Number.class.isAssignableFrom(clazz);
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public Class<?> getObjectClass() {
        return this.clazz;
    }

    public static ObjectType getType(Object object) {
        if (object instanceof Number) {
            if (object instanceof Byte) {
                return BYTE;
            }
            if (object instanceof Short) {
                return SHORT;
            }
            if (object instanceof Integer) {
                return INT;
            }
            if (object instanceof Long) {
                return LONG;
            }
            if (object instanceof Float) {
                return FLOAT;
            }
            if (object instanceof Double) {
                return DOUBLE;
            }
        } else {
            if (object instanceof MapType) {
                return MAP;
            }
            if (object instanceof ListType) {
                return LIST;
            }
            if (object instanceof String) {
                return STRING;
            }
            if (object.getClass().isArray()) {
                if (object instanceof byte[]) {
                    return BYTE_ARRAY;
                }
                if (object instanceof short[]) {
                    return SHORT_ARRAY;
                }
                if (object instanceof int[]) {
                    return INT_ARRAY;
                }
                if (object instanceof long[]) {
                    return LONG_ARRAY;
                }
            }
        }
        return null;
    }
}

