/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.nbt;

import ca.spottedleaf.dataconverter.minecraft.converters.helpers.CopyHelper;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.nbt.NBTListType;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTTypeUtil
implements TypeUtil<Tag> {
    @Override
    public ListType createEmptyList() {
        return new NBTListType();
    }

    @Override
    public MapType createEmptyMap() {
        return new NBTMapType();
    }

    @Override
    public Object convertTo(Object valueGeneric, TypeUtil<?> to) {
        if (valueGeneric == null || valueGeneric instanceof String || valueGeneric instanceof Boolean) {
            return valueGeneric;
        }
        if (valueGeneric instanceof Number) {
            Number number = (Number)valueGeneric;
            if (CopyHelper.sanitizeNumber(number) == null) {
                throw new IllegalStateException("Unknown type: " + String.valueOf(number));
            }
            return number;
        }
        if (valueGeneric instanceof NBTListType) {
            NBTListType listType = (NBTListType)valueGeneric;
            return NBTTypeUtil.convertNBT(to, listType.list);
        }
        if (valueGeneric instanceof NBTMapType) {
            NBTMapType mapType = (NBTMapType)valueGeneric;
            return NBTTypeUtil.convertNBT(to, mapType.map);
        }
        throw new IllegalStateException("Unknown type: " + String.valueOf(valueGeneric));
    }

    @Override
    public Object convertFromBaseToGeneric(Tag input, TypeUtil<?> to) {
        return NBTTypeUtil.convertNBTToGeneric(to, input);
    }

    @Override
    public Object baseToGeneric(Tag input) {
        Tag tag = input;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompoundTag.class, ListTag.class, EndTag.class, StringTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class, NumericTag.class}, (Object)tag, n)) {
            case 0 -> {
                CompoundTag ct = (CompoundTag)tag;
                yield new NBTMapType(ct);
            }
            case 1 -> {
                ListTag lt = (ListTag)tag;
                yield new NBTListType(lt);
            }
            case 2 -> {
                EndTag endTag = (EndTag)tag;
                yield null;
            }
            case 3 -> {
                StringTag st = (StringTag)tag;
                yield st.value();
            }
            case 4 -> {
                ByteArrayTag bt = (ByteArrayTag)tag;
                yield bt.getAsByteArray();
            }
            case 5 -> {
                IntArrayTag it = (IntArrayTag)tag;
                yield it.getAsIntArray();
            }
            case 6 -> {
                LongArrayTag lt = (LongArrayTag)tag;
                yield lt.getAsLongArray();
            }
            case 7 -> {
                NumericTag nt = (NumericTag)tag;
                yield nt.box();
            }
            case -1 -> null;
            default -> throw new IllegalStateException("Unknown tag: " + String.valueOf(input));
        };
    }

    @Override
    public Tag genericToBase(Object input) {
        Object object = input;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTMapType.class, NBTListType.class, String.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, byte[].class, int[].class, long[].class}, (Object)object, n)) {
            case -1 -> EndTag.INSTANCE;
            case 0 -> {
                NBTMapType mapType = (NBTMapType)object;
                yield mapType.map;
            }
            case 1 -> {
                NBTListType listType = (NBTListType)object;
                yield listType.list;
            }
            case 2 -> {
                String string = (String)object;
                yield StringTag.valueOf(string);
            }
            case 3 -> {
                Boolean bool = (Boolean)object;
                yield ByteTag.valueOf(bool);
            }
            case 4 -> {
                Byte b = (Byte)object;
                yield ByteTag.valueOf(b);
            }
            case 5 -> {
                Short s = (Short)object;
                yield ShortTag.valueOf(s);
            }
            case 6 -> {
                Integer i = (Integer)object;
                yield IntTag.valueOf(i);
            }
            case 7 -> {
                Long l = (Long)object;
                yield LongTag.valueOf(l);
            }
            case 8 -> {
                byte[] bytes = (byte[])object;
                yield new ByteArrayTag(bytes);
            }
            case 9 -> {
                int[] ints = (int[])object;
                yield new IntArrayTag(ints);
            }
            case 10 -> {
                long[] longs = (long[])object;
                yield new LongArrayTag(longs);
            }
            default -> throw new IllegalStateException("Unrecognized type " + String.valueOf(input));
        };
    }

    private static Object convertNBTToGeneric(TypeUtil<?> to, Tag nbt) {
        Tag tag = nbt;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompoundTag.class, ListTag.class, EndTag.class, StringTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class, NumericTag.class}, (Object)tag, n)) {
            case 0 -> {
                CompoundTag ct = (CompoundTag)tag;
                yield NBTTypeUtil.convertNBT(to, ct);
            }
            case 1 -> {
                ListTag lt = (ListTag)tag;
                yield NBTTypeUtil.convertNBT(to, lt);
            }
            case 2 -> {
                EndTag endTag = (EndTag)tag;
                yield null;
            }
            case 3 -> {
                StringTag st = (StringTag)tag;
                yield st.value();
            }
            case 4 -> {
                ByteArrayTag bt = (ByteArrayTag)tag;
                yield bt.getAsByteArray();
            }
            case 5 -> {
                IntArrayTag it = (IntArrayTag)tag;
                yield it.getAsIntArray();
            }
            case 6 -> {
                LongArrayTag lt = (LongArrayTag)tag;
                yield lt.getAsLongArray();
            }
            case 7 -> {
                NumericTag nt = (NumericTag)tag;
                yield nt.box();
            }
            case -1 -> null;
            default -> throw new IllegalStateException("Unknown tag: " + String.valueOf(nbt));
        };
    }

    public static MapType convertNBT(TypeUtil<?> to, CompoundTag nbt) {
        MapType ret = to.createEmptyMap();
        for (String key : nbt.keySet()) {
            ret.setGeneric(key, NBTTypeUtil.convertNBTToGeneric(to, nbt.get(key)));
        }
        return ret;
    }

    public static ListType convertNBT(TypeUtil<?> to, ListTag nbt) {
        ListType ret = to.createEmptyList();
        int len = nbt.size();
        for (int i = 0; i < len; ++i) {
            ret.addGeneric(NBTTypeUtil.convertNBTToGeneric(to, nbt.get(i)));
        }
        return ret;
    }
}

