/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.list;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;

public final class IntList {
    private final Int2IntOpenHashMap map = new Int2IntOpenHashMap();
    private static final int[] EMPTY_LIST = new int[0];
    private int[] byIndex;
    private int count;

    public IntList() {
        this.map.defaultReturnValue(Integer.MIN_VALUE);
        this.byIndex = EMPTY_LIST;
    }

    public int size() {
        return this.count;
    }

    public void setMinCapacity(int len) {
        if (len <= 0) {
            return;
        }
        int[] byIndex = this.byIndex;
        if (byIndex.length < len) {
            this.byIndex = Arrays.copyOf(byIndex, len);
        }
        this.map.ensureCapacity(len);
    }

    public int getRaw(int index) {
        return this.byIndex[index];
    }

    public boolean add(int value) {
        int count = this.count;
        int currIndex = this.map.putIfAbsent(value, count);
        if (currIndex != Integer.MIN_VALUE) {
            return false;
        }
        int[] list = this.byIndex;
        if (list.length == count) {
            list = this.byIndex = Arrays.copyOf(list, (int)Math.max(4L, (long)count * 2L));
        }
        list[count] = value;
        this.count = count + 1;
        return true;
    }

    public boolean remove(int value) {
        int index = this.map.remove(value);
        if (index == Integer.MIN_VALUE) {
            return false;
        }
        int endIndex = --this.count;
        int end = this.byIndex[endIndex];
        if (index != endIndex) {
            this.map.put(end, index);
        }
        this.byIndex[index] = end;
        this.byIndex[endIndex] = 0;
        return true;
    }

    public void clear() {
        this.count = 0;
        this.map.clear();
    }
}

