/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.time;

public final class Schedule {
    private long lastPeriod;

    public Schedule(long firstPeriod) {
        this.lastPeriod = firstPeriod;
    }

    public void setLastPeriod(long value) {
        this.lastPeriod = value;
    }

    public long getLastPeriod() {
        return this.lastPeriod;
    }

    public long getPeriodsAhead(long periodLength, long time) {
        long difference = time - this.lastPeriod;
        long ret = Math.abs(difference) / periodLength;
        return difference >= 0L ? ret : -ret;
    }

    public long getDeadline(long periodLength) {
        return this.lastPeriod + periodLength;
    }

    public void setNextPeriod(long nextPeriod, long periodLength) {
        this.lastPeriod = nextPeriod - periodLength;
    }

    public void advanceBy(long periods, long periodLength) {
        this.lastPeriod += periods * periodLength;
    }

    public void setPeriodsAhead(long periodsToBeAhead, long periodLength, long time) {
        long periodsAhead = this.getPeriodsAhead(periodLength, time);
        long periodsToAdd = periodsToBeAhead - periodsAhead;
        this.lastPeriod -= periodsToAdd * periodLength;
    }
}

