/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelCallback;

public final class ServerEntityLookup
extends EntityLookup {
    private static final Entity[] EMPTY_ENTITY_ARRAY = new Entity[0];
    private final ServerLevel serverWorld;
    public final ReferenceList<Entity> trackerEntities = new ReferenceList<Entity>(EMPTY_ENTITY_ARRAY);
    private static final TicketType ENDER_PEARL_TICKER = ChunkSystemTicketType.create("chunk_system:ender_pearl_ticker", null, 0L, 14);
    private final Long2IntOpenHashMap enderPearlChunkCount = new Long2IntOpenHashMap();
    private final boolean keepEnderPearlsTicking;

    public ServerEntityLookup(ServerLevel world, LevelCallback<Entity> worldCallback) {
        super(world, worldCallback);
        this.serverWorld = world;
        this.keepEnderPearlsTicking = PlatformHooks.get().addTicketForEnderPearls(world);
    }

    @Override
    protected Boolean blockTicketUpdates() {
        return this.serverWorld.moonrise$getChunkTaskScheduler().chunkHolderManager.blockTicketUpdates();
    }

    @Override
    protected void setBlockTicketUpdates(Boolean value) {
        this.serverWorld.moonrise$getChunkTaskScheduler().chunkHolderManager.unblockTicketUpdates(value);
    }

    @Override
    protected void checkThread(int chunkX, int chunkZ, String reason) {
        TickThread.ensureTickThread((Level)this.serverWorld, chunkX, chunkZ, reason);
    }

    @Override
    protected void checkThread(Entity entity, String reason) {
        TickThread.ensureTickThread(entity, reason);
    }

    @Override
    protected ChunkEntitySlices createEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        return this.serverWorld.moonrise$getChunkTaskScheduler().chunkHolderManager.getOrCreateEntityChunk(chunkX, chunkZ, transientChunk);
    }

    @Override
    protected void onEmptySlices(int chunkX, int chunkZ) {
    }

    @Override
    protected void entitySectionChangeCallback(Entity entity, int oldSectionX, int oldSectionY, int oldSectionZ, int newSectionX, int newSectionY, int newSectionZ) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.serverWorld.moonrise$getNearbyPlayers().tickPlayer(player);
        }
        if (entity instanceof ThrownEnderpearl) {
            ThrownEnderpearl enderpearl = (ThrownEnderpearl)entity;
            if (oldSectionX != newSectionX || oldSectionZ != newSectionZ) {
                this.removeEnderPearl(CoordinateUtils.getChunkKey(oldSectionX, oldSectionZ));
                this.addEnderPearl(CoordinateUtils.getChunkKey(newSectionX, newSectionZ));
            }
        }
        PlatformHooks.get().entityMove(entity, CoordinateUtils.getChunkSectionKey(oldSectionX, oldSectionY, oldSectionZ), CoordinateUtils.getChunkSectionKey(newSectionX, newSectionY, newSectionZ));
    }

    @Override
    protected void addEntityCallback(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.serverWorld.moonrise$getNearbyPlayers().addPlayer(player);
        }
        if (entity instanceof ThrownEnderpearl) {
            ThrownEnderpearl enderpearl = (ThrownEnderpearl)entity;
            this.addEnderPearl(CoordinateUtils.getChunkKey(enderpearl.chunkPosition()));
        }
        entity.registerScheduler();
    }

    @Override
    protected void removeEntityCallback(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.serverWorld.moonrise$getNearbyPlayers().removePlayer(player);
        }
        if (entity instanceof ThrownEnderpearl) {
            ThrownEnderpearl enderpearl = (ThrownEnderpearl)entity;
            this.removeEnderPearl(CoordinateUtils.getChunkKey(enderpearl.chunkPosition()));
        }
    }

    @Override
    protected void entityStartLoaded(Entity entity) {
        this.trackerEntities.add(entity);
    }

    @Override
    protected void entityEndLoaded(Entity entity) {
        this.trackerEntities.remove(entity);
    }

    @Override
    protected void entityStartTicking(Entity entity) {
    }

    @Override
    protected void entityEndTicking(Entity entity) {
    }

    @Override
    protected boolean screenEntity(Entity entity, boolean fromDisk, boolean event) {
        return PlatformHooks.get().screenEntity(this.serverWorld, entity, fromDisk, event);
    }

    private void addEnderPearl(long coordinate) {
        if (!this.keepEnderPearlsTicking) {
            return;
        }
        int oldCount = this.enderPearlChunkCount.addTo(coordinate, 1);
        if (oldCount != 0) {
            return;
        }
        this.serverWorld.moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAtLevel(ENDER_PEARL_TICKER, coordinate, 31, null);
    }

    private void removeEnderPearl(long coordinate) {
        if (!this.keepEnderPearlsTicking) {
            return;
        }
        int oldCount = this.enderPearlChunkCount.addTo(coordinate, -1);
        if (oldCount != 1) {
            return;
        }
        this.enderPearlChunkCount.remove(coordinate);
        this.serverWorld.moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(ENDER_PEARL_TICKER, coordinate, 31, null);
    }
}

