/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import com.destroystokyo.paper.entity.Pathfinder;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

public class PaperPathfinder
implements Pathfinder {
    private net.minecraft.world.entity.Mob entity;

    public PaperPathfinder(net.minecraft.world.entity.Mob entity) {
        this.entity = entity;
    }

    public Mob getEntity() {
        return (Mob)this.entity.getBukkitEntity();
    }

    public void setHandle(net.minecraft.world.entity.Mob entity) {
        this.entity = entity;
    }

    public void stopPathfinding() {
        this.entity.getNavigation().stop();
    }

    public boolean hasPath() {
        return this.entity.getNavigation().getPath() != null && !this.entity.getNavigation().getPath().isDone();
    }

    @Nullable
    public Pathfinder.PathResult getCurrentPath() {
        Path path = this.entity.getNavigation().getPath();
        return path != null && !path.isDone() ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location can not be null");
        Path path = this.entity.getNavigation().createPath(loc.getX(), loc.getY(), loc.getZ(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(LivingEntity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target can not be null");
        Path path = this.entity.getNavigation().createPath(((CraftLivingEntity)target).getHandle(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    public boolean moveTo(@Nonnull Pathfinder.PathResult path, double speed) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"PathResult can not be null");
        Path pathEntity = ((PaperPathResult)path).path;
        return this.entity.getNavigation().moveTo(pathEntity, speed);
    }

    public boolean canOpenDoors() {
        return this.entity.getNavigation().pathFinder.nodeEvaluator.canOpenDoors();
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.entity.getNavigation().pathFinder.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.entity.getNavigation().pathFinder.nodeEvaluator.canPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.entity.getNavigation().pathFinder.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canFloat() {
        return this.entity.getNavigation().pathFinder.nodeEvaluator.canFloat();
    }

    public void setCanFloat(boolean canFloat) {
        this.entity.getNavigation().pathFinder.nodeEvaluator.setCanFloat(canFloat);
    }

    public class PaperPathResult
    implements Pathfinder.PathResult {
        private final Path path;

        PaperPathResult(Path path) {
            this.path = path;
        }

        @Nullable
        public Location getFinalPoint() {
            Node point = this.path.getEndNode();
            return point != null ? CraftLocation.toBukkit(point, PaperPathfinder.this.entity.level()) : null;
        }

        public boolean canReachFinalPoint() {
            return this.path.canReach();
        }

        public List<Location> getPoints() {
            ArrayList<Location> points = new ArrayList<Location>();
            for (Node point : this.path.nodes) {
                points.add(CraftLocation.toBukkit(point, PaperPathfinder.this.entity.level()));
            }
            return points;
        }

        public int getNextPointIndex() {
            return this.path.getNextNodeIndex();
        }

        @Nullable
        public Location getNextPoint() {
            if (this.path.isDone()) {
                return null;
            }
            return CraftLocation.toBukkit(this.path.nodes.get(this.path.getNextNodeIndex()), PaperPathfinder.this.entity.level());
        }
    }
}

