/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import com.destroystokyo.paper.entity.RangedEntity;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import com.google.common.base.CaseFormat;
import io.papermc.paper.entity.SchoolableFish;
import io.papermc.paper.util.MappingEnvironment;
import io.papermc.paper.util.ObfHelper;
import it.unimi.dsi.fastutil.ints.Int2BooleanFunction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Util;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.entity.animal.camel.CamelHusk;
import net.minecraft.world.entity.animal.chicken.Chicken;
import net.minecraft.world.entity.animal.cow.Cow;
import net.minecraft.world.entity.animal.dolphin.Dolphin;
import net.minecraft.world.entity.animal.equine.AbstractChestedHorse;
import net.minecraft.world.entity.animal.equine.Donkey;
import net.minecraft.world.entity.animal.equine.ZombieHorse;
import net.minecraft.world.entity.animal.feline.Cat;
import net.minecraft.world.entity.animal.feline.Ocelot;
import net.minecraft.world.entity.animal.fish.AbstractFish;
import net.minecraft.world.entity.animal.fish.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.fish.Pufferfish;
import net.minecraft.world.entity.animal.fish.WaterAnimal;
import net.minecraft.world.entity.animal.fox.Fox;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.golem.AbstractGolem;
import net.minecraft.world.entity.animal.golem.SnowGolem;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.nautilus.Nautilus;
import net.minecraft.world.entity.animal.parrot.Parrot;
import net.minecraft.world.entity.animal.parrot.ShoulderRidingEntity;
import net.minecraft.world.entity.animal.pig.Pig;
import net.minecraft.world.entity.animal.polarbear.PolarBear;
import net.minecraft.world.entity.animal.rabbit.Rabbit;
import net.minecraft.world.entity.animal.squid.GlowSquid;
import net.minecraft.world.entity.animal.squid.Squid;
import net.minecraft.world.entity.animal.turtle.Turtle;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.illager.AbstractIllager;
import net.minecraft.world.entity.monster.illager.Illusioner;
import net.minecraft.world.entity.monster.illager.SpellcasterIllager;
import net.minecraft.world.entity.monster.illager.Vindicator;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.skeleton.Bogged;
import net.minecraft.world.entity.monster.skeleton.Parched;
import net.minecraft.world.entity.monster.skeleton.Stray;
import net.minecraft.world.entity.monster.skeleton.WitherSkeleton;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.zombie.Husk;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.monster.zombie.ZombifiedPiglin;
import net.minecraft.world.entity.raid.Raider;
import org.apache.commons.lang3.math.NumberUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.AbstractCow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Camel;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Cod;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Creaking;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Illager;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.ZombieNautilus;
import org.bukkit.entity.ZombieVillager;

public class MobGoalHelper {
    private static final Map<Class<? extends Goal>, Class<? extends org.bukkit.entity.Mob>> GENERIC_TYPE_CACHE = new HashMap<Class<? extends Goal>, Class<? extends org.bukkit.entity.Mob>>();
    public static final Map<Class<? extends Mob>, Class<? extends org.bukkit.entity.Mob>> BUKKIT_BRIDGE = Util.make(new LinkedHashMap(), map -> {
        map.put(Mob.class, org.bukkit.entity.Mob.class);
        map.put(AgeableMob.class, Ageable.class);
        map.put(AmbientCreature.class, Ambient.class);
        map.put(Animal.class, Animals.class);
        map.put(net.minecraft.world.entity.ambient.Bat.class, Bat.class);
        map.put(Bee.class, org.bukkit.entity.Bee.class);
        map.put(net.minecraft.world.entity.monster.Blaze.class, Blaze.class);
        map.put(Cat.class, org.bukkit.entity.Cat.class);
        map.put(net.minecraft.world.entity.monster.spider.CaveSpider.class, CaveSpider.class);
        map.put(Chicken.class, org.bukkit.entity.Chicken.class);
        map.put(net.minecraft.world.entity.animal.fish.Cod.class, Cod.class);
        map.put(Cow.class, org.bukkit.entity.Cow.class);
        map.put(PathfinderMob.class, Creature.class);
        map.put(net.minecraft.world.entity.monster.Creeper.class, Creeper.class);
        map.put(Dolphin.class, org.bukkit.entity.Dolphin.class);
        map.put(net.minecraft.world.entity.monster.zombie.Drowned.class, Drowned.class);
        map.put(EnderDragon.class, org.bukkit.entity.EnderDragon.class);
        map.put(EnderMan.class, Enderman.class);
        map.put(net.minecraft.world.entity.monster.Endermite.class, Endermite.class);
        map.put(net.minecraft.world.entity.monster.illager.Evoker.class, Evoker.class);
        map.put(AbstractFish.class, Fish.class);
        map.put(AbstractSchoolingFish.class, SchoolableFish.class);
        map.put(Fox.class, org.bukkit.entity.Fox.class);
        map.put(net.minecraft.world.entity.monster.Ghast.class, Ghast.class);
        map.put(Giant.class, org.bukkit.entity.Giant.class);
        map.put(AbstractGolem.class, Golem.class);
        map.put(Guardian.class, org.bukkit.entity.Guardian.class);
        map.put(net.minecraft.world.entity.monster.ElderGuardian.class, ElderGuardian.class);
        map.put(net.minecraft.world.entity.animal.equine.Horse.class, Horse.class);
        map.put(net.minecraft.world.entity.animal.equine.AbstractHorse.class, AbstractHorse.class);
        map.put(AbstractChestedHorse.class, ChestedHorse.class);
        map.put(Donkey.class, org.bukkit.entity.Donkey.class);
        map.put(net.minecraft.world.entity.animal.equine.Mule.class, Mule.class);
        map.put(net.minecraft.world.entity.animal.equine.SkeletonHorse.class, SkeletonHorse.class);
        map.put(ZombieHorse.class, org.bukkit.entity.ZombieHorse.class);
        map.put(net.minecraft.world.entity.animal.camel.Camel.class, Camel.class);
        map.put(AbstractIllager.class, Illager.class);
        map.put(Illusioner.class, org.bukkit.entity.Illusioner.class);
        map.put(SpellcasterIllager.class, Spellcaster.class);
        map.put(net.minecraft.world.entity.animal.golem.IronGolem.class, IronGolem.class);
        map.put(net.minecraft.world.entity.animal.equine.Llama.class, Llama.class);
        map.put(net.minecraft.world.entity.animal.equine.TraderLlama.class, TraderLlama.class);
        map.put(net.minecraft.world.entity.monster.MagmaCube.class, MagmaCube.class);
        map.put(net.minecraft.world.entity.monster.Monster.class, Monster.class);
        map.put(PatrollingMonster.class, org.bukkit.entity.Raider.class);
        map.put(net.minecraft.world.entity.animal.cow.MushroomCow.class, MushroomCow.class);
        map.put(Ocelot.class, org.bukkit.entity.Ocelot.class);
        map.put(net.minecraft.world.entity.animal.panda.Panda.class, Panda.class);
        map.put(Parrot.class, org.bukkit.entity.Parrot.class);
        map.put(ShoulderRidingEntity.class, org.bukkit.entity.Parrot.class);
        map.put(Phantom.class, org.bukkit.entity.Phantom.class);
        map.put(Pig.class, org.bukkit.entity.Pig.class);
        map.put(ZombifiedPiglin.class, PigZombie.class);
        map.put(net.minecraft.world.entity.monster.illager.Pillager.class, Pillager.class);
        map.put(PolarBear.class, org.bukkit.entity.PolarBear.class);
        map.put(Pufferfish.class, PufferFish.class);
        map.put(Rabbit.class, org.bukkit.entity.Rabbit.class);
        map.put(Raider.class, org.bukkit.entity.Raider.class);
        map.put(Ravager.class, org.bukkit.entity.Ravager.class);
        map.put(net.minecraft.world.entity.animal.fish.Salmon.class, Salmon.class);
        map.put(net.minecraft.world.entity.animal.sheep.Sheep.class, Sheep.class);
        map.put(net.minecraft.world.entity.monster.Shulker.class, Shulker.class);
        map.put(net.minecraft.world.entity.monster.Silverfish.class, Silverfish.class);
        map.put(net.minecraft.world.entity.monster.skeleton.Skeleton.class, Skeleton.class);
        map.put(net.minecraft.world.entity.monster.skeleton.AbstractSkeleton.class, AbstractSkeleton.class);
        map.put(Stray.class, org.bukkit.entity.Stray.class);
        map.put(WitherSkeleton.class, org.bukkit.entity.WitherSkeleton.class);
        map.put(Slime.class, org.bukkit.entity.Slime.class);
        map.put(SnowGolem.class, Snowman.class);
        map.put(net.minecraft.world.entity.monster.spider.Spider.class, Spider.class);
        map.put(Squid.class, org.bukkit.entity.Squid.class);
        map.put(TamableAnimal.class, Tameable.class);
        map.put(net.minecraft.world.entity.animal.fish.TropicalFish.class, TropicalFish.class);
        map.put(Turtle.class, org.bukkit.entity.Turtle.class);
        map.put(net.minecraft.world.entity.monster.Vex.class, Vex.class);
        map.put(net.minecraft.world.entity.npc.villager.Villager.class, Villager.class);
        map.put(net.minecraft.world.entity.npc.villager.AbstractVillager.class, AbstractVillager.class);
        map.put(net.minecraft.world.entity.npc.wanderingtrader.WanderingTrader.class, WanderingTrader.class);
        map.put(Vindicator.class, org.bukkit.entity.Vindicator.class);
        map.put(WaterAnimal.class, WaterMob.class);
        map.put(net.minecraft.world.entity.monster.Witch.class, Witch.class);
        map.put(WitherBoss.class, Wither.class);
        map.put(Wolf.class, org.bukkit.entity.Wolf.class);
        map.put(Zombie.class, org.bukkit.entity.Zombie.class);
        map.put(Husk.class, org.bukkit.entity.Husk.class);
        map.put(net.minecraft.world.entity.monster.zombie.ZombieVillager.class, ZombieVillager.class);
        map.put(net.minecraft.world.entity.monster.hoglin.Hoglin.class, Hoglin.class);
        map.put(net.minecraft.world.entity.monster.piglin.Piglin.class, Piglin.class);
        map.put(AbstractPiglin.class, PiglinAbstract.class);
        map.put(PiglinBrute.class, org.bukkit.entity.PiglinBrute.class);
        map.put(Strider.class, org.bukkit.entity.Strider.class);
        map.put(net.minecraft.world.entity.monster.Zoglin.class, Zoglin.class);
        map.put(GlowSquid.class, org.bukkit.entity.GlowSquid.class);
        map.put(Axolotl.class, org.bukkit.entity.Axolotl.class);
        map.put(Goat.class, org.bukkit.entity.Goat.class);
        map.put(Frog.class, org.bukkit.entity.Frog.class);
        map.put(net.minecraft.world.entity.animal.frog.Tadpole.class, Tadpole.class);
        map.put(Warden.class, org.bukkit.entity.Warden.class);
        map.put(net.minecraft.world.entity.animal.allay.Allay.class, Allay.class);
        map.put(net.minecraft.world.entity.animal.sniffer.Sniffer.class, Sniffer.class);
        map.put(Breeze.class, org.bukkit.entity.Breeze.class);
        map.put(Armadillo.class, org.bukkit.entity.Armadillo.class);
        map.put(Bogged.class, org.bukkit.entity.Bogged.class);
        map.put(net.minecraft.world.entity.monster.creaking.Creaking.class, Creaking.class);
        map.put(AgeableWaterCreature.class, org.bukkit.entity.Squid.class);
        map.put(net.minecraft.world.entity.animal.cow.AbstractCow.class, AbstractCow.class);
        map.put(HappyGhast.class, org.bukkit.entity.HappyGhast.class);
        map.put(net.minecraft.world.entity.animal.golem.CopperGolem.class, CopperGolem.class);
        map.put(AbstractNautilus.class, org.bukkit.entity.AbstractNautilus.class);
        map.put(Nautilus.class, org.bukkit.entity.Nautilus.class);
        map.put(net.minecraft.world.entity.animal.nautilus.ZombieNautilus.class, ZombieNautilus.class);
        map.put(CamelHusk.class, org.bukkit.entity.CamelHusk.class);
        map.put(Parched.class, org.bukkit.entity.Parched.class);
    });
    private static final Map<String, String> RENAMES = Util.make(new HashMap(), map -> {
        map.put("AbstractSkeleton$1", "AbstractSkeletonMelee");
        map.put("TraderLlama$TraderLlamaDefendWanderingTraderGoal", "TraderLlamaDefendWanderingTraderGoal");
        map.put("AbstractIllager$RaiderOpenDoorGoal", "RaiderOpenDoorGoal");
    });
    private static final Set<Class<? extends org.bukkit.entity.Mob>> NO_SPECIFIER = Set.of(org.bukkit.entity.Mob.class, Creature.class, Animals.class, RangedEntity.class, Tameable.class, Monster.class, PufferFish.class);
    private static final Int2BooleanFunction[] VISIBILITY_SEARCH_STEP = new Int2BooleanFunction[]{Modifier::isPublic, Modifier::isProtected, mod -> (mod & 7) == 0, Modifier::isPrivate};
    private static final Comparator<Constructor<?>> VISIBILITY_ORDER = Comparator.comparingInt(constructor -> {
        int mod = constructor.getModifiers();
        for (int i = 0; i < VISIBILITY_SEARCH_STEP.length; ++i) {
            Int2BooleanFunction visibility = VISIBILITY_SEARCH_STEP[i];
            if (!visibility.test(mod)) continue;
            return i;
        }
        throw new UnsupportedOperationException("Unknown visibility: " + mod);
    });

    private static String getPathName(Class<? extends org.bukkit.entity.Mob> type, Class<?> holderClass, String name) {
        Object pathName = name.substring(name.lastIndexOf(46) + 1);
        boolean needRename = false;
        int firstInnerDelimiter = ((String)pathName).indexOf(36);
        if (firstInnerDelimiter != -1) {
            String innerClassNames = ((String)pathName).substring(firstInnerDelimiter + 1);
            for (String innerClassName : innerClassNames.split("\\$")) {
                if (!NumberUtils.isDigits((String)innerClassName)) continue;
                needRename = true;
                break;
            }
            if (!needRename && !RENAMES.containsKey(pathName)) {
                pathName = innerClassNames;
            }
        }
        if (!RENAMES.containsKey(pathName)) {
            if (needRename) {
                throw new IllegalStateException("need to map " + name + " (" + (String)pathName + ")");
            }
            String prefix = null;
            if (!NO_SPECIFIER.contains(type)) {
                prefix = type.getSimpleName();
            } else if (!Mob.class.isAssignableFrom(holderClass)) {
                prefix = holderClass.getSimpleName();
            }
            if (prefix != null && !((String)pathName).startsWith(prefix)) {
                pathName = prefix + (String)pathName;
            }
        } else {
            pathName = RENAMES.get(pathName);
        }
        pathName = ((String)pathName).replace("TargetGoal", "");
        pathName = ((String)pathName).replace("Goal", "");
        pathName = ((String)pathName).replace("Abstract", "");
        pathName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, (String)pathName);
        return pathName;
    }

    public static EnumSet<GoalType> vanillaToPaper(Goal goal) {
        EnumSet<GoalType> goals = EnumSet.noneOf(GoalType.class);
        for (GoalType type : GoalType.values()) {
            if (!goal.hasFlag(MobGoalHelper.paperToVanilla(type))) continue;
            goals.add(type);
        }
        return goals;
    }

    public static GoalType vanillaToPaper(Goal.Flag type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Goal.Flag.MOVE -> GoalType.MOVE;
            case Goal.Flag.LOOK -> GoalType.LOOK;
            case Goal.Flag.JUMP -> GoalType.JUMP;
            case Goal.Flag.UNKNOWN_BEHAVIOR -> GoalType.UNKNOWN_BEHAVIOR;
            case Goal.Flag.TARGET -> GoalType.TARGET;
        };
    }

    public static EnumSet<Goal.Flag> paperToVanilla(EnumSet<GoalType> types) {
        EnumSet<Goal.Flag> goals = EnumSet.noneOf(Goal.Flag.class);
        for (GoalType type : types) {
            goals.add(MobGoalHelper.paperToVanilla(type));
        }
        return goals;
    }

    public static Goal.Flag paperToVanilla(GoalType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case GoalType.MOVE -> Goal.Flag.MOVE;
            case GoalType.LOOK -> Goal.Flag.LOOK;
            case GoalType.JUMP -> Goal.Flag.JUMP;
            case GoalType.UNKNOWN_BEHAVIOR -> Goal.Flag.UNKNOWN_BEHAVIOR;
            case GoalType.TARGET -> Goal.Flag.TARGET;
        };
    }

    public static <T extends org.bukkit.entity.Mob> GoalKey<T> getKey(Class<? extends Goal> goalClass) {
        Class<T> type = MobGoalHelper.getGenericType(goalClass);
        String name = goalClass.getName();
        if (MappingEnvironment.reobf()) {
            name = ObfHelper.INSTANCE.deobfClassName(name);
        }
        Class<?> holderClass = MobGoalHelper.getTopLevelClass(goalClass);
        name = MobGoalHelper.getPathName(type, holderClass, name);
        return GoalKey.of(type, (NamespacedKey)NamespacedKey.minecraft((String)name));
    }

    private static <T extends org.bukkit.entity.Mob> Class<T> getGenericType(Class<? extends Goal> goalClass) {
        return GENERIC_TYPE_CACHE.computeIfAbsent(goalClass, key -> {
            Constructor<?>[] constructors = key.getDeclaredConstructors();
            Arrays.sort(constructors, VISIBILITY_ORDER);
            for (Constructor<?> constructor : constructors) {
                for (Class<?> paramType : constructor.getParameterTypes()) {
                    if (Mob.class.isAssignableFrom(paramType)) {
                        return MobGoalHelper.toBukkitClass(paramType);
                    }
                    if (!RangedAttackMob.class.isAssignableFrom(paramType)) continue;
                    return RangedEntity.class;
                }
            }
            throw new RuntimeException("Can't figure out applicable entity for mob goal " + String.valueOf(goalClass));
        });
    }

    private static Class<?> getTopLevelClass(Class<?> clazz) {
        Class<?> topLevelClass = clazz;
        Class<?> upperClass = clazz;
        while ((upperClass = upperClass.getEnclosingClass()) != null) {
            topLevelClass = upperClass;
        }
        return topLevelClass;
    }

    public static Class<? extends org.bukkit.entity.Mob> toBukkitClass(Class<? extends Mob> internalClass) {
        Class<? extends org.bukkit.entity.Mob> bukkitClass = BUKKIT_BRIDGE.get(internalClass);
        if (bukkitClass == null) {
            throw new RuntimeException("Can't figure out applicable bukkit entity for internal entity " + String.valueOf(internalClass));
        }
        return bukkitClass;
    }
}

