/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.gui;

import com.destroystokyo.paper.gui.GraphData;
import com.destroystokyo.paper.gui.RAMGraph;
import java.awt.Dimension;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.Util;

public class RAMDetails
extends JList<String> {
    public static final DecimalFormat DECIMAL_FORMAT = Util.make(new DecimalFormat("########0.000"), format -> format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private final MinecraftServer server;

    public RAMDetails(MinecraftServer server) {
        this.server = server;
        this.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.setFixedCellHeight(20);
        this.setOpaque(false);
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        renderer.setOpaque(false);
        this.setCellRenderer(renderer);
        this.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setAnchorSelectionIndex(int anchorIndex) {
            }

            @Override
            public void setLeadAnchorNotificationEnabled(boolean flag) {
            }

            @Override
            public void setLeadSelectionIndex(int leadIndex) {
            }

            @Override
            public void setSelectionInterval(int index0, int index1) {
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(350, 100);
    }

    public void update() {
        GraphData data = RAMGraph.DATA.peekLast();
        Vector<CallSite> vector = new Vector<CallSite>();
        double[] tps = this.server.getTPS();
        CharSequence[] tpsAvg = new String[tps.length];
        for (int g = 0; g < tps.length; ++g) {
            tpsAvg[g] = RAMDetails.format(tps[g]);
        }
        vector.add((CallSite)((Object)("Memory use: " + data.getUsedMem() / 1024L / 1024L + " mb (" + data.getFree() * 100L / data.getMax() + "% free)")));
        vector.add((CallSite)((Object)("Heap: " + data.getTotal() / 1024L / 1024L + " / " + data.getMax() / 1024L / 1024L + " mb")));
        vector.add((CallSite)((Object)("Avg tick: " + DECIMAL_FORMAT.format((double)this.server.getAverageTickTimeNanos() / (double)TimeUtil.NANOSECONDS_PER_MILLISECOND) + " ms")));
        vector.add((CallSite)((Object)("TPS from last 1m, 5m, 15m: " + String.join((CharSequence)", ", tpsAvg))));
        this.setListData(vector);
    }

    private static String format(double tps) {
        return (tps > 21.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }
}

