/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.command.PaperSubcommand;
import io.papermc.paper.command.subcommands.ChunkDebugCommand;
import io.papermc.paper.command.subcommands.FixLightCommand;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.monster.spider.Spider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.Strategy;
import org.bukkit.Chunk;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public final class FeatureHooks {
    public static Iterable<net.minecraft.world.entity.Entity> getAllEntities(ServerLevel world) {
        return ((EntityLookup)world.getEntities()).getAllMapped();
    }

    public static void setPlayerChunkUnloadDelay(long ticks) {
        RegionizedPlayerChunkLoader.setUnloadDelay(ticks);
    }

    public static void registerPaperCommands(Map<Set<String>, PaperSubcommand> commands) {
        commands.put(Set.of("fixlight"), new FixLightCommand());
        commands.put(Set.of("debug", "chunkinfo", "holderinfo"), new ChunkDebugCommand());
    }

    public static LevelChunkSection createSection(PalettedContainerFactory palettedContainerFactory, Level level, ChunkPos chunkPos, int chunkSection) {
        return new LevelChunkSection(palettedContainerFactory, level, chunkPos, chunkSection);
    }

    public static void sendChunkRefreshPackets(List<ServerPlayer> playersInRange, LevelChunk chunk) {
        HashMap<Object, ClientboundLevelChunkWithLightPacket> refreshPackets = new HashMap<Object, ClientboundLevelChunkWithLightPacket>();
        for (ServerPlayer player : playersInRange) {
            if (player.connection == null) continue;
            Boolean shouldModify = chunk.getLevel().chunkPacketBlockController.shouldModify(player, chunk);
            player.connection.send(refreshPackets.computeIfAbsent(shouldModify, s -> new ClientboundLevelChunkWithLightPacket(chunk, chunk.level.getLightEngine(), null, null, (Boolean)s)));
        }
    }

    public static PalettedContainer<BlockState> emptyPalettedBlockContainer() {
        return new PalettedContainer<BlockState>(Blocks.AIR.defaultBlockState(), Strategy.createForBlockStates(Block.BLOCK_STATE_REGISTRY), null);
    }

    public static Set<Long> getSentChunkKeys(ServerPlayer player) {
        return LongSets.unmodifiable((LongSet)player.moonrise$getChunkLoader().getSentChunksRaw().clone());
    }

    public static Set<Chunk> getSentChunks(ServerPlayer player) {
        if (player.moonrise$getChunkLoader() == null) {
            return ObjectSets.EMPTY_SET;
        }
        LongOpenHashSet rawChunkKeys = player.moonrise$getChunkLoader().getSentChunksRaw();
        ObjectOpenHashSet chunks = new ObjectOpenHashSet(rawChunkKeys.size());
        CraftWorld world = player.level().getWorld();
        LongIterator iter = player.moonrise$getChunkLoader().getSentChunksRaw().longIterator();
        while (iter.hasNext()) {
            chunks.add((Object)world.getChunkAt(iter.nextLong(), false));
        }
        return ObjectSets.unmodifiable((ObjectSet)chunks);
    }

    public static boolean isChunkSent(ServerPlayer player, long chunkKey) {
        return player.moonrise$getChunkLoader() != null && player.moonrise$getChunkLoader().getSentChunksRaw().contains(chunkKey);
    }

    public static boolean isSpiderCollidingWithWorldBorder(Spider spider) {
        return CollisionUtil.isCollidingWithBorder(spider.level().getWorldBorder(), spider.getBoundingBox().inflate(1.0E-7));
    }

    public static void dumpAllChunkLoadInfo(MinecraftServer server, boolean isLongTimeout) {
        ChunkTaskScheduler.dumpAllChunkLoadInfo(server, isLongTimeout);
    }

    private static void dumpEntity(net.minecraft.world.entity.Entity entity) {
    }

    public static Entity[] getChunkEntities(ServerLevel world, int chunkX, int chunkZ) {
        return world.getChunkEntities(chunkX, chunkZ);
    }

    public static Collection<Plugin> getPluginChunkTickets(ServerLevel world, int x, int z) {
        return world.moonrise$getChunkTaskScheduler().chunkHolderManager.getPluginChunkTickets(x, z);
    }

    public static Map<Plugin, Collection<Chunk>> getPluginChunkTickets(ServerLevel world) {
        HashMap<Plugin, ImmutableList.Builder> ret = new HashMap<Plugin, ImmutableList.Builder>();
        ChunkMap.DistanceManager chunkDistanceManager = world.getChunkSource().chunkMap.distanceManager;
        for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.moonrise$getChunkHolderManager().getTicketsCopy().long2ObjectEntrySet()) {
            long chunkKey = chunkTickets.getLongKey();
            Collection tickets = (Collection)chunkTickets.getValue();
            Chunk chunk = null;
            for (Ticket ticket : tickets) {
                if (ticket.getType() != TicketType.PLUGIN_TICKET) continue;
                if (chunk == null) {
                    chunk = world.getWorld().getChunkAt(ChunkPos.getX(chunkKey), ChunkPos.getZ(chunkKey));
                }
                ret.computeIfAbsent((Plugin)ticket.getIdentifier(), key -> ImmutableList.builder()).add((Object)chunk);
            }
        }
        return (Map)ret.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build()));
    }

    public static int getViewDistance(ServerLevel world) {
        return world.moonrise$getPlayerChunkLoader().getAPIViewDistance();
    }

    public static int getSimulationDistance(ServerLevel world) {
        return world.moonrise$getPlayerChunkLoader().getAPITickDistance();
    }

    public static int getSendViewDistance(ServerLevel world) {
        return world.moonrise$getPlayerChunkLoader().getAPISendViewDistance();
    }

    public static void setViewDistance(ServerLevel world, int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("View distance " + distance + " is out of range of [2, 32]");
        }
        world.chunkSource.chunkMap.setServerViewDistance(distance);
    }

    public static void setSimulationDistance(ServerLevel world, int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("Simulation distance " + distance + " is out of range of [2, 32]");
        }
        world.chunkSource.chunkMap.distanceManager.updateSimulationDistance(distance);
    }

    public static void setSendViewDistance(ServerLevel world, int distance) {
        world.chunkSource.setSendViewDistance(distance);
    }

    public static void tickEntityManager(ServerLevel world) {
    }

    public static void closeEntityManager(ServerLevel world, boolean save) {
    }

    public static Executor getWorldgenExecutor() {
        return Runnable::run;
    }

    public static void setViewDistance(ServerPlayer player, int distance) {
        player.moonrise$getViewDistanceHolder().setLoadViewDistance(distance == -1 ? distance : distance + 1);
    }

    public static void setSimulationDistance(ServerPlayer player, int distance) {
        player.moonrise$getViewDistanceHolder().setTickViewDistance(distance);
    }

    public static void setSendViewDistance(ServerPlayer player, int distance) {
        player.moonrise$getViewDistanceHolder().setSendViewDistance(distance);
    }
}

