/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.block.fluid;

import com.google.common.base.Preconditions;
import io.papermc.paper.block.fluid.FluidData;
import io.papermc.paper.block.fluid.type.PaperFallingFluidData;
import io.papermc.paper.block.fluid.type.PaperFlowingFluidData;
import net.minecraft.world.level.material.FluidState;
import org.bukkit.Fluid;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftFluid;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class PaperFluidData
implements FluidData {
    private final FluidState state;

    protected PaperFluidData(FluidState state) {
        this.state = state;
    }

    public FluidState getState() {
        return this.state;
    }

    @NotNull
    public final Fluid getFluidType() {
        return CraftFluid.minecraftToBukkit(this.state.getType());
    }

    @NotNull
    public PaperFluidData clone() {
        try {
            return (PaperFluidData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Clone not supported", ex);
        }
    }

    @NotNull
    public Vector computeFlowDirection(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot compute flow direction on world-less location");
        return CraftVector.toBukkit(this.state.getFlow(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toBlockPosition(location)));
    }

    public int getLevel() {
        return this.state.getAmount();
    }

    public float computeHeight(@NotNull Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot compute height on world-less location");
        return this.state.getHeight(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toBlockPosition(location));
    }

    public boolean isSource() {
        return this.state.isSource();
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PaperFluidData)) return false;
        PaperFluidData paperFluidData = (PaperFluidData)obj;
        if (!this.state.equals(paperFluidData.state)) return false;
        return true;
    }

    public String toString() {
        return "PaperFluidData{" + String.valueOf(this.state) + "}";
    }

    public static PaperFluidData createData(FluidState state) {
        if (state.isEmpty()) {
            return new PaperFluidData(state);
        }
        return state.isSource() ? new PaperFallingFluidData(state) : new PaperFlowingFluidData(state);
    }
}

