/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer.registry;

import com.google.common.base.Preconditions;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import io.papermc.paper.configuration.serializer.registry.RegistryEntrySerializer;
import java.lang.reflect.Type;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import org.spongepowered.configurate.serialize.SerializationException;

public final class RegistryHolderSerializer<T>
extends RegistryEntrySerializer<Holder<T>, T> {
    public RegistryHolderSerializer(TypeToken<T> typeToken, RegistryAccess registryAccess, ResourceKey<? extends Registry<T>> registryKey, boolean omitMinecraftNamespace) {
        super(TypeToken.get((Type)TypeFactory.parameterizedClass(Holder.class, (Type[])new Type[]{typeToken.getType()})), registryAccess, registryKey, omitMinecraftNamespace);
    }

    public RegistryHolderSerializer(Class<T> type, RegistryAccess registryAccess, ResourceKey<? extends Registry<T>> registryKey, boolean omitMinecraftNamespace) {
        this((TypeToken<T>)TypeToken.get(type), registryAccess, (ResourceKey<Registry<T>>)registryKey, omitMinecraftNamespace);
        Preconditions.checkArgument((type.getTypeParameters().length == 0 ? 1 : 0) != 0, (String)"%s must have 0 type parameters", type);
    }

    @Override
    protected Holder<T> convertFromResourceKey(ResourceKey<T> key) throws SerializationException {
        return (Holder)this.registry().get(key).orElseThrow(() -> new SerializationException("Missing holder in " + String.valueOf(this.registry().key()) + " with key " + String.valueOf(key)));
    }

    @Override
    protected ResourceKey<T> convertToResourceKey(Holder<T> value) {
        return value.unwrap().map(Function.identity(), r -> this.registry().getResourceKey(r).orElseThrow());
    }
}

