/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type;

import java.lang.reflect.AnnotatedType;
import java.util.Locale;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public record BooleanOrDefault(@Nullable Boolean value) {
    public static final BooleanOrDefault USE_DEFAULT = new BooleanOrDefault(null);
    public static final ScalarSerializer<BooleanOrDefault> SERIALIZER = new Serializer();
    private static final String DEFAULT_VALUE = "default";

    public boolean or(boolean fallback) {
        return this.value == null ? fallback : this.value;
    }

    private static final class Serializer
    extends ScalarSerializer.Annotated<BooleanOrDefault> {
        Serializer() {
            super(BooleanOrDefault.class);
        }

        public BooleanOrDefault deserialize(AnnotatedType type, Object obj) throws SerializationException {
            if (obj instanceof String) {
                String string = (String)obj;
                if (BooleanOrDefault.DEFAULT_VALUE.equalsIgnoreCase(string)) {
                    return USE_DEFAULT;
                }
                try {
                    return new BooleanOrDefault(BooleanUtils.toBoolean((String)string.toLowerCase(Locale.ROOT), (String)"true", (String)"false"));
                }
                catch (IllegalArgumentException ex) {
                    throw new SerializationException(BooleanOrDefault.class, String.valueOf(obj) + "(" + String.valueOf(type) + ") is not a boolean or 'default'", (Throwable)ex);
                }
            }
            if (obj instanceof Boolean) {
                Boolean bool = (Boolean)obj;
                return new BooleanOrDefault(bool);
            }
            throw new SerializationException(BooleanOrDefault.class, String.valueOf(obj) + "(" + String.valueOf(type) + ") is not a boolean or 'default'");
        }

        protected Object serialize(AnnotatedType type, BooleanOrDefault item, Predicate<Class<?>> typeSupported) {
            Boolean value = item.value;
            if (value != null) {
                return value.toString();
            }
            return BooleanOrDefault.DEFAULT_VALUE;
        }
    }
}

